/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.parameter.contributor;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.expando.kernel.service.permission.ExpandoColumnPermissionUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupModel;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.search.experiences.blueprint.parameter.SXPParameter;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributor;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributorDefinition;
import com.liferay.search.experiences.internal.blueprint.parameter.BooleanArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.BooleanSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.DateSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.DoubleArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.DoubleSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.FloatArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.FloatSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.IntegerArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.IntegerSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.LongArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.LongSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.StringArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.StringSXPParameter;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.context.Context;
import java.beans.ExceptionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UserSXPParameterContributor
implements SXPParameterContributor {
    private static final Log _log = LogFactoryUtil.getLog(UserSXPParameterContributor.class);
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetTagLocalService _assetTagLocalService;
    private final ExpandoColumnLocalService _expandoColumnLocalService;
    private final ExpandoValueLocalService _expandoValueLocalService;
    private final GroupLocalService _groupLocalService;
    private final Language _language;
    private final Portal _portal;
    private final SegmentsEntryRetriever _segmentsEntryRetriever;
    private final UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    private final UserGroupLocalService _userGroupLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final UserLocalService _userLocalService;

    public UserSXPParameterContributor(AssetCategoryLocalService assetCategoryLocalService, AssetTagLocalService assetTagLocalService, ExpandoColumnLocalService expandoColumnLocalService, ExpandoValueLocalService expandoValueLocalService, GroupLocalService groupLocalService, Language language, Portal portal, SegmentsEntryRetriever segmentsEntryRetriever, UserGroupGroupRoleLocalService userGroupGroupRoleLocalService, UserGroupLocalService userGroupLocalService, UserGroupRoleLocalService userGroupRoleLocalService, UserLocalService userLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetTagLocalService = assetTagLocalService;
        this._expandoColumnLocalService = expandoColumnLocalService;
        this._expandoValueLocalService = expandoValueLocalService;
        this._groupLocalService = groupLocalService;
        this._language = language;
        this._portal = portal;
        this._segmentsEntryRetriever = segmentsEntryRetriever;
        this._userGroupGroupRoleLocalService = userGroupGroupRoleLocalService;
        this._userGroupLocalService = userGroupLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._userLocalService = userLocalService;
    }

    public void contribute(ExceptionListener exceptionListener, SearchContext searchContext, Set<SXPParameter> sxpParameters) {
        try {
            this._contribute(searchContext, sxpParameters);
        }
        catch (PortalException portalException) {
            exceptionListener.exceptionThrown((Exception)((Object)portalException));
            _log.error((Throwable)portalException);
        }
    }

    public String getSXPParameterCategoryNameKey() {
        return "user";
    }

    public List<SXPParameterContributorDefinition> getSXPParameterContributorDefinitions(long companyId, Locale locale) {
        return this._getSXPParameterContributorDefinitions(companyId, locale, ListUtil.fromArray((Object[])new SXPParameterContributorDefinition[]{new SXPParameterContributorDefinition(LongArraySXPParameter.class, "active-segment-entry-ids", "user.active_segment_entry_ids"), new SXPParameterContributorDefinition(IntegerSXPParameter.class, "age", "user.age"), new SXPParameterContributorDefinition(LongArraySXPParameter.class, "asset-category-ids", "user.asset_category_ids"), new SXPParameterContributorDefinition(StringArraySXPParameter.class, "asset-tag-names", "user.asset_tag_names"), new SXPParameterContributorDefinition(DateSXPParameter.class, "birthday", "user.birthday"), new SXPParameterContributorDefinition(DateSXPParameter.class, "create-date", "user.create_date"), new SXPParameterContributorDefinition(LongArraySXPParameter.class, "current-site-role-ids", "user.current_site_role_ids"), new SXPParameterContributorDefinition(StringSXPParameter.class, "email-domain", "user.email_domain"), new SXPParameterContributorDefinition(StringSXPParameter.class, "external-reference-code", "user.external_reference_code"), new SXPParameterContributorDefinition(StringSXPParameter.class, "first-name", "user.first_name"), new SXPParameterContributorDefinition(StringSXPParameter.class, "full-name", "user.full_name"), new SXPParameterContributorDefinition(StringArraySXPParameter.class, "group-external-reference-codes", "user.group_external_reference_codes"), new SXPParameterContributorDefinition(LongArraySXPParameter.class, "group-ids", "user.group_ids"), new SXPParameterContributorDefinition(LongSXPParameter.class, "user-id", "user.id"), new SXPParameterContributorDefinition(BooleanSXPParameter.class, "is-female", "user.is_female"), new SXPParameterContributorDefinition(BooleanSXPParameter.class, "is-gender-x", "user.is_gender_x"), new SXPParameterContributorDefinition(BooleanSXPParameter.class, "is-male", "user.is_male"), new SXPParameterContributorDefinition(BooleanSXPParameter.class, "is-omniadmin", "user.is_omniadmin"), new SXPParameterContributorDefinition(BooleanSXPParameter.class, "is-signed-in", "user.is_signed_in"), new SXPParameterContributorDefinition(StringSXPParameter.class, "job-title", "user.job_title"), new SXPParameterContributorDefinition(StringSXPParameter.class, "language-id", "user.language_id"), new SXPParameterContributorDefinition(StringSXPParameter.class, "last-name", "user.last_name"), new SXPParameterContributorDefinition(LongArraySXPParameter.class, "parent-asset-category-ids", "user.parent_asset_category_ids"), new SXPParameterContributorDefinition(LongArraySXPParameter.class, "regular-role-ids", "user.regular_role_ids"), new SXPParameterContributorDefinition(StringArraySXPParameter.class, "user-group-external-reference-codes", "user.user_group_external_reference_codes"), new SXPParameterContributorDefinition(LongArraySXPParameter.class, "user-group-ids", "user.user_group_ids")}));
    }

    private void _addAssetCategories(Set<SXPParameter> sxpParameters, User user) {
        List assetCategories = this._assetCategoryLocalService.getCategories(user.getModelClassName(), user.getPrimaryKey());
        if (assetCategories.isEmpty()) {
            return;
        }
        ArrayList<Long> assetCategoryIds = new ArrayList<Long>();
        ArrayList<Long> parentAssetCategoryIds = new ArrayList<Long>();
        for (AssetCategory assetCategory : assetCategories) {
            assetCategoryIds.add(assetCategory.getCategoryId());
            if (assetCategory.getParentCategoryId() <= 0L) continue;
            parentAssetCategoryIds.addAll(this._getParentAssetCategoryIds(assetCategory.getParentCategory(), new ArrayList<Long>()));
        }
        sxpParameters.add(new LongArraySXPParameter("user.asset_category_ids", true, assetCategoryIds.toArray(new Long[0])));
        sxpParameters.add(new LongArraySXPParameter("user.parent_asset_category_ids", true, parentAssetCategoryIds.toArray(new Long[0])));
    }

    private void _addExpandoSXPParameters(SearchContext searchContext, Set<SXPParameter> sxpParameters, User user) throws PortalException {
        List expandoColumns = this._expandoColumnLocalService.getDefaultTableColumns(searchContext.getCompanyId(), User.class.getName());
        if (ListUtil.isEmpty((List)expandoColumns)) {
            return;
        }
        HashMap<Long, ExpandoValue> expandoValues = new HashMap<Long, ExpandoValue>();
        for (ExpandoValue expandoValue : this._expandoValueLocalService.getRowValues(searchContext.getCompanyId(), User.class.getName(), "CUSTOM_FIELDS", user.getPrimaryKey(), -1, -1)) {
            expandoValues.put(expandoValue.getColumnId(), expandoValue);
        }
        for (ExpandoColumn expandoColumn : expandoColumns) {
            ExpandoValue expandoValue = (ExpandoValue)expandoValues.get(expandoColumn.getColumnId());
            if (expandoValue == null) {
                expandoValue = this._expandoValueLocalService.createExpandoValue(0L);
                expandoValue.setData(expandoColumn.getDefaultData());
            }
            String expandoSXPParameterName = this._getExpandoSXPParameterName(expandoColumn);
            int type = expandoColumn.getType();
            if (type == 1) {
                sxpParameters.add(new BooleanSXPParameter(expandoSXPParameterName, true, expandoValue.getBoolean()));
                continue;
            }
            if (type == 2) {
                sxpParameters.add(new BooleanArraySXPParameter(expandoSXPParameterName, true, ArrayUtil.toArray((boolean[])expandoValue.getBooleanArray())));
                continue;
            }
            if (type == 3) {
                sxpParameters.add(new DateSXPParameter(expandoSXPParameterName, true, expandoValue.getDate()));
                continue;
            }
            if (type == 5) {
                sxpParameters.add(new DoubleSXPParameter(expandoSXPParameterName, true, expandoValue.getDouble()));
                continue;
            }
            if (type == 6) {
                sxpParameters.add(new DoubleArraySXPParameter(expandoSXPParameterName, true, ArrayUtil.toArray((double[])expandoValue.getDoubleArray())));
                continue;
            }
            if (type == 7) {
                sxpParameters.add(new FloatSXPParameter(expandoSXPParameterName, true, Float.valueOf(expandoValue.getFloat())));
                continue;
            }
            if (type == 8) {
                sxpParameters.add(new FloatArraySXPParameter(expandoSXPParameterName, true, ArrayUtil.toArray((float[])expandoValue.getFloatArray())));
                continue;
            }
            if (type == 21) {
                JSONObject jsonObject = expandoValue.getGeolocationJSONObject();
                sxpParameters.add(new DoubleSXPParameter(expandoSXPParameterName + ".latitude", true, jsonObject.getDouble("latitude")));
                sxpParameters.add(new DoubleSXPParameter(expandoSXPParameterName + ".longitude", true, jsonObject.getDouble("longitude")));
                continue;
            }
            if (type == 9) {
                sxpParameters.add(new IntegerSXPParameter(expandoSXPParameterName, true, expandoValue.getInteger()));
                continue;
            }
            if (type == 10) {
                sxpParameters.add(new IntegerArraySXPParameter(expandoSXPParameterName, true, ArrayUtil.toArray((int[])expandoValue.getIntegerArray())));
                continue;
            }
            if (type == 11) {
                sxpParameters.add(new LongSXPParameter(expandoSXPParameterName, true, expandoValue.getLong()));
                continue;
            }
            if (type == 12) {
                sxpParameters.add(new LongArraySXPParameter(expandoSXPParameterName, true, ArrayUtil.toArray((long[])expandoValue.getLongArray())));
                continue;
            }
            if (type == 17) {
                sxpParameters.add(new StringSXPParameter(expandoSXPParameterName, true, expandoValue.getData()));
                continue;
            }
            if (type == 18) {
                sxpParameters.add(new StringArraySXPParameter(expandoSXPParameterName, true, StringUtil.split((String)expandoValue.getData())));
                continue;
            }
            if (type == 13) {
                sxpParameters.add(new IntegerSXPParameter(expandoSXPParameterName, true, GetterUtil.getInteger((Object)expandoValue.getShort())));
                continue;
            }
            if (type == 14) {
                short[] shortArray = expandoValue.getShortArray();
                Integer[] integerArray = new Integer[shortArray.length];
                for (int i = 0; i < shortArray.length; ++i) {
                    integerArray[i] = shortArray[i];
                }
                sxpParameters.add(new IntegerArraySXPParameter(expandoSXPParameterName, true, integerArray));
                continue;
            }
            if (type == 15) {
                sxpParameters.add(new StringSXPParameter(expandoSXPParameterName, true, expandoValue.getString()));
                continue;
            }
            if (type == 16) {
                sxpParameters.add(new StringArraySXPParameter(expandoSXPParameterName, true, expandoValue.getStringArray()));
                continue;
            }
            if (type == 19) {
                sxpParameters.add(new StringArraySXPParameter(StringBundler.concat((String[])new String[]{expandoSXPParameterName, "_", this._language.getLanguageId(searchContext.getLocale())}), true, expandoValue.getStringArray(searchContext.getLocale())));
                continue;
            }
            if (type != 20) continue;
            sxpParameters.add(new StringSXPParameter(StringBundler.concat((String[])new String[]{expandoSXPParameterName, "_", this._language.getLanguageId(searchContext.getLocale())}), true, expandoValue.getString(searchContext.getLocale())));
        }
    }

    private void _contribute(final SearchContext searchContext, Set<SXPParameter> sxpParameters) throws PortalException {
        long userId = searchContext.getUserId();
        if (userId == 0L) {
            return;
        }
        final User user = this._userLocalService.fetchUserById(userId);
        if (user == null) {
            return;
        }
        long[] segmentsEntryIds = new long[]{};
        long scopeGroupId = GetterUtil.getLong((Object)searchContext.getAttribute("search.experiences.scope.group.id"));
        if (scopeGroupId != 0L) {
            segmentsEntryIds = this._segmentsEntryRetriever.getSegmentsEntryIds(scopeGroupId, user.getUserId(), new Context(){
                {
                    this.put("languageId", (Serializable)((Object)UserSXPParameterContributor.this._language.getLanguageId(searchContext.getLocale())));
                    this.put("signedIn", Boolean.valueOf(!user.isGuestUser()));
                }
            }, new long[0]);
            segmentsEntryIds = ArrayUtil.filter((long[])segmentsEntryIds, segmentsEntryId -> segmentsEntryId > 0L);
        }
        sxpParameters.add(new LongArraySXPParameter("user.active_segment_entry_ids", true, ArrayUtil.toLongArray((long[])segmentsEntryIds)));
        sxpParameters.add(new IntegerSXPParameter("user.age", true, this._getAge(user.getBirthday())));
        sxpParameters.add(new StringArraySXPParameter("user.asset_tag_names", true, this._getAssetTagNames(user)));
        sxpParameters.add(new DateSXPParameter("user.birthday", true, user.getBirthday()));
        sxpParameters.add(new DateSXPParameter("user.create_date", true, user.getCreateDate()));
        sxpParameters.add(new LongArraySXPParameter("user.current_site_role_ids", true, this._getCurrentSiteRoleIds(scopeGroupId, user)));
        sxpParameters.add(new StringSXPParameter("user.email_domain", true, this._getEmailAddressDomain(user)));
        sxpParameters.add(new StringSXPParameter("user.external_reference_code", true, user.getExternalReferenceCode()));
        sxpParameters.add(new StringSXPParameter("user.first_name", true, user.getFirstName()));
        sxpParameters.add(new StringSXPParameter("user.full_name", true, user.getFullName()));
        List groups = this._groupLocalService.getGroups(user.getGroupIds());
        if (!groups.isEmpty()) {
            sxpParameters.add(new StringArraySXPParameter("user.group_external_reference_codes", true, (String[])TransformUtil.transformToArray((Collection)groups, GroupModel::getExternalReferenceCode, String.class)));
        }
        sxpParameters.add(new LongArraySXPParameter("user.group_ids", true, ArrayUtil.toLongArray((long[])user.getGroupIds())));
        sxpParameters.add(new LongSXPParameter("user.id", true, user.getUserId()));
        sxpParameters.add(new BooleanSXPParameter("user.is_female", true, user.isFemale()));
        sxpParameters.add(new BooleanSXPParameter("user.is_gender_x", true, !user.isFemale() && !user.isMale()));
        sxpParameters.add(new BooleanSXPParameter("user.is_male", true, user.isMale()));
        sxpParameters.add(new BooleanSXPParameter("user.is_omniadmin", true, this._portal.isOmniadmin(user.getUserId())));
        sxpParameters.add(new BooleanSXPParameter("user.is_signed_in", true, !user.isGuestUser()));
        sxpParameters.add(new StringSXPParameter("user.job_title", true, user.getJobTitle()));
        sxpParameters.add(new StringSXPParameter("user.language_id", true, user.getLanguageId()));
        sxpParameters.add(new StringSXPParameter("user.last_name", true, user.getLastName()));
        sxpParameters.add(new LongArraySXPParameter("user.regular_role_ids", true, this._getRegularRoleIds(user)));
        List userGroups = this._userGroupLocalService.getUserUserGroups(userId);
        if (!userGroups.isEmpty()) {
            sxpParameters.add(new StringArraySXPParameter("user.user_group_external_reference_codes", true, (String[])TransformUtil.transformToArray((Collection)userGroups, UserGroupModel::getExternalReferenceCode, String.class)));
            sxpParameters.add(new LongArraySXPParameter("user.user_group_ids", true, (Long[])TransformUtil.transformToArray((Collection)userGroups, UserGroupModel::getUserGroupId, Long.class)));
        }
        this._addAssetCategories(sxpParameters, user);
        this._addExpandoSXPParameters(searchContext, sxpParameters, user);
    }

    private int _getAge(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int x = GetterUtil.getInteger((String)dateFormat.format(date));
        int y = GetterUtil.getInteger((String)dateFormat.format(new Date()));
        return (y - x) / 10000;
    }

    private String[] _getAssetTagNames(User user) {
        List assetTags = this._assetTagLocalService.getTags(user.getModelClassName(), user.getPrimaryKey());
        return (String[])ListUtil.toArray((List)assetTags, (Accessor)AssetTag.NAME_ACCESSOR);
    }

    private Long[] _getCurrentSiteRoleIds(Long scopeGroupId, User user) {
        ArrayList<Long> roleIds = new ArrayList<Long>();
        List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId());
        for (UserGroupRole userGroupRole : userGroupRoles) {
            roleIds.add(userGroupRole.getRoleId());
        }
        if (scopeGroupId != null) {
            List userGroupGroupRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByUser(user.getUserId(), scopeGroupId.longValue());
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                roleIds.add(userGroupGroupRole.getRoleId());
            }
        }
        return roleIds.toArray(new Long[0]);
    }

    private String _getEmailAddressDomain(User user) {
        String emailAddress = user.getEmailAddress();
        return emailAddress.substring(emailAddress.indexOf("@") + 1);
    }

    private String _getExpandoSXPParameterName(ExpandoColumn expandoColumn) {
        StringBundler sb = new StringBundler(2);
        sb.append("user.custom.field.");
        sb.append(StringUtil.toLowerCase((String)StringUtil.replace((String)expandoColumn.getName(), (String)"", (String)"_")));
        return sb.toString();
    }

    private String _getExpandoSXPParameterName(ExpandoColumn expandoColumn, Locale locale) {
        return StringBundler.concat((String[])new String[]{this._getExpandoSXPParameterName(expandoColumn), "_", this._language.getLanguageId(locale)});
    }

    private List<Long> _getParentAssetCategoryIds(AssetCategory assetCategory, List<Long> parentAssetCategoryIds) {
        parentAssetCategoryIds.add(assetCategory.getCategoryId());
        if (assetCategory.getParentCategoryId() > 0L) {
            this._getParentAssetCategoryIds(assetCategory.getParentCategory(), parentAssetCategoryIds);
        }
        return parentAssetCategoryIds;
    }

    private Long[] _getRegularRoleIds(User user) throws PortalException {
        long[] roleIds = user.getRoleIds();
        List userGroups = this._userGroupLocalService.getUserUserGroups(user.getUserId());
        for (UserGroup userGroup : userGroups) {
            roleIds = ArrayUtil.append((long[][])new long[][]{roleIds, this._groupLocalService.getRolePrimaryKeys(userGroup.getGroupId())});
        }
        return ArrayUtil.toLongArray((long[])roleIds);
    }

    private List<SXPParameterContributorDefinition> _getSXPParameterContributorDefinitions(long companyId, Locale locale, List<SXPParameterContributorDefinition> sxpParameterContributorDefinitions) {
        List expandoColumns = this._expandoColumnLocalService.getDefaultTableColumns(companyId, User.class.getName());
        if (ListUtil.isEmpty((List)expandoColumns)) {
            return sxpParameterContributorDefinitions;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        for (ExpandoColumn expandoColumn : expandoColumns) {
            if (PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_READ_CHECK_BY_DEFAULT && !ExpandoColumnPermissionUtil.contains((PermissionChecker)permissionChecker, (long)companyId, (String)User.class.getName(), (String)"CUSTOM_FIELDS", (String)expandoColumn.getName(), (String)"VIEW")) continue;
            String expandoSXPParameterName = this._getExpandoSXPParameterName(expandoColumn);
            int type = expandoColumn.getType();
            if (type == 1) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(BooleanSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 3) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(DateSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 5) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(DoubleSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 6) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(DoubleArraySXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 7) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(FloatSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 8) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(FloatArraySXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 21) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(FloatSXPParameter.class, StringBundler.concat((String[])new String[]{expandoColumn.getDisplayName(locale), " (", this._language.get(locale, "latitude"), ")"}), expandoSXPParameterName + ".latitude"));
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(FloatSXPParameter.class, StringBundler.concat((String[])new String[]{expandoColumn.getDisplayName(locale), " (", this._language.get(locale, "longitude"), ")"}), expandoSXPParameterName + ".longitude"));
                continue;
            }
            if (type == 9) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(IntegerSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 10) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(IntegerArraySXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 11) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(LongSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 12) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(LongArraySXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 17) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(StringSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 18) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(StringArraySXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 13) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(IntegerSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 14) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(IntegerArraySXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 15) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(StringSXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 16) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(StringArraySXPParameter.class, expandoColumn.getDisplayName(locale), expandoSXPParameterName));
                continue;
            }
            if (type == 19) {
                sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(StringArraySXPParameter.class, StringBundler.concat((String[])new String[]{expandoColumn.getDisplayName(locale), " (", this._language.get(locale, "localized"), ")"}), this._getExpandoSXPParameterName(expandoColumn, locale)));
                continue;
            }
            if (type != 20) continue;
            sxpParameterContributorDefinitions.add(new SXPParameterContributorDefinition(StringSXPParameter.class, StringBundler.concat((String[])new String[]{expandoColumn.getDisplayName(locale), " (", this._language.get(locale, "localized"), ")"}), this._getExpandoSXPParameterName(expandoColumn, locale)));
        }
        return sxpParameterContributorDefinitions;
    }
}

