/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.parameter.contributor;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.configuration.SemanticSearchConfiguration;
import com.liferay.portal.search.configuration.SemanticSearchConfigurationProvider;
import com.liferay.portal.search.ml.embedding.text.TextEmbeddingRetriever;
import com.liferay.portal.search.rest.dto.v1_0.EmbeddingProviderConfiguration;
import com.liferay.search.experiences.blueprint.parameter.SXPParameter;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributor;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributorDefinition;
import com.liferay.search.experiences.internal.blueprint.parameter.DoubleArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.IntegerSXPParameter;
import java.beans.ExceptionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class MLSXPParameterContributor
implements SXPParameterContributor {
    private final Language _language;
    private final SemanticSearchConfigurationProvider _semanticSearchConfigurationProvider;
    private final TextEmbeddingRetriever _textEmbeddingRetriever;

    public MLSXPParameterContributor(Language language, SemanticSearchConfigurationProvider semanticSearchConfigurationProvider, TextEmbeddingRetriever textEmbeddingRetriever) {
        this._language = language;
        this._semanticSearchConfigurationProvider = semanticSearchConfigurationProvider;
        this._textEmbeddingRetriever = textEmbeddingRetriever;
    }

    public void contribute(ExceptionListener exceptionListener, SearchContext searchContext, Set<SXPParameter> sxpParameters) {
        this._addTextEmbeddingParameters(exceptionListener, searchContext, sxpParameters);
    }

    public String getSXPParameterCategoryNameKey() {
        return "ml";
    }

    public List<SXPParameterContributorDefinition> getSXPParameterContributorDefinitions(long companyId, Locale locale) {
        return this._getTextEmbeddingParameterContributorDefinitions(companyId, locale);
    }

    private void _addTextEmbeddingParameters(ExceptionListener exceptionListener, SearchContext searchContext, Set<SXPParameter> sxpParameters) {
        EmbeddingProviderConfiguration embeddingProviderConfiguration = this._getEmbeddingProviderConfiguration(exceptionListener, this._getSemanticSearchConfiguration(searchContext.getCompanyId()));
        if (embeddingProviderConfiguration == null) {
            return;
        }
        sxpParameters.add(new IntegerSXPParameter("ml.text_embeddings.vector_dimensions", true, embeddingProviderConfiguration.getEmbeddingVectorDimensions()));
        Object[] textEmbedding = this._textEmbeddingRetriever.getTextEmbedding(embeddingProviderConfiguration.getProviderName(), searchContext.getKeywords());
        if (ArrayUtil.isEmpty((Object[])textEmbedding)) {
            return;
        }
        sxpParameters.add(new DoubleArraySXPParameter("ml.text_embeddings.keywords_embedding", true, (Double[])textEmbedding));
    }

    private EmbeddingProviderConfiguration _getEmbeddingProviderConfiguration(ExceptionListener exceptionListener, SemanticSearchConfiguration semanticSearchConfiguration) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-122920") || !semanticSearchConfiguration.textEmbeddingsEnabled()) {
            return null;
        }
        try {
            String[] stringArray = semanticSearchConfiguration.textEmbeddingProviderConfigurationJSONs();
            int n = stringArray.length;
            int n2 = 0;
            if (n2 < n) {
                String textEmbeddingProviderConfigurationJSON = stringArray[n2];
                return EmbeddingProviderConfiguration.unsafeToDTO((String)textEmbeddingProviderConfigurationJSON);
            }
        }
        catch (Exception exception) {
            if (exceptionListener != null) {
                exceptionListener.exceptionThrown(exception);
            }
            return (EmbeddingProviderConfiguration)ReflectionUtil.throwException((Throwable)exception);
        }
        return null;
    }

    private EmbeddingProviderConfiguration _getEmbeddingProviderConfiguration(SemanticSearchConfiguration semanticSearchConfiguration) {
        return this._getEmbeddingProviderConfiguration(null, semanticSearchConfiguration);
    }

    private SemanticSearchConfiguration _getSemanticSearchConfiguration(long companyId) {
        return this._semanticSearchConfigurationProvider.getCompanyConfiguration(companyId);
    }

    private List<SXPParameterContributorDefinition> _getTextEmbeddingParameterContributorDefinitions(long companyId, Locale locale) {
        EmbeddingProviderConfiguration embeddingProviderConfiguration = this._getEmbeddingProviderConfiguration(this._getSemanticSearchConfiguration(companyId));
        if (embeddingProviderConfiguration == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(new SXPParameterContributorDefinition(IntegerSXPParameter.class, StringBundler.concat((String[])new String[]{this._language.get(locale, "text-embedding-vector-dimensions"), " (", embeddingProviderConfiguration.getProviderName(), ")"}), "ml.text_embeddings.vector_dimensions"), new SXPParameterContributorDefinition(DoubleArraySXPParameter.class, StringBundler.concat((String[])new String[]{this._language.get(locale, "keywords-embedding"), " (", embeddingProviderConfiguration.getProviderName(), ")"}), "ml.text_embeddings.keywords_embedding"));
    }
}

