/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.parameter;

import com.liferay.petra.string.StringBundler;
import com.liferay.search.experiences.blueprint.parameter.SXPParameter;
import java.util.Map;
import java.util.Objects;

public abstract class BaseSXPParameter
implements SXPParameter {
    protected final String name;
    protected final boolean templateVariable;

    public BaseSXPParameter(String name, boolean templateVariable) {
        this.name = name;
        this.templateVariable = templateVariable;
    }

    public boolean equals(Object object) {
        SXPParameter sxpParameter = (SXPParameter)object;
        return Objects.equals(this.name, sxpParameter.getName());
    }

    public boolean evaluateContains(Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean evaluateEquals(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean evaluateEquals(String format, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean evaluateIn(Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean evaluateRange(Object gt, Object gte, Object lt, Object lte) {
        throw new UnsupportedOperationException();
    }

    public boolean evaluateRange(String format, Object gt, Object gte, Object lt, Object lte) {
        throw new UnsupportedOperationException();
    }

    public String evaluateToString(Map<String, String> options) {
        return String.valueOf(this.getValue());
    }

    public String getName() {
        return this.name;
    }

    public String getTemplateVariable() {
        if (this.isTemplateVariable()) {
            return "${" + this.name + "}";
        }
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isTemplateVariable() {
        return this.templateVariable;
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        return StringBundler.concat((Object[])new Object[]{"{className=", clazz.getSimpleName(), ", name=", this.name, ", templateVariable=", this.templateVariable, ", value=", this.evaluateToString(null), "}"});
    }
}

