/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.highlight;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.highlight.FieldConfigBuilderFactory;
import com.liferay.portal.search.highlight.Highlight;
import com.liferay.portal.search.highlight.HighlightBuilder;
import com.liferay.portal.search.highlight.HighlightBuilderFactory;
import com.liferay.search.experiences.rest.dto.v1_0.HighlightConfiguration;
import java.util.Map;

public class HighlightConverter {
    private final FieldConfigBuilderFactory _fieldConfigBuilderFactory;
    private final HighlightBuilderFactory _highlightBuilderFactory;

    public HighlightConverter(FieldConfigBuilderFactory fieldConfigBuilderFactory, HighlightBuilderFactory highlightBuilderFactory) {
        this._fieldConfigBuilderFactory = fieldConfigBuilderFactory;
        this._highlightBuilderFactory = highlightBuilderFactory;
    }

    public Highlight toHighlight(HighlightConfiguration highlightConfiguration) {
        HighlightBuilder highlightBuilder = this._highlightBuilderFactory.builder();
        Map highlightFields = highlightConfiguration.getFields();
        MapUtil.isNotEmptyForEach((Map)highlightFields, (name, highlightField) -> highlightBuilder.addFieldConfig(this._fieldConfigBuilderFactory.builder(name).fragmentOffset(highlightField.getFragment_offset()).fragmentSize(highlightField.getFragment_size()).numFragments(highlightField.getNumber_of_fragments()).build()));
        highlightBuilder.fragmentSize(highlightConfiguration.getFragment_size()).highlighterType(highlightConfiguration.getType()).numOfFragments(highlightConfiguration.getNumber_of_fragments()).postTags(highlightConfiguration.getPost_tags()).preTags(highlightConfiguration.getPre_tags()).requireFieldMatch(highlightConfiguration.getRequire_field_match());
        return highlightBuilder.build();
    }

    public Highlight toHighlight(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HighlightConfiguration highlightConfiguration = HighlightConfiguration.toDTO((String)jsonObject.toString());
        return this.toHighlight(highlightConfiguration);
    }
}

