/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.search.experiences.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.model.SXPBlueprintModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SXPBlueprint service. Represents a row in the &quot;SXPBlueprint&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SXPBlueprintModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SXPBlueprintImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SXPBlueprintImpl
 * @generated
 */
@JSON(strict = true)
public class SXPBlueprintModelImpl
	extends BaseModelImpl<SXPBlueprint> implements SXPBlueprintModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sxp blueprint model instance should use the <code>SXPBlueprint</code> interface instead.
	 */
	public static final String TABLE_NAME = "SXPBlueprint";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"sxpBlueprintId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"configurationJSON", Types.CLOB}, {"description", Types.VARCHAR},
		{"elementInstancesJSON", Types.CLOB}, {"schemaVersion", Types.VARCHAR},
		{"title", Types.VARCHAR}, {"version", Types.VARCHAR},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("sxpBlueprintId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("configurationJSON", Types.CLOB);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("elementInstancesJSON", Types.CLOB);
		TABLE_COLUMNS_MAP.put("schemaVersion", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SXPBlueprint (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,sxpBlueprintId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,configurationJSON TEXT null,description STRING null,elementInstancesJSON TEXT null,schemaVersion VARCHAR(75) null,title STRING null,version VARCHAR(75) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table SXPBlueprint";

	public static final String ORDER_BY_JPQL =
		" ORDER BY sxpBlueprint.sxpBlueprintId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SXPBlueprint.sxpBlueprintId ASC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY sxpBlueprint.sxpBlueprintId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SXPBLUEPRINTID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public SXPBlueprintModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _sxpBlueprintId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSXPBlueprintId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _sxpBlueprintId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SXPBlueprint.class;
	}

	@Override
	public String getModelClassName() {
		return SXPBlueprint.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SXPBlueprint, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SXPBlueprint, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SXPBlueprint, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SXPBlueprint)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SXPBlueprint, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SXPBlueprint, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SXPBlueprint)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SXPBlueprint, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SXPBlueprint, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<SXPBlueprint, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<SXPBlueprint, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<SXPBlueprint, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", SXPBlueprint::getMvccVersion);
			attributeGetterFunctions.put("uuid", SXPBlueprint::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				SXPBlueprint::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"sxpBlueprintId", SXPBlueprint::getSXPBlueprintId);
			attributeGetterFunctions.put(
				"companyId", SXPBlueprint::getCompanyId);
			attributeGetterFunctions.put("userId", SXPBlueprint::getUserId);
			attributeGetterFunctions.put("userName", SXPBlueprint::getUserName);
			attributeGetterFunctions.put(
				"createDate", SXPBlueprint::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", SXPBlueprint::getModifiedDate);
			attributeGetterFunctions.put(
				"configurationJSON", SXPBlueprint::getConfigurationJSON);
			attributeGetterFunctions.put(
				"description", SXPBlueprint::getDescription);
			attributeGetterFunctions.put(
				"elementInstancesJSON", SXPBlueprint::getElementInstancesJSON);
			attributeGetterFunctions.put(
				"schemaVersion", SXPBlueprint::getSchemaVersion);
			attributeGetterFunctions.put("title", SXPBlueprint::getTitle);
			attributeGetterFunctions.put("version", SXPBlueprint::getVersion);
			attributeGetterFunctions.put("status", SXPBlueprint::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", SXPBlueprint::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", SXPBlueprint::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", SXPBlueprint::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<SXPBlueprint, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<SXPBlueprint, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<SXPBlueprint, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<SXPBlueprint, Long>)SXPBlueprint::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<SXPBlueprint, String>)SXPBlueprint::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<SXPBlueprint, String>)
					SXPBlueprint::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"sxpBlueprintId",
				(BiConsumer<SXPBlueprint, Long>)
					SXPBlueprint::setSXPBlueprintId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<SXPBlueprint, Long>)SXPBlueprint::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<SXPBlueprint, Long>)SXPBlueprint::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<SXPBlueprint, String>)SXPBlueprint::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<SXPBlueprint, Date>)SXPBlueprint::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<SXPBlueprint, Date>)SXPBlueprint::setModifiedDate);
			attributeSetterBiConsumers.put(
				"configurationJSON",
				(BiConsumer<SXPBlueprint, String>)
					SXPBlueprint::setConfigurationJSON);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<SXPBlueprint, String>)SXPBlueprint::setDescription);
			attributeSetterBiConsumers.put(
				"elementInstancesJSON",
				(BiConsumer<SXPBlueprint, String>)
					SXPBlueprint::setElementInstancesJSON);
			attributeSetterBiConsumers.put(
				"schemaVersion",
				(BiConsumer<SXPBlueprint, String>)
					SXPBlueprint::setSchemaVersion);
			attributeSetterBiConsumers.put(
				"title",
				(BiConsumer<SXPBlueprint, String>)SXPBlueprint::setTitle);
			attributeSetterBiConsumers.put(
				"version",
				(BiConsumer<SXPBlueprint, String>)SXPBlueprint::setVersion);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<SXPBlueprint, Integer>)SXPBlueprint::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<SXPBlueprint, Long>)
					SXPBlueprint::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<SXPBlueprint, String>)
					SXPBlueprint::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<SXPBlueprint, Date>)SXPBlueprint::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getSXPBlueprintId() {
		return _sxpBlueprintId;
	}

	@Override
	public void setSXPBlueprintId(long sxpBlueprintId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sxpBlueprintId = sxpBlueprintId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getConfigurationJSON() {
		if (_configurationJSON == null) {
			return "";
		}
		else {
			return _configurationJSON;
		}
	}

	@Override
	public void setConfigurationJSON(String configurationJSON) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_configurationJSON = configurationJSON;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getDescription(), languageId, useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setDescription(
		String description, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(
				LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(
				LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getDefault());
	}

	@Override
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale) {

		if (descriptionMap == null) {
			return;
		}

		setDescription(
			LocalizationUtil.updateLocalization(
				descriptionMap, getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getElementInstancesJSON() {
		if (_elementInstancesJSON == null) {
			return "";
		}
		else {
			return _elementInstancesJSON;
		}
	}

	@Override
	public void setElementInstancesJSON(String elementInstancesJSON) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_elementInstancesJSON = elementInstancesJSON;
	}

	@JSON
	@Override
	public String getSchemaVersion() {
		if (_schemaVersion == null) {
			return "";
		}
		else {
			return _schemaVersion;
		}
	}

	@Override
	public void setSchemaVersion(String schemaVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_schemaVersion = schemaVersion;
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public String getTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId);
	}

	@Override
	public String getTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId, useDefault);
	}

	@Override
	public String getTitle(String languageId) {
		return LocalizationUtil.getLocalization(getTitle(), languageId);
	}

	@Override
	public String getTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getTitle(), languageId, useDefault);
	}

	@Override
	public String getTitleCurrentLanguageId() {
		return _titleCurrentLanguageId;
	}

	@JSON
	@Override
	public String getTitleCurrentValue() {
		Locale locale = getLocale(_titleCurrentLanguageId);

		return getTitle(locale);
	}

	@Override
	public Map<Locale, String> getTitleMap() {
		return LocalizationUtil.getLocalizationMap(getTitle());
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@Override
	public void setTitle(String title, Locale locale) {
		setTitle(title, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setTitle(String title, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(title)) {
			setTitle(
				LocalizationUtil.updateLocalization(
					getTitle(), "Title", title, languageId, defaultLanguageId));
		}
		else {
			setTitle(
				LocalizationUtil.removeLocalization(
					getTitle(), "Title", languageId));
		}
	}

	@Override
	public void setTitleCurrentLanguageId(String languageId) {
		_titleCurrentLanguageId = languageId;
	}

	@Override
	public void setTitleMap(Map<Locale, String> titleMap) {
		setTitleMap(titleMap, LocaleUtil.getDefault());
	}

	@Override
	public void setTitleMap(
		Map<Locale, String> titleMap, Locale defaultLocale) {

		if (titleMap == null) {
			return;
		}

		setTitle(
			LocalizationUtil.updateLocalization(
				titleMap, getTitle(), "Title",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(SXPBlueprint.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SXPBlueprint.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> titleMap = getTitleMap();

		for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getDescription();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			SXPBlueprint.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(
				getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(
				getDescription(defaultLocale), defaultLocale, defaultLocale);
		}

		String title = getTitle(defaultLocale);

		if (Validator.isNull(title)) {
			setTitle(getTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTitle(getTitle(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public SXPBlueprint toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SXPBlueprint>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SXPBlueprintImpl sxpBlueprintImpl = new SXPBlueprintImpl();

		sxpBlueprintImpl.setMvccVersion(getMvccVersion());
		sxpBlueprintImpl.setUuid(getUuid());
		sxpBlueprintImpl.setExternalReferenceCode(getExternalReferenceCode());
		sxpBlueprintImpl.setSXPBlueprintId(getSXPBlueprintId());
		sxpBlueprintImpl.setCompanyId(getCompanyId());
		sxpBlueprintImpl.setUserId(getUserId());
		sxpBlueprintImpl.setUserName(getUserName());
		sxpBlueprintImpl.setCreateDate(getCreateDate());
		sxpBlueprintImpl.setModifiedDate(getModifiedDate());
		sxpBlueprintImpl.setConfigurationJSON(getConfigurationJSON());
		sxpBlueprintImpl.setDescription(getDescription());
		sxpBlueprintImpl.setElementInstancesJSON(getElementInstancesJSON());
		sxpBlueprintImpl.setSchemaVersion(getSchemaVersion());
		sxpBlueprintImpl.setTitle(getTitle());
		sxpBlueprintImpl.setVersion(getVersion());
		sxpBlueprintImpl.setStatus(getStatus());
		sxpBlueprintImpl.setStatusByUserId(getStatusByUserId());
		sxpBlueprintImpl.setStatusByUserName(getStatusByUserName());
		sxpBlueprintImpl.setStatusDate(getStatusDate());

		sxpBlueprintImpl.resetOriginalValues();

		return sxpBlueprintImpl;
	}

	@Override
	public SXPBlueprint cloneWithOriginalValues() {
		SXPBlueprintImpl sxpBlueprintImpl = new SXPBlueprintImpl();

		sxpBlueprintImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		sxpBlueprintImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		sxpBlueprintImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		sxpBlueprintImpl.setSXPBlueprintId(
			this.<Long>getColumnOriginalValue("sxpBlueprintId"));
		sxpBlueprintImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		sxpBlueprintImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		sxpBlueprintImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		sxpBlueprintImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		sxpBlueprintImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		sxpBlueprintImpl.setConfigurationJSON(
			this.<String>getColumnOriginalValue("configurationJSON"));
		sxpBlueprintImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		sxpBlueprintImpl.setElementInstancesJSON(
			this.<String>getColumnOriginalValue("elementInstancesJSON"));
		sxpBlueprintImpl.setSchemaVersion(
			this.<String>getColumnOriginalValue("schemaVersion"));
		sxpBlueprintImpl.setTitle(this.<String>getColumnOriginalValue("title"));
		sxpBlueprintImpl.setVersion(
			this.<String>getColumnOriginalValue("version"));
		sxpBlueprintImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		sxpBlueprintImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		sxpBlueprintImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		sxpBlueprintImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return sxpBlueprintImpl;
	}

	@Override
	public int compareTo(SXPBlueprint sxpBlueprint) {
		long primaryKey = sxpBlueprint.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SXPBlueprint)) {
			return false;
		}

		SXPBlueprint sxpBlueprint = (SXPBlueprint)object;

		long primaryKey = sxpBlueprint.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SXPBlueprint> toCacheModel() {
		SXPBlueprintCacheModel sxpBlueprintCacheModel =
			new SXPBlueprintCacheModel();

		sxpBlueprintCacheModel.mvccVersion = getMvccVersion();

		sxpBlueprintCacheModel.uuid = getUuid();

		String uuid = sxpBlueprintCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			sxpBlueprintCacheModel.uuid = null;
		}

		sxpBlueprintCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			sxpBlueprintCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			sxpBlueprintCacheModel.externalReferenceCode = null;
		}

		sxpBlueprintCacheModel.sxpBlueprintId = getSXPBlueprintId();

		sxpBlueprintCacheModel.companyId = getCompanyId();

		sxpBlueprintCacheModel.userId = getUserId();

		sxpBlueprintCacheModel.userName = getUserName();

		String userName = sxpBlueprintCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			sxpBlueprintCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			sxpBlueprintCacheModel.createDate = createDate.getTime();
		}
		else {
			sxpBlueprintCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			sxpBlueprintCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			sxpBlueprintCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		sxpBlueprintCacheModel.configurationJSON = getConfigurationJSON();

		String configurationJSON = sxpBlueprintCacheModel.configurationJSON;

		if ((configurationJSON != null) && (configurationJSON.length() == 0)) {
			sxpBlueprintCacheModel.configurationJSON = null;
		}

		sxpBlueprintCacheModel.description = getDescription();

		String description = sxpBlueprintCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			sxpBlueprintCacheModel.description = null;
		}

		sxpBlueprintCacheModel.elementInstancesJSON = getElementInstancesJSON();

		String elementInstancesJSON =
			sxpBlueprintCacheModel.elementInstancesJSON;

		if ((elementInstancesJSON != null) &&
			(elementInstancesJSON.length() == 0)) {

			sxpBlueprintCacheModel.elementInstancesJSON = null;
		}

		sxpBlueprintCacheModel.schemaVersion = getSchemaVersion();

		String schemaVersion = sxpBlueprintCacheModel.schemaVersion;

		if ((schemaVersion != null) && (schemaVersion.length() == 0)) {
			sxpBlueprintCacheModel.schemaVersion = null;
		}

		sxpBlueprintCacheModel.title = getTitle();

		String title = sxpBlueprintCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			sxpBlueprintCacheModel.title = null;
		}

		sxpBlueprintCacheModel.version = getVersion();

		String version = sxpBlueprintCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			sxpBlueprintCacheModel.version = null;
		}

		sxpBlueprintCacheModel.status = getStatus();

		sxpBlueprintCacheModel.statusByUserId = getStatusByUserId();

		sxpBlueprintCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = sxpBlueprintCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			sxpBlueprintCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			sxpBlueprintCacheModel.statusDate = statusDate.getTime();
		}
		else {
			sxpBlueprintCacheModel.statusDate = Long.MIN_VALUE;
		}

		return sxpBlueprintCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SXPBlueprint, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SXPBlueprint, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SXPBlueprint, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((SXPBlueprint)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SXPBlueprint>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					SXPBlueprint.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _sxpBlueprintId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _configurationJSON;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _elementInstancesJSON;
	private String _schemaVersion;
	private String _title;
	private String _titleCurrentLanguageId;
	private String _version;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<SXPBlueprint, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SXPBlueprint)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("sxpBlueprintId", _sxpBlueprintId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("configurationJSON", _configurationJSON);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put(
			"elementInstancesJSON", _elementInstancesJSON);
		_columnOriginalValues.put("schemaVersion", _schemaVersion);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("sxpBlueprintId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("configurationJSON", 512L);

		columnBitmasks.put("description", 1024L);

		columnBitmasks.put("elementInstancesJSON", 2048L);

		columnBitmasks.put("schemaVersion", 4096L);

		columnBitmasks.put("title", 8192L);

		columnBitmasks.put("version", 16384L);

		columnBitmasks.put("status", 32768L);

		columnBitmasks.put("statusByUserId", 65536L);

		columnBitmasks.put("statusByUserName", 131072L);

		columnBitmasks.put("statusDate", 262144L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SXPBlueprint _escapedModel;

}