/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.search.experiences.exception.SXPBlueprintTitleException;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.GeneralConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.util.ConfigurationUtil;
import com.liferay.search.experiences.service.base.SXPBlueprintLocalServiceBaseImpl;
import com.liferay.search.experiences.validator.SXPBlueprintValidator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.search.experiences.model.SXPBlueprint"}, service={AopService.class})
public class SXPBlueprintLocalServiceImpl
extends SXPBlueprintLocalServiceBaseImpl {
    private static final String[] _WILDCARD = new String[]{"*"};
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SXPBlueprintValidator _sxpBlueprintValidator;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public SXPBlueprint addSXPBlueprint(String externalReferenceCode, long userId, String configurationJSON, Map<Locale, String> descriptionMap, String elementInstancesJSON, String schemaVersion, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        this._validate(titleMap, serviceContext);
        SXPBlueprint sxpBlueprint = this.sxpBlueprintPersistence.create(this.counterLocalService.increment());
        sxpBlueprint.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        sxpBlueprint.setCompanyId(user.getCompanyId());
        sxpBlueprint.setUserId(user.getUserId());
        sxpBlueprint.setUserName(user.getFullName());
        sxpBlueprint.setConfigurationJSON(configurationJSON);
        sxpBlueprint.setDescriptionMap(descriptionMap);
        sxpBlueprint.setElementInstancesJSON(elementInstancesJSON);
        sxpBlueprint.setSchemaVersion(schemaVersion);
        sxpBlueprint.setTitleMap(titleMap);
        sxpBlueprint.setVersion(String.format("%.1f", (double)GetterUtil.getFloat((String)sxpBlueprint.getVersion(), (float)0.9f) + 0.1));
        sxpBlueprint.setStatus(0);
        sxpBlueprint.setStatusByUserId(user.getUserId());
        sxpBlueprint.setStatusDate(serviceContext.getModifiedDate(null));
        sxpBlueprint = this._upgradeSXPBlueprint(sxpBlueprint);
        sxpBlueprint = (SXPBlueprint)this.sxpBlueprintPersistence.update((BaseModel)sxpBlueprint);
        this._resourceLocalService.addModelResources((AuditedModel)sxpBlueprint, serviceContext);
        return sxpBlueprint;
    }

    public void deleteCompanySXPBlueprints(long companyId) throws PortalException {
        List sxpBlueprints = this.sxpBlueprintPersistence.findByCompanyId(companyId);
        for (SXPBlueprint sxpBlueprint : sxpBlueprints) {
            this.sxpBlueprintLocalService.deleteSXPBlueprint(sxpBlueprint);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public SXPBlueprint deleteSXPBlueprint(long sxpBlueprintId) throws PortalException {
        SXPBlueprint sxpBlueprint = this.sxpBlueprintPersistence.findByPrimaryKey(sxpBlueprintId);
        return this.deleteSXPBlueprint(sxpBlueprint);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public SXPBlueprint deleteSXPBlueprint(SXPBlueprint sxpBlueprint) throws PortalException {
        sxpBlueprint = (SXPBlueprint)this.sxpBlueprintPersistence.remove((BaseModel)sxpBlueprint);
        this._resourceLocalService.deleteResource((AuditedModel)sxpBlueprint, 4);
        return sxpBlueprint;
    }

    public List<SXPBlueprint> getSXPBlueprints(long companyId) {
        return this.sxpBlueprintPersistence.findByCompanyId(companyId);
    }

    public int getSXPBlueprintsCount(long companyId) {
        return this.sxpBlueprintPersistence.countByCompanyId(companyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public SXPBlueprint updateStatus(long userId, long sxpBlueprintId, int status, ServiceContext serviceContext) throws PortalException {
        SXPBlueprint sxpBlueprint = this.sxpBlueprintPersistence.findByPrimaryKey(sxpBlueprintId);
        if (sxpBlueprint.getStatus() == status) {
            return sxpBlueprint;
        }
        sxpBlueprint.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        sxpBlueprint.setStatusByUserId(user.getUserId());
        sxpBlueprint.setStatusByUserName(user.getFullName());
        sxpBlueprint.setStatusDate(serviceContext.getModifiedDate(null));
        return (SXPBlueprint)this.sxpBlueprintPersistence.update((BaseModel)sxpBlueprint);
    }

    @Indexable(type=IndexableType.REINDEX)
    public SXPBlueprint updateSXPBlueprint(String externalReferenceCode, long userId, long sxpBlueprintId, String configurationJSON, Map<Locale, String> descriptionMap, String elementInstancesJSON, String schemaVersion, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        this._validate(titleMap, serviceContext);
        SXPBlueprint sxpBlueprint = this.sxpBlueprintPersistence.findByPrimaryKey(sxpBlueprintId);
        sxpBlueprint.setExternalReferenceCode(externalReferenceCode);
        sxpBlueprint.setConfigurationJSON(configurationJSON);
        sxpBlueprint.setDescriptionMap(descriptionMap);
        sxpBlueprint.setElementInstancesJSON(elementInstancesJSON);
        sxpBlueprint.setTitleMap(titleMap);
        sxpBlueprint.setVersion(String.format("%.1f", (double)GetterUtil.getFloat((String)sxpBlueprint.getVersion(), (float)0.9f) + 0.1));
        return this.updateSXPBlueprint(sxpBlueprint);
    }

    private SXPBlueprint _upgradeSXPBlueprint(SXPBlueprint sxpBlueprint) {
        if (!Objects.equals(sxpBlueprint.getSchemaVersion(), "1.0")) {
            return sxpBlueprint;
        }
        sxpBlueprint.setSchemaVersion("1.1");
        Configuration configuration = ConfigurationUtil.toConfiguration((String)sxpBlueprint.getConfigurationJSON());
        GeneralConfiguration generalConfiguration = configuration.getGeneralConfiguration();
        String[] clauseContributorsExcludes = generalConfiguration.getClauseContributorsExcludes();
        String[] clauseContributorsIncludes = generalConfiguration.getClauseContributorsIncludes();
        if (clauseContributorsExcludes.length == 0) {
            generalConfiguration.setClauseContributorsIncludes(() -> _WILDCARD);
        } else if (clauseContributorsIncludes.length == 0) {
            generalConfiguration.setClauseContributorsExcludes(() -> _WILDCARD);
        } else {
            generalConfiguration.setClauseContributorsExcludes(() -> new String[0]);
        }
        sxpBlueprint.setConfigurationJSON(configuration.toString());
        return sxpBlueprint;
    }

    private void _validate(Map<Locale, String> titleMap, ServiceContext serviceContext) throws SXPBlueprintTitleException {
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute(SXPBlueprintLocalServiceImpl.class.getName() + "#_validate"), (boolean)true)) {
            this._sxpBlueprintValidator.validate(titleMap);
        }
    }
}

