/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.web.cache;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.search.experiences.blueprint.exception.InvalidWebCacheItemException;
import com.liferay.search.experiences.internal.configuration.OpenWeatherMapConfiguration;
import java.beans.ExceptionListener;

public class OpenWeatherMapWebCacheItem
implements WebCacheItem {
    private static final Log _log = LogFactoryUtil.getLog(OpenWeatherMapWebCacheItem.class);
    private final String _latitude;
    private final String _longitude;
    private final OpenWeatherMapConfiguration _openWeatherMapConfiguration;

    public static JSONObject get(ExceptionListener exceptionListener, String latitude, String longitude, OpenWeatherMapConfiguration openWeatherMapConfiguration) {
        if (!openWeatherMapConfiguration.enabled()) {
            return JSONFactoryUtil.createJSONObject();
        }
        try {
            return (JSONObject)WebCachePoolUtil.get((String)StringBundler.concat((String[])new String[]{OpenWeatherMapWebCacheItem.class.getName(), "#", openWeatherMapConfiguration.apiKey(), "#", openWeatherMapConfiguration.apiURL(), "#", latitude, "#", longitude}), (WebCacheItem)new OpenWeatherMapWebCacheItem(latitude, longitude, openWeatherMapConfiguration));
        }
        catch (Exception exception) {
            exceptionListener.exceptionThrown(exception);
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return JSONFactoryUtil.createJSONObject();
        }
    }

    public OpenWeatherMapWebCacheItem(String latitude, String longitude, OpenWeatherMapConfiguration openWeatherMapConfiguration) {
        this._latitude = latitude;
        this._longitude = longitude;
        this._openWeatherMapConfiguration = openWeatherMapConfiguration;
    }

    public JSONObject convert(String key) {
        try {
            String url = StringBundler.concat((String[])new String[]{this._openWeatherMapConfiguration.apiURL(), "?APPID=", this._openWeatherMapConfiguration.apiKey(), "&format=json&lat=", this._latitude, "&lon=", this._longitude, "&units=", this._openWeatherMapConfiguration.units()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Reading " + url));
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)HttpUtil.URLtoString((String)url));
            this._validateResponse(jsonObject);
            return jsonObject;
        }
        catch (Exception exception) {
            throw new InvalidWebCacheItemException((Throwable)exception);
        }
    }

    public long getRefreshTime() {
        if (this._openWeatherMapConfiguration.enabled()) {
            return this._openWeatherMapConfiguration.cacheTimeout();
        }
        return 0L;
    }

    private void _validateResponse(JSONObject jsonObject) {
        String cod = jsonObject.getString("cod");
        if (Validator.isNull((String)cod) || cod.startsWith("2")) {
            return;
        }
        throw new InvalidWebCacheItemException(StringBundler.concat((String[])new String[]{"OpenWeatherMap: ", JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"Object/message"}), " (", cod, ")"}));
    }
}

