/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.web.cache;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.search.experiences.blueprint.exception.InvalidWebCacheItemException;
import com.liferay.search.experiences.blueprint.exception.PrivateIPAddressException;
import com.liferay.search.experiences.internal.configuration.IpstackConfiguration;
import java.beans.ExceptionListener;
import java.net.Inet4Address;
import java.net.InetAddress;

public class IpstackWebCacheItem
implements WebCacheItem {
    private static final Log _log = LogFactoryUtil.getLog(IpstackWebCacheItem.class);
    private final String _ipAddress;
    private final IpstackConfiguration _ipstackConfiguration;

    public static JSONObject get(ExceptionListener exceptionListener, String ipAddress, IpstackConfiguration ipstackConfiguration) {
        try {
            if (!ipstackConfiguration.enabled() || IpstackWebCacheItem._isPrivateIPAddress(ipAddress)) {
                return JSONFactoryUtil.createJSONObject();
            }
            return (JSONObject)WebCachePoolUtil.get((String)StringBundler.concat((String[])new String[]{IpstackWebCacheItem.class.getName(), "#", ipstackConfiguration.apiKey(), "#", ipstackConfiguration.apiURL(), "#", ipAddress}), (WebCacheItem)new IpstackWebCacheItem(ipAddress, ipstackConfiguration));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            exceptionListener.exceptionThrown(exception);
            return JSONFactoryUtil.createJSONObject();
        }
    }

    public IpstackWebCacheItem(String ipAddress, IpstackConfiguration ipstackConfiguration) {
        this._ipAddress = ipAddress;
        this._ipstackConfiguration = ipstackConfiguration;
    }

    public JSONObject convert(String key) {
        try {
            Object apiURL = this._ipstackConfiguration.apiURL();
            if (!((String)apiURL).endsWith("/")) {
                apiURL = (String)apiURL + "/";
            }
            String url = StringBundler.concat((String[])new String[]{apiURL, this._ipAddress, "?access_key=", this._ipstackConfiguration.apiKey()});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Reading " + url));
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)HttpUtil.URLtoString((String)url));
            this._validateResponse(jsonObject);
            return jsonObject;
        }
        catch (Exception exception) {
            throw new InvalidWebCacheItemException((Throwable)exception);
        }
    }

    public long getRefreshTime() {
        if (this._ipstackConfiguration.enabled()) {
            return this._ipstackConfiguration.cacheTimeout();
        }
        return 0L;
    }

    private static boolean _isPrivateIPAddress(String ipAddress) throws Exception {
        Inet4Address inet4Address = (Inet4Address)InetAddress.getByName(ipAddress);
        if (inet4Address.isAnyLocalAddress() || inet4Address.isLinkLocalAddress() || inet4Address.isLoopbackAddress() || inet4Address.isMulticastAddress() || inet4Address.isSiteLocalAddress()) {
            throw new PrivateIPAddressException("Unable to resolve private IP address " + ipAddress);
        }
        return false;
    }

    private void _validateResponse(JSONObject jsonObject) {
        boolean success = jsonObject.getBoolean("success", true);
        if (success) {
            return;
        }
        throw new InvalidWebCacheItemException(StringBundler.concat((String[])new String[]{"IPStack: ", JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"JSONObject/error", "Object/info"}), " (", JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"JSONObject/error", "Object/code"}), ")"}));
    }
}

