/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v3_1_2;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SXPBlueprintUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public SXPBlueprintUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeSXPBlueprints();
    }

    private String _updateConfigurationStorage(String configurationJSON) throws Exception {
        if (Validator.isBlank((String)configurationJSON)) {
            return configurationJSON;
        }
        JSONObject configurationjsonObject = JSONFactoryUtil.createJSONObject((String)configurationJSON);
        JSONObject generalConfigurationjsonObject = configurationjsonObject.getJSONObject("generalConfiguration");
        JSONArray clauseContributorsExcludesjsonArray = generalConfigurationjsonObject.getJSONArray("clauseContributorsExcludes");
        JSONArray clauseContributorsIncludesjsonArray = generalConfigurationjsonObject.getJSONArray("clauseContributorsIncludes");
        if (clauseContributorsExcludesjsonArray.length() == 0) {
            generalConfigurationjsonObject.put("clauseContributorsIncludes", this._jsonFactory.createJSONArray((Object[])new String[]{"*"}));
        } else if (clauseContributorsIncludesjsonArray.length() == 0) {
            generalConfigurationjsonObject.put("clauseContributorsExcludes", this._jsonFactory.createJSONArray((Object[])new String[]{"*"}));
        } else {
            generalConfigurationjsonObject.put("clauseContributorsExcludes", this._jsonFactory.createJSONArray());
        }
        return configurationjsonObject.toString();
    }

    private void _upgradeSXPBlueprints() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select configurationJSON,sxpBlueprintId from SXPBlueprint where schemaVersion = '1.0'");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPBlueprint set configurationJSON = ?,schemaVersion = ? where sxpBlueprintId = ?");
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                preparedStatement2.setString(1, this._updateConfigurationStorage(resultSet1.getString("configurationJSON")));
                preparedStatement2.setString(2, "1.1");
                preparedStatement2.setLong(3, resultSet1.getLong("sxpBlueprintId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

