/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.upgrade.v2_0_3;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.search.experiences.internal.model.listener.CompanyModelListener;
import com.liferay.search.experiences.rest.dto.v1_0.SXPElement;
import com.liferay.search.experiences.rest.dto.v1_0.util.SXPElementUtil;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SXPElementUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SXPElementUpgradeProcess.class);
    private Map<String, SXPElement> _sxpElements;

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select externalReferenceCode, readOnly from SXPElement");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SXPElement set elementDefinitionJSON = ? where externalReferenceCode = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                Map<String, SXPElement> sxpElements;
                SXPElement sxpElement;
                if (!resultSet.getBoolean("readOnly") || (sxpElement = (sxpElements = this._getSXPElements()).get(resultSet.getString("externalReferenceCode"))) == null) continue;
                preparedStatement2.setString(1, String.valueOf(sxpElement.getElementDefinition()));
                preparedStatement2.setString(2, resultSet.getString("externalReferenceCode"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private Map<String, SXPElement> _getSXPElements() {
        if (this._sxpElements != null) {
            return this._sxpElements;
        }
        Bundle bundle = FrameworkUtil.getBundle(CompanyModelListener.class);
        Package pkg = CompanyModelListener.class.getPackage();
        String path = StringUtil.replace((String)pkg.getName(), (char)'.', (char)'/');
        this._sxpElements = new HashMap<String, SXPElement>();
        Enumeration enumeration = bundle.findEntries(path.concat("/dependencies"), "*.json", false);
        try {
            while (enumeration.hasMoreElements()) {
                SXPElement sxpElement = SXPElementUtil.toSXPElement((String)URLUtil.toString((URL)((URL)enumeration.nextElement())));
                this._sxpElements.put(sxpElement.getExternalReferenceCode(), sxpElement);
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        return this._sxpElements;
    }
}

