/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.suggestions.spi;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.asset.AssetURLViewProvider;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.rest.dto.v1_0.SuggestionsContributorConfiguration;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.spi.suggestions.SuggestionsContributor;
import com.liferay.portal.search.suggestions.Suggestion;
import com.liferay.portal.search.suggestions.SuggestionBuilder;
import com.liferay.portal.search.suggestions.SuggestionBuilderFactory;
import com.liferay.portal.search.suggestions.SuggestionsContributorResults;
import com.liferay.portal.search.suggestions.SuggestionsContributorResultsBuilderFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"search.suggestions.contributor.name=sxpBlueprint"}, service={SuggestionsContributor.class})
public class SXPBlueprintSuggestionsContributor
implements SuggestionsContributor {
    private static final int _CHARACTER_THRESHOLD = 2;
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintSuggestionsContributor.class);
    @Reference
    private AssetURLViewProvider _assetURLViewProvider;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SuggestionBuilderFactory _suggestionBuilderFactory;
    @Reference
    private SuggestionsContributorResultsBuilderFactory _suggestionsContributorResultsBuilderFactory;

    public SuggestionsContributorResults getSuggestionsContributorResults(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, SearchContext searchContext, SuggestionsContributorConfiguration suggestionsContributorConfiguration) {
        Map attributes = (Map)suggestionsContributorConfiguration.getAttributes();
        if (attributes == null || !attributes.containsKey("sxpBlueprintExternalReferenceCode") && !attributes.containsKey("sxpBlueprintId")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Attributes do not contain search experiences blueprint External Reference Code or ID");
            }
            return null;
        }
        if (!this._exceedsCharacterThreshold(attributes, searchContext.getKeywords())) {
            return null;
        }
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(attributes, searchContext, GetterUtil.getInteger((Object)suggestionsContributorConfiguration.getSize(), (int)5)));
        SearchHits searchHits = searchResponse.getSearchHits();
        if (searchHits.getTotalHits() == 0L) {
            return null;
        }
        return this._suggestionsContributorResultsBuilderFactory.builder().displayGroupName(suggestionsContributorConfiguration.getDisplayGroupName()).suggestions(this._getSuggestions(attributes, liferayPortletRequest, liferayPortletResponse, searchContext, searchHits.getSearchHits())).build();
    }

    private boolean _exceedsCharacterThreshold(Map<String, Object> attributes, String keywords) {
        int characterThreshold = this._getCharacterThreshold(attributes);
        return Validator.isBlank((String)keywords) ? characterThreshold == 0 : keywords.length() >= characterThreshold;
    }

    private AssetRenderer<?> _getAssetRenderer(AssetRendererFactory<?> assetRendererFactory, long entryClassPK) {
        try {
            return assetRendererFactory.getAssetRenderer(entryClassPK);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return null;
        }
    }

    private int _getCharacterThreshold(Map<String, Object> attributes) {
        if (attributes == null) {
            return 2;
        }
        return MapUtil.getInteger(attributes, (String)"characterThreshold", (int)2);
    }

    private Map<String, Object> _getFieldValues(Document document, List<String> fieldNames, Locale locale) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (String fieldName : fieldNames) {
            fieldName = this._replaceLanguageId(locale, fieldName);
            fieldValues.put(fieldName, document.getValue(fieldName));
        }
        return fieldValues;
    }

    private String[] _getNestedFieldValue(Document document, String fieldName) {
        String[] parts = StringUtil.split((String)fieldName, (String)"\\.");
        Map nestedFields = (Map)document.getValue(parts[0]);
        if (nestedFields == null) {
            return null;
        }
        return GetterUtil.getStringValues(nestedFields.get(parts[1]));
    }

    private SearchRequest _getSearchRequest(Map<String, Object> attributes, SearchContext searchContext1, int size) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.from(Integer.valueOf(0)).queryString(searchContext1.getKeywords()).size(Integer.valueOf(size)).withSearchContext(searchContext2 -> {
            this._setSearchExperiencesSearchContextAttributes(attributes, searchContext1, (SearchContext)searchContext2);
            searchContext2.setAttribute("search.contribute.tuning.rankings", (Serializable)Boolean.TRUE);
            searchContext2.setAttribute("search.empty.search", searchContext1.getAttribute("search.empty.search"));
            searchContext2.setCompanyId(searchContext1.getCompanyId());
            searchContext2.setGroupIds(searchContext1.getGroupIds());
            if (FeatureFlagManagerUtil.isEnabled((String)"LPD-35128")) {
                searchContext2.setIncludeAttachments(MapUtil.getBoolean((Map)attributes, (String)"includeAttachments"));
            }
            searchContext2.setKeywords(searchContext1.getKeywords());
            searchContext2.setLocale(searchContext1.getLocale());
            searchContext2.setTimeZone(searchContext1.getTimeZone());
            searchContext2.setUserId(searchContext1.getUserId());
        });
        return searchRequestBuilder.build();
    }

    private Suggestion _getSuggestion(List<String> fieldNames, boolean includeAssetSearchSummary, boolean includeAssetURL, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, SearchContext searchContext, SearchHit searchHit, String text, boolean useAssetTitle) {
        SuggestionBuilder suggestionBuilder = this._suggestionBuilderFactory.builder().score(searchHit.getScore()).text(text);
        Document document = searchHit.getDocument();
        if (ListUtil.isNotEmpty(fieldNames)) {
            suggestionBuilder.attribute("fields", this._getFieldValues(document, fieldNames, searchContext.getLocale()));
        }
        if (!(includeAssetSearchSummary || includeAssetURL || useAssetTitle)) {
            return suggestionBuilder.build();
        }
        try {
            this._setAssetFields(document, includeAssetSearchSummary, includeAssetURL, liferayPortletRequest, liferayPortletResponse, searchContext.getLocale(), suggestionBuilder, useAssetTitle);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return suggestionBuilder.build();
    }

    private List<Suggestion> _getSuggestions(Map<String, Object> attributes, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, SearchContext searchContext, List<SearchHit> searchHits) {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        List fieldNames = (List)attributes.get("fields");
        String fieldValueSeparator = MapUtil.getString(attributes, (Object)"fieldValueSeparator");
        boolean includeAssetSearchSummary = MapUtil.getBoolean(attributes, (String)"includeAssetSearchSummary", (boolean)true);
        boolean includeAssetURL = MapUtil.getBoolean(attributes, (String)"includeAssetURL", (boolean)true);
        String textFieldName = MapUtil.getString(attributes, (Object)"textField");
        for (SearchHit searchHit : searchHits) {
            Document document = searchHit.getDocument();
            if (Validator.isBlank((String)textFieldName)) {
                suggestions.add(this._getSuggestion(fieldNames, includeAssetSearchSummary, includeAssetURL, liferayPortletRequest, liferayPortletResponse, searchContext, searchHit, "", true));
                continue;
            }
            List<String> texts = this._getTexts(document, this._replaceLanguageId(searchContext.getLocale(), textFieldName));
            for (String text : texts) {
                if (!Validator.isBlank((String)fieldValueSeparator)) {
                    String[] parts;
                    for (String part : parts = StringUtil.split((String)text, (String)fieldValueSeparator)) {
                        suggestions.add(this._getSuggestion(fieldNames, includeAssetSearchSummary, includeAssetURL, liferayPortletRequest, liferayPortletResponse, searchContext, searchHit, part, false));
                    }
                    continue;
                }
                suggestions.add(this._getSuggestion(fieldNames, includeAssetSearchSummary, includeAssetURL, liferayPortletRequest, liferayPortletResponse, searchContext, searchHit, text, false));
            }
        }
        return suggestions;
    }

    private List<String> _getTexts(Document document, String fieldName) {
        if (StringUtil.contains((String)fieldName, (String)".")) {
            return Arrays.asList(this._getNestedFieldValue(document, fieldName));
        }
        return document.getStrings(fieldName);
    }

    private String _replaceLanguageId(Locale locale, String fieldName) {
        return StringUtil.replace((String)fieldName, (String)"${language_id}", (String)LocaleUtil.toLanguageId((Locale)locale));
    }

    private void _setAssetFields(Document document, boolean includeAssetSearchSummary, boolean includeAssetURL, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, Locale locale, SuggestionBuilder suggestionBuilder, boolean useAssetTitle) throws Exception {
        String entryClassName = document.getString("entryClassName");
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)entryClassName);
        if (assetRendererFactory == null) {
            return;
        }
        long entryClassPK = document.getLong("entryClassPK");
        AssetRenderer<?> assetRenderer = this._getAssetRenderer(assetRendererFactory, entryClassPK);
        if (assetRenderer == null) {
            return;
        }
        if (includeAssetSearchSummary) {
            suggestionBuilder.attribute("assetSearchSummary", (Object)assetRenderer.getSummary((PortletRequest)liferayPortletRequest, (PortletResponse)liferayPortletResponse));
        }
        if (includeAssetURL) {
            long classNameId = GetterUtil.getLong((Object)document.getValue("classNameId"));
            long classPK = GetterUtil.getLong((Object)document.getValue("classPK"));
            if (classNameId > 0L && classPK > 0L) {
                ClassName className = this._classNameLocalService.getClassName(classNameId);
                suggestionBuilder.attribute("assetURL", (Object)this._assetURLViewProvider.getAssetURLView(assetRenderer, assetRendererFactory, className.getClassName(), classPK, liferayPortletRequest, liferayPortletResponse));
            } else {
                suggestionBuilder.attribute("assetURL", (Object)this._assetURLViewProvider.getAssetURLView(assetRenderer, assetRendererFactory, entryClassName, entryClassPK, liferayPortletRequest, liferayPortletResponse));
            }
        }
        if (useAssetTitle) {
            suggestionBuilder.text(assetRenderer.getTitle(locale));
        }
    }

    private void _setSearchExperiencesSearchContextAttributes(Map<String, Object> attributes, SearchContext sourceSearchContext, SearchContext targetSearchContext) {
        MapUtil.isNotEmptyForEach(attributes, (key, value) -> {
            if (key.startsWith("search.experiences.") && value != null && value instanceof Serializable) {
                targetSearchContext.setAttribute(key, (Serializable)value);
            }
        });
        MapUtil.isNotEmptyForEach((Map)sourceSearchContext.getAttributes(), (key, value) -> {
            if (key.startsWith("search.experiences.") && value != null) {
                targetSearchContext.setAttribute(key, value);
            }
        });
        targetSearchContext.setAttribute("search.experiences.blueprint.external.reference.code", (Serializable)((Object)MapUtil.getString(attributes, (Object)"sxpBlueprintExternalReferenceCode")));
        targetSearchContext.setAttribute("search.experiences.blueprint.id", (Serializable)Long.valueOf(MapUtil.getLong(attributes, (String)"sxpBlueprintId")));
    }
}

