/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.search.experiences.model.SXPElement;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"indexer.class.name=com.liferay.search.experiences.model.SXPElement"}, service={ModelDocumentContributor.class})
public class SXPElementModelDocumentContributor
implements ModelDocumentContributor<SXPElement> {
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;

    public void contribute(Document document, SXPElement sxpElement) {
        document.addDate("modified", sxpElement.getModifiedDate());
        document.addKeyword("hidden", sxpElement.isHidden());
        document.addKeyword("type", sxpElement.getType());
        document.addKeyword("readOnly", sxpElement.isReadOnly());
        for (Locale locale : this._language.getCompanyAvailableLocales(sxpElement.getCompanyId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addKeyword(Field.getSortableFieldName((String)this._localization.getLocalizedName("description", languageId)), sxpElement.getDescription(locale), true);
            document.addKeyword(Field.getSortableFieldName((String)this._localization.getLocalizedName("title", languageId)), sxpElement.getTitle(locale), true);
            document.addText(this._localization.getLocalizedName("description", languageId), sxpElement.getDescription(locale));
            document.addText(this._localization.getLocalizedName("title", languageId), sxpElement.getTitle(locale));
        }
    }
}

