/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.model.listener;

import com.liferay.asset.util.AssetHelper;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.internal.info.collection.provider.JournalArticleSXPBlueprintInfoCollectionProvider;
import com.liferay.search.experiences.internal.model.listener.InfoCollectionProviderSXPBlueprintModelListener;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.GeneralConfiguration;
import com.liferay.search.experiences.service.SXPBlueprintLocalService;
import org.osgi.framework.BundleContext;

public class JournalArticleSXPBlueprintInfoCollectionProviderSXPBlueprintModelListener
extends InfoCollectionProviderSXPBlueprintModelListener {
    private final AssetHelper _assetHelper;
    private final JournalArticleService _journalArticleService;
    private final Searcher _searcher;
    private final SearchRequestBuilderFactory _searchRequestBuilderFactory;

    public JournalArticleSXPBlueprintInfoCollectionProviderSXPBlueprintModelListener(BundleContext bundleContext, CompanyLocalService companyLocalService, SXPBlueprintLocalService sxpBlueprintLocalService, AssetHelper assetHelper, JournalArticleService journalArticleService, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory) {
        super(bundleContext, companyLocalService, sxpBlueprintLocalService);
        this._assetHelper = assetHelper;
        this._journalArticleService = journalArticleService;
        this._searcher = searcher;
        this._searchRequestBuilderFactory = searchRequestBuilderFactory;
    }

    @Override
    public void onAfterCreate(SXPBlueprint sxpBlueprint) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-193551")) {
            return;
        }
        if (StringUtil.equals((String)this._getSingleSearchableAssetType(sxpBlueprint), (String)JournalArticle.class.getName())) {
            super.onAfterCreate(sxpBlueprint);
        }
    }

    @Override
    protected InfoCollectionProvider<?> createInfoCollectionProvider(SXPBlueprint sxpBlueprint) {
        return new JournalArticleSXPBlueprintInfoCollectionProvider(this._assetHelper, this._journalArticleService, this._searcher, this._searchRequestBuilderFactory, sxpBlueprint);
    }

    @Override
    protected String getItemClassName() {
        return JournalArticle.class.getName();
    }

    private String _getSingleSearchableAssetType(SXPBlueprint sxpBlueprint) {
        Configuration configuration = Configuration.unsafeToDTO((String)sxpBlueprint.getConfigurationJSON());
        GeneralConfiguration generalConfiguration = configuration.getGeneralConfiguration();
        if (generalConfiguration == null) {
            return null;
        }
        Object[] searchableAssetTypes = generalConfiguration.getSearchableAssetTypes();
        if (ArrayUtil.isEmpty((Object[])searchableAssetTypes) || searchableAssetTypes.length > 1) {
            return null;
        }
        return searchableAssetTypes[0];
    }
}

