/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.model.listener;

import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.service.SXPBlueprintLocalService;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class InfoCollectionProviderSXPBlueprintModelListener
extends BaseModelListener<SXPBlueprint> {
    private final BundleContext _bundleContext;
    private final CompanyLocalService _companyLocalService;
    private final Map<Long, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private final SXPBlueprintLocalService _sxpBlueprintLocalService;

    public InfoCollectionProviderSXPBlueprintModelListener(BundleContext bundleContext, CompanyLocalService companyLocalService, SXPBlueprintLocalService sxpBlueprintLocalService) {
        this._bundleContext = bundleContext;
        this._companyLocalService = companyLocalService;
        this._sxpBlueprintLocalService = sxpBlueprintLocalService;
    }

    public Class<?> getModelClass() {
        return SXPBlueprint.class;
    }

    public void onAfterCreate(SXPBlueprint sxpBlueprint) {
        ServiceRegistration serviceRegistration = this._serviceRegistrations.put(sxpBlueprint.getSXPBlueprintId(), this._bundleContext.registerService(InfoCollectionProvider.class, this.createInfoCollectionProvider(sxpBlueprint), (Dictionary)HashMapDictionaryBuilder.put((Object)"company.id", (Object)sxpBlueprint.getCompanyId()).put((Object)"item.class.name", (Object)this.getItemClassName()).build()));
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    public void onAfterRemove(SXPBlueprint sxpBlueprint) {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(sxpBlueprint.getSXPBlueprintId());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    public void onAfterUpdate(SXPBlueprint originalSXPBlueprint, SXPBlueprint newSXPBlueprint) {
        this.onAfterRemove(originalSXPBlueprint);
        this.onAfterCreate(newSXPBlueprint);
    }

    public void start() {
        this._companyLocalService.forEachCompanyId(companyId -> {
            List sxpBlueprints = this._sxpBlueprintLocalService.getSXPBlueprints(companyId.longValue());
            for (SXPBlueprint sxpBlueprint : sxpBlueprints) {
                this.onAfterCreate(sxpBlueprint);
            }
        });
    }

    public void stop() {
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
    }

    protected abstract InfoCollectionProvider<?> createInfoCollectionProvider(SXPBlueprint var1);

    protected abstract String getItemClassName();
}

