/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.info.collection.provider;

import com.liferay.asset.util.AssetHelper;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.search.experiences.internal.info.collection.provider.SXPBlueprintInfoCollectionProvider;
import com.liferay.search.experiences.model.SXPBlueprint;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class JournalArticleSXPBlueprintInfoCollectionProvider
extends SXPBlueprintInfoCollectionProvider<JournalArticle>
implements FilteredInfoCollectionProvider<JournalArticle>,
SingleFormVariationInfoCollectionProvider<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleSXPBlueprintInfoCollectionProvider.class);
    private final JournalArticleService _journalArticleService;

    public JournalArticleSXPBlueprintInfoCollectionProvider(AssetHelper assetHelper, JournalArticleService journalArticleService, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, SXPBlueprint sxpBlueprint) {
        super(assetHelper, searcher, searchRequestBuilderFactory, sxpBlueprint);
        this._journalArticleService = journalArticleService;
    }

    public InfoPage<JournalArticle> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            Pagination pagination = collectionQuery.getPagination();
            SearchRequestBuilder searchRequestBuilder = this.getSearchRequestBuilder(collectionQuery, pagination);
            SearchResponse searchResponse = this.searcher.search(searchRequestBuilder.build());
            return InfoPage.of(this._getJournalArticles(searchResponse.getSearchHits()), (Pagination)collectionQuery.getPagination(), (int)searchResponse.getTotalHits());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get journal articles", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    public String getFormVariationKey() {
        long ddmStructureId = 0L;
        CollectionQuery collectionQuery = new CollectionQuery();
        collectionQuery.setPagination(Pagination.of((int)1, (int)0));
        SearchRequestBuilder searchRequestBuilder = this.getSearchRequestBuilder(collectionQuery, collectionQuery.getPagination());
        SearchResponse searchResponse = this.searcher.search(searchRequestBuilder.build());
        SearchHits searchHits = searchResponse.getSearchHits();
        try {
            List<JournalArticle> journalArticles = this._getJournalArticles(searchHits);
            if (!journalArticles.isEmpty()) {
                JournalArticle journalArticle = journalArticles.get(0);
                ddmStructureId = journalArticle.getDDMStructureId();
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return String.valueOf(ddmStructureId);
    }

    public String getKey() {
        return StringBundler.concat((Object[])new Object[]{JournalArticleSXPBlueprintInfoCollectionProvider.class.getName(), "_", this.sxpBlueprint.getCompanyId(), "_", this.sxpBlueprint.getExternalReferenceCode(), "_", JournalArticle.class.getName()});
    }

    @Override
    public String getLabel(Locale locale) {
        return this.sxpBlueprint.getTitle(locale);
    }

    private List<JournalArticle> _getJournalArticles(SearchHits searchHits) throws PortalException {
        return TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            return this._journalArticleService.getLatestArticle(document.getLong("entryClassPK").longValue());
        });
    }
}

