/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.sort;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.geolocation.DistanceUnit;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.geolocation.GeoDistanceType;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.GeoDistanceSort;
import com.liferay.portal.search.sort.NestedSort;
import com.liferay.portal.search.sort.ScriptSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortMode;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.search.experiences.internal.blueprint.query.QueryConverter;
import com.liferay.search.experiences.internal.blueprint.script.ScriptConverter;
import java.util.Iterator;
import java.util.Objects;

public class SortConverter {
    private final GeoBuilders _geoBuilders;
    private final QueryConverter _queryConverter;
    private final ScriptConverter _scriptConverter;
    private final Sorts _sorts;

    public SortConverter(GeoBuilders geoBuilders, QueryConverter queryConverter, ScriptConverter scriptConverter, Sorts sorts) {
        this._geoBuilders = geoBuilders;
        this._queryConverter = queryConverter;
        this._scriptConverter = scriptConverter;
        this._sorts = sorts;
    }

    public Sort convert(Object object) {
        return this._toSort(object);
    }

    private void _addGeoLocationPoint(GeoDistanceSort geoDistanceSort, JSONArray jsonArray) {
        geoDistanceSort.addGeoLocationPoints(new GeoLocationPoint[]{this._geoBuilders.geoLocationPoint(jsonArray.getDouble(0), jsonArray.getDouble(1))});
    }

    private void _processGeoDistanceType(GeoDistanceSort geoDistanceSort, JSONObject jsonObject) {
        if (!jsonObject.has("distance_type")) {
            return;
        }
        geoDistanceSort.setGeoDistanceType(GeoDistanceType.valueOf((String)StringUtil.toUpperCase((String)jsonObject.getString("distance_type"))));
    }

    private void _processGeoDistanceUnit(GeoDistanceSort geoDistanceSort, JSONObject jsonObject) {
        geoDistanceSort.setDistanceUnit(DistanceUnit.create((String)StringUtil.toLowerCase((String)jsonObject.getString("unit"))));
    }

    private void _processGeoLocationPoints(GeoDistanceSort geoDistanceSort, Object object) {
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            geoDistanceSort.addGeoLocationPoints(new GeoLocationPoint[]{this._geoBuilders.geoLocationPoint((double)jsonObject.getInt("lat"), (double)jsonObject.getInt("lon"))});
        } else if (object instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)object;
            if (jsonArray.length() != 2 || jsonArray.get(0) instanceof JSONArray) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    this._addGeoLocationPoint(geoDistanceSort, jsonArray.getJSONArray(i));
                }
            } else {
                this._addGeoLocationPoint(geoDistanceSort, jsonArray);
            }
        } else if (object instanceof String) {
            geoDistanceSort.addGeoLocationPoints(new GeoLocationPoint[]{this._geoBuilders.geoLocationPoint((String)object)});
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void _processGeoSortMode(GeoDistanceSort geoDistanceSort, JSONObject jsonObject) {
        String mode = jsonObject.getString("mode");
        if (Validator.isNotNull((String)mode)) {
            geoDistanceSort.setSortMode(SortMode.valueOf((String)StringUtil.toUpperCase((String)mode)));
        }
    }

    private void _processSortOrder(JSONObject jsonObject, Sort sort) {
        if (jsonObject.has("order")) {
            sort.setSortOrder(this._toSortOrder(jsonObject.getString("order")));
        }
    }

    private Sort _toFieldSort(String field) {
        if (field.equals("_score")) {
            return this._sorts.score();
        }
        return this._sorts.field(field);
    }

    private Sort _toFieldSort(String field, JSONObject jsonObject) {
        FieldSort fieldSort = this._sorts.field(field);
        if (jsonObject.has("missing")) {
            fieldSort.setMissing((Object)jsonObject.getString("missing"));
        }
        if (jsonObject.has("nested")) {
            fieldSort.setNestedSort(this._toNestedSort(jsonObject.getJSONObject("nested")));
        }
        if (jsonObject.has("mode")) {
            fieldSort.setSortMode(SortMode.valueOf((String)StringUtil.toUpperCase((String)jsonObject.getString("mode"))));
        }
        this._processSortOrder(jsonObject, (Sort)fieldSort);
        return fieldSort;
    }

    private Sort _toFieldSort(String field, String string) {
        Sort sort = this._toFieldSort(field);
        sort.setSortOrder(this._toSortOrder(string));
        return sort;
    }

    private GeoDistanceSort _toGeoDistanceSort(JSONObject jsonObject) {
        Iterator iterator = jsonObject.keys();
        String field = (String)iterator.next();
        GeoDistanceSort geoDistanceSort = this._sorts.geoDistance(field);
        this._processGeoDistanceUnit(geoDistanceSort, jsonObject);
        this._processGeoDistanceType(geoDistanceSort, jsonObject);
        this._processGeoLocationPoints(geoDistanceSort, jsonObject.get(field));
        this._processGeoSortMode(geoDistanceSort, jsonObject);
        this._processSortOrder(jsonObject, (Sort)geoDistanceSort);
        return geoDistanceSort;
    }

    private NestedSort _toNestedSort(JSONObject jsonObject) {
        NestedSort nestedSort = this._sorts.nested(jsonObject.getString("nested_path"));
        if (jsonObject.has("nested_filter")) {
            nestedSort.setFilterQuery(this._queryConverter.toQuery(jsonObject.getJSONObject("nested_filter")));
        }
        if (jsonObject.has("nested")) {
            nestedSort.setNestedSort(this._toNestedSort(jsonObject.getJSONObject("nested")));
        }
        return nestedSort;
    }

    private Sort _toScriptSort(JSONObject jsonObject) {
        ScriptSort scriptSort = this._sorts.script(this._scriptConverter.toScript(jsonObject.get("script")), ScriptSort.ScriptSortType.valueOf((String)StringUtil.toUpperCase((String)jsonObject.getString("type"))));
        this._processSortOrder(jsonObject, (Sort)scriptSort);
        return scriptSort;
    }

    private Sort _toSort(JSONObject jsonObject) {
        Iterator iterator = jsonObject.keys();
        String key = (String)iterator.next();
        Object object = jsonObject.get(key);
        if (Objects.equals(key, "_geo_distance")) {
            return this._toGeoDistanceSort((JSONObject)object);
        }
        if (Objects.equals(key, "_script")) {
            return this._toScriptSort((JSONObject)object);
        }
        if (object instanceof JSONObject) {
            return this._toFieldSort(key, (JSONObject)object);
        }
        if (object instanceof String) {
            return this._toFieldSort(key, (String)object);
        }
        throw new IllegalArgumentException();
    }

    private Sort _toSort(Object object) {
        if (object instanceof JSONObject) {
            return this._toSort((JSONObject)object);
        }
        if (object instanceof String) {
            return this._toFieldSort((String)object);
        }
        throw new IllegalArgumentException();
    }

    private SortOrder _toSortOrder(String string) {
        return SortOrder.valueOf((String)StringUtil.toUpperCase((String)string));
    }
}

