/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.search.spi.searcher;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.spi.searcher.SearchRequestContributor;
import com.liferay.search.experiences.blueprint.search.request.enhancer.SXPBlueprintSearchRequestEnhancer;
import com.liferay.search.experiences.exception.SXPExceptionUtil;
import com.liferay.search.experiences.model.SXPBlueprint;
import com.liferay.search.experiences.service.SXPBlueprintLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"search.request.contributor.id=com.liferay.search.experiences.blueprint"}, service={SearchRequestContributor.class})
public class SXPBlueprintSearchRequestContributor
implements SearchRequestContributor {
    private static final Log _log = LogFactoryUtil.getLog(SXPBlueprintSearchRequestContributor.class);
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SXPBlueprintLocalService _sxpBlueprintLocalService;
    @Reference
    private SXPBlueprintSearchRequestEnhancer _sxpBlueprintSearchRequestEnhancer;

    public SearchRequest contribute(SearchRequest searchRequest) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder(searchRequest);
        this._contributeSXPBlueprintExternalReferenceCode(searchRequestBuilder);
        this._contributeSXPBlueprintId(searchRequestBuilder);
        return searchRequestBuilder.build();
    }

    private void _contributeSXPBlueprintExternalReferenceCode(SearchRequestBuilder searchRequestBuilder) {
        Object object = searchRequestBuilder.withSearchContextGet(searchContext -> searchContext.getAttribute("search.experiences.blueprint.external.reference.code"));
        if (object instanceof String) {
            String[] sxpBlueprintExternalReferenceCodes;
            String string = (String)object;
            if (Validator.isBlank((String)string)) {
                return;
            }
            for (String sxpBlueprintExternalReferenceCode : sxpBlueprintExternalReferenceCodes = StringUtil.split((String)string)) {
                if (Validator.isBlank((String)sxpBlueprintExternalReferenceCode)) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Search experiences blueprint external reference code " + string));
                }
                this._enhance(searchRequestBuilder, this._sxpBlueprintLocalService.fetchSXPBlueprintByExternalReferenceCode(sxpBlueprintExternalReferenceCode, GetterUtil.getLong((Object)searchRequestBuilder.withSearchContextGet(SearchContext::getCompanyId))));
            }
        } else if (object != null) {
            throw new IllegalArgumentException("Invalid search experiences blueprint external reference code " + object);
        }
    }

    private void _contributeSXPBlueprintId(SearchRequestBuilder searchRequestBuilder) {
        Object object = searchRequestBuilder.withSearchContextGet(searchContext -> searchContext.getAttribute("search.experiences.blueprint.id"));
        long[] sxpBlueprintIds = null;
        if (object instanceof Number) {
            sxpBlueprintIds = new long[]{GetterUtil.getLong((Object)object)};
        } else if (object instanceof String) {
            String string = (String)object;
            if (!Validator.isBlank((String)string)) {
                sxpBlueprintIds = GetterUtil.getLongValues((String[])StringUtil.split((String)string));
            }
        } else if (object != null) {
            throw new IllegalArgumentException("Invalid search experiences blueprint ID " + object);
        }
        if (sxpBlueprintIds == null) {
            return;
        }
        for (long sxpBlueprintId : sxpBlueprintIds) {
            if (sxpBlueprintId == 0L) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search experiences blueprint ID " + sxpBlueprintId));
            }
            this._enhance(searchRequestBuilder, this._sxpBlueprintLocalService.fetchSXPBlueprint(sxpBlueprintId));
        }
    }

    private void _enhance(SearchRequestBuilder searchRequestBuilder, SXPBlueprint sxpBlueprint) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search experiences blueprint " + sxpBlueprint));
        }
        if (sxpBlueprint == null) {
            return;
        }
        RuntimeException runtimeException = new RuntimeException();
        try {
            this._sxpBlueprintSearchRequestEnhancer.enhance(searchRequestBuilder, sxpBlueprint);
        }
        catch (Exception exception) {
            runtimeException.addSuppressed(exception);
        }
        if (ArrayUtil.isNotEmpty((Object[])runtimeException.getSuppressed()) && _log.isWarnEnabled()) {
            _log.warn((Throwable)runtimeException);
        }
        if (SXPExceptionUtil.hasErrors((Throwable)runtimeException)) {
            throw runtimeException;
        }
    }
}

