/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.search.request.enhancer;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.collapse.CollapseBuilderFactory;
import com.liferay.portal.search.collapse.InnerHitBuilderFactory;
import com.liferay.portal.search.filter.ComplexQueryPartBuilderFactory;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.highlight.FieldConfigBuilderFactory;
import com.liferay.portal.search.highlight.HighlightBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.rescore.RescoreBuilderFactory;
import com.liferay.portal.search.script.Scripts;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.significance.SignificanceHeuristics;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.search.experiences.blueprint.exception.InvalidElementInstanceException;
import com.liferay.search.experiences.blueprint.parameter.SXPParameter;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributorProvider;
import com.liferay.search.experiences.blueprint.search.request.enhancer.SXPBlueprintSearchRequestEnhancer;
import com.liferay.search.experiences.internal.blueprint.highlight.HighlightConverter;
import com.liferay.search.experiences.internal.blueprint.parameter.SXPParameterData;
import com.liferay.search.experiences.internal.blueprint.parameter.util.SXPParameterDataCreatorUtil;
import com.liferay.search.experiences.internal.blueprint.property.PropertyExpander;
import com.liferay.search.experiences.internal.blueprint.property.PropertyResolver;
import com.liferay.search.experiences.internal.blueprint.query.QueryConverter;
import com.liferay.search.experiences.internal.blueprint.script.ScriptConverter;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.AdvancedSXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.AggsSXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.GeneralSXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.HighlightSXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.QuerySXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.SXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.SortSXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.SuggestSXPSearchRequestBodyContributor;
import com.liferay.search.experiences.internal.blueprint.sort.SortConverter;
import com.liferay.search.experiences.rest.dto.v1_0.Clause;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.ElementDefinition;
import com.liferay.search.experiences.rest.dto.v1_0.ElementInstance;
import com.liferay.search.experiences.rest.dto.v1_0.Field;
import com.liferay.search.experiences.rest.dto.v1_0.FieldSet;
import com.liferay.search.experiences.rest.dto.v1_0.QueryConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.QueryEntry;
import com.liferay.search.experiences.rest.dto.v1_0.SXPBlueprint;
import com.liferay.search.experiences.rest.dto.v1_0.SXPElement;
import com.liferay.search.experiences.rest.dto.v1_0.TypeOptions;
import com.liferay.search.experiences.rest.dto.v1_0.UiConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.util.ConfigurationUtil;
import com.liferay.search.experiences.rest.dto.v1_0.util.SXPBlueprintUtil;
import java.beans.ExceptionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={SXPBlueprintSearchRequestEnhancer.class})
public class SXPBlueprintSearchRequestEnhancerImpl
implements SXPBlueprintSearchRequestEnhancer {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private CollapseBuilderFactory _collapseBuilderFactory;
    @Reference
    private ComplexQueryPartBuilderFactory _complexQueryPartBuilderFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private FieldConfigBuilderFactory _fieldConfigBuilderFactory;
    @Reference
    private GeoBuilders _geoBuilders;
    @Reference
    private HighlightBuilderFactory _highlightBuilderFactory;
    @Reference
    private InnerHitBuilderFactory _innerHitBuilderFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Queries _queries;
    @Reference
    private RescoreBuilderFactory _rescoreBuilderFactory;
    @Reference
    private Scripts _scripts;
    @Reference
    private SignificanceHeuristics _significanceHeuristics;
    @Reference
    private Sorts _sorts;
    @Reference
    private SXPParameterContributorProvider _sxpParameterContributorProvider;
    private List<SXPSearchRequestBodyContributor> _sxpSearchRequestBodyContributors;

    public void enhance(SearchRequestBuilder searchRequestBuilder, String sxpBlueprintJSON) {
        this._enhance(searchRequestBuilder, SXPBlueprintUtil.toSXPBlueprint((String)sxpBlueprintJSON));
    }

    public void enhance(SearchRequestBuilder searchRequestBuilder, com.liferay.search.experiences.model.SXPBlueprint sxpBlueprint) {
        this._enhance(searchRequestBuilder, this._toDTO(this._getDTOConverter(), sxpBlueprint));
    }

    @Activate
    protected void activate() {
        HighlightConverter highlightConverter = new HighlightConverter(this._fieldConfigBuilderFactory, this._highlightBuilderFactory);
        QueryConverter queryConverter = new QueryConverter(this._queries);
        ScriptConverter scriptConverter = new ScriptConverter(this._scripts);
        SortConverter sortConverter = new SortConverter(this._geoBuilders, queryConverter, scriptConverter, this._sorts);
        this._sxpSearchRequestBodyContributors = Arrays.asList(new AdvancedSXPSearchRequestBodyContributor(this._collapseBuilderFactory, this._innerHitBuilderFactory, sortConverter), new AggsSXPSearchRequestBodyContributor(this._aggregations, this._geoBuilders, highlightConverter, queryConverter, scriptConverter, this._significanceHeuristics, this._sorts), new GeneralSXPSearchRequestBodyContributor(), new HighlightSXPSearchRequestBodyContributor(highlightConverter), new QuerySXPSearchRequestBodyContributor(this._complexQueryPartBuilderFactory, queryConverter, this._rescoreBuilderFactory), new SuggestSXPSearchRequestBodyContributor(), new SortSXPSearchRequestBodyContributor(sortConverter));
    }

    private void _contributeSXPSearchRequestBodyContributors(Configuration configuration, ExceptionListener exceptionListener, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        if (ListUtil.isEmpty(this._sxpSearchRequestBodyContributors)) {
            return;
        }
        this._decodeQueries(configuration);
        for (SXPSearchRequestBodyContributor sxpSearchRequestBodyContributor : this._sxpSearchRequestBodyContributors) {
            try {
                sxpSearchRequestBodyContributor.contribute(configuration, searchRequestBuilder, sxpParameterData);
            }
            catch (Exception exception) {
                exceptionListener.exceptionThrown(exception);
            }
        }
    }

    private void _decodeQueries(Configuration configuration) {
        QueryConfiguration queryConfiguration = configuration.getQueryConfiguration();
        if (queryConfiguration == null || queryConfiguration.getQueryEntries() == null) {
            return;
        }
        for (QueryEntry queryEntry : queryConfiguration.getQueryEntries()) {
            Clause[] clauses = queryEntry.getClauses();
            if (clauses == null) continue;
            for (Clause clause : clauses) {
                String query = StringUtil.replace((String)String.valueOf(clause.getQuery()), (String[])new String[]{"&#34;", "&#36;", "&#91;", "&#92;", "&#93;", "&#8725;"}, (String[])new String[]{"\\\"", "$", "[", "\\\\", "]", "/"});
                clause.setQuery(() -> this._jsonFactory.createJSONObject(query));
            }
            queryEntry.setClauses(() -> clauses);
        }
    }

    private void _enhance(ElementInstance elementInstance, int index, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        Configuration configuration = this._getConfiguration(elementInstance, sxpParameterData);
        if (configuration == null) {
            return;
        }
        InvalidElementInstanceException invalidElementInstanceException = InvalidElementInstanceException.at((int)index);
        this._contributeSXPSearchRequestBodyContributors(configuration, arg_0 -> invalidElementInstanceException.addSuppressed(arg_0), searchRequestBuilder, sxpParameterData);
        if (ArrayUtil.isNotEmpty((Object[])invalidElementInstanceException.getSuppressed())) {
            throw invalidElementInstanceException;
        }
    }

    private void _enhance(SearchRequestBuilder searchRequestBuilder, SXPBlueprint sxpBlueprint) {
        if (sxpBlueprint.getConfiguration() == null && ArrayUtil.isEmpty((Object[])sxpBlueprint.getElementInstances())) {
            return;
        }
        Configuration configuration = sxpBlueprint.getConfiguration();
        if (configuration != null) {
            MapUtil.isNotEmptyForEach((Map)configuration.getSearchContextAttributes(), (key, value) -> searchRequestBuilder.withSearchContext(searchContext -> searchContext.setAttribute(key, (Serializable)value)));
        }
        RuntimeException runtimeException = new RuntimeException();
        SXPParameterData sxpParameterData = SXPParameterDataCreatorUtil.create(runtimeException::addSuppressed, (SearchContext)searchRequestBuilder.withSearchContextGet(searchContext -> searchContext), sxpBlueprint, this._sxpParameterContributorProvider.getSxpParameterContributors());
        if (configuration != null) {
            this._contributeSXPSearchRequestBodyContributors(this._expand(configuration, (name, options) -> this._resolveProperty(name, options, sxpParameterData)), runtimeException::addSuppressed, searchRequestBuilder, sxpParameterData);
        }
        this._processElementInstances(sxpBlueprint.getElementInstances(), runtimeException::addSuppressed, searchRequestBuilder, sxpParameterData);
        if (ArrayUtil.isNotEmpty((Object[])runtimeException.getSuppressed())) {
            throw runtimeException;
        }
    }

    private Configuration _expand(Configuration configuration, PropertyResolver ... propertyResolvers) {
        PropertyExpander propertyExpander = new PropertyExpander(propertyResolvers);
        return ConfigurationUtil.toConfiguration((String)propertyExpander.expand(String.valueOf(configuration)));
    }

    private Configuration _getConfiguration(ElementInstance elementInstance, SXPParameterData sxpParameterData) {
        if (elementInstance.getConfigurationEntry() != null) {
            return this._expand(elementInstance.getConfigurationEntry(), (name, options) -> this._resolveProperty(name, options, sxpParameterData));
        }
        SXPElement sxpElement = elementInstance.getSxpElement();
        if (sxpElement == null) {
            return null;
        }
        ElementDefinition elementDefinition = sxpElement.getElementDefinition();
        if (elementDefinition == null) {
            return null;
        }
        Configuration configuration = elementDefinition.getConfiguration();
        if (configuration == null) {
            return null;
        }
        return this._expand(configuration, (name, options) -> this._resolveProperty(name, options, sxpParameterData), (name, options) -> {
            String shortName = StringUtils.substringAfter((String)name, (String)"configuration.");
            if (Validator.isNull((String)shortName)) {
                return null;
            }
            UiConfiguration uiConfiguration = elementDefinition.getUiConfiguration();
            Map values = elementInstance.getUiConfigurationValues();
            if (uiConfiguration == null || uiConfiguration.getFieldSets() == null || values == null) {
                return null;
            }
            return this._unpack(this._getField(uiConfiguration.getFieldSets(), shortName), values.get(shortName));
        });
    }

    private DTOConverter<com.liferay.search.experiences.model.SXPBlueprint, SXPBlueprint> _getDTOConverter() {
        String dtoClassName = com.liferay.search.experiences.model.SXPBlueprint.class.getName();
        return this._dtoConverterRegistry.getDTOConverter(dtoClassName);
    }

    private Field _getField(Field[] fields, String name) {
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return null;
        }
        for (Field field : fields) {
            if (!Objects.equals(field.getName(), name)) continue;
            return field;
        }
        return null;
    }

    private Field _getField(FieldSet[] fieldSets, String name) {
        if (ArrayUtil.isEmpty((Object[])fieldSets)) {
            return null;
        }
        for (FieldSet fieldSet : fieldSets) {
            Field field = this._getField(fieldSet.getFields(), name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private String _getType(Field field) {
        if (field != null) {
            return field.getType();
        }
        return null;
    }

    private String _getUnitSuffix(Field field) {
        TypeOptions typeOptions;
        if (field != null && (typeOptions = field.getTypeOptions()) != null) {
            return typeOptions.getUnitSuffix();
        }
        return null;
    }

    private boolean _isNullable(Field field) {
        if (field == null) {
            return false;
        }
        TypeOptions typeOptions = field.getTypeOptions();
        if (typeOptions == null) {
            return false;
        }
        return GetterUtil.getBoolean((Object)typeOptions.getNullable());
    }

    private void _processElementInstances(ElementInstance[] elementInstances, ExceptionListener exceptionListener, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        if (ArrayUtil.isEmpty((Object[])elementInstances)) {
            return;
        }
        for (int index = 0; index < elementInstances.length; ++index) {
            try {
                this._enhance(elementInstances[index], index, searchRequestBuilder, sxpParameterData);
                continue;
            }
            catch (Exception exception) {
                exceptionListener.exceptionThrown(exception);
            }
        }
    }

    private Object _resolveProperty(String name, Map<String, String> options, SXPParameterData sxpParameterData) {
        SXPParameter sxpParameter = sxpParameterData.getSXPParameterByName(name);
        if (sxpParameter == null || !sxpParameter.isTemplateVariable()) {
            return null;
        }
        return sxpParameter.evaluateToString(options);
    }

    private SXPBlueprint _toDTO(DTOConverter<com.liferay.search.experiences.model.SXPBlueprint, SXPBlueprint> dtoConverter, com.liferay.search.experiences.model.SXPBlueprint sxpBlueprint) {
        try {
            return (SXPBlueprint)dtoConverter.toDTO((Object)sxpBlueprint);
        }
        catch (Exception exception) {
            return (SXPBlueprint)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private String _toFieldMappingString(JSONObject jsonObject) {
        Object boost;
        StringBundler sb = new StringBundler(5);
        sb.append(jsonObject.get("field"));
        String locale = jsonObject.getString("locale");
        if (Validator.isNotNull((String)locale)) {
            sb.append('_');
            sb.append(locale);
        }
        if ((boost = jsonObject.get("boost")) != null) {
            sb.append('^');
            sb.append(boost);
        }
        return sb.toString();
    }

    private Object _unpack(Field field, Object value) {
        String type = this._getType(field);
        if (value instanceof JSONObject && Objects.equals(type, "fieldMapping")) {
            return this._toFieldMappingString((JSONObject)value);
        }
        if (value instanceof JSONArray && Objects.equals(type, "fieldMappingList")) {
            ArrayList<String> fields = new ArrayList<String>();
            for (Object item : (JSONArray)value) {
                fields.add(this._toFieldMappingString((JSONObject)item));
            }
            return this._jsonFactory.createJSONArray(fields);
        }
        if (value instanceof String && Objects.equals(type, "json")) {
            try {
                return this._jsonFactory.createJSONObject((String)value);
            }
            catch (JSONException jsonException) {
                return ReflectionUtil.throwException((Throwable)jsonException);
            }
        }
        if (this._isNullable(field) && Validator.isNull((Object)value)) {
            return null;
        }
        String unitSuffix = this._getUnitSuffix(field);
        if (unitSuffix != null) {
            return value + unitSuffix;
        }
        return value;
    }
}

