/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.search.request.body.contributor;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.significance.SignificanceHeuristics;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.search.experiences.internal.blueprint.aggregation.AggregationWrapper;
import com.liferay.search.experiences.internal.blueprint.aggregation.AggregationWrapperConverter;
import com.liferay.search.experiences.internal.blueprint.highlight.HighlightConverter;
import com.liferay.search.experiences.internal.blueprint.parameter.SXPParameterData;
import com.liferay.search.experiences.internal.blueprint.query.QueryConverter;
import com.liferay.search.experiences.internal.blueprint.script.ScriptConverter;
import com.liferay.search.experiences.internal.blueprint.search.request.body.contributor.SXPSearchRequestBodyContributor;
import com.liferay.search.experiences.rest.dto.v1_0.AggregationConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import java.util.Iterator;

public class AggsSXPSearchRequestBodyContributor
implements SXPSearchRequestBodyContributor {
    private final AggregationWrapperConverter _aggregationWrapperConverter;

    public AggsSXPSearchRequestBodyContributor(Aggregations aggregations, GeoBuilders geoBuilders, HighlightConverter highlightConverter, QueryConverter queryConverter, ScriptConverter scriptConverter, SignificanceHeuristics significanceHeuristics, Sorts sorts) {
        this._aggregationWrapperConverter = new AggregationWrapperConverter(aggregations, geoBuilders, highlightConverter, queryConverter, scriptConverter, significanceHeuristics, sorts);
    }

    @Override
    public void contribute(Configuration configuration, SearchRequestBuilder searchRequestBuilder, SXPParameterData sxpParameterData) {
        AggregationConfiguration aggregationConfiguration = configuration.getAggregationConfiguration();
        if (aggregationConfiguration == null) {
            return;
        }
        this._processAggregations((JSONObject)aggregationConfiguration.getAggs(), null, searchRequestBuilder);
    }

    @Override
    public String getName() {
        return "aggs";
    }

    private void _addAggregation(AggregationWrapper aggregationWrapper, SearchRequestBuilder searchRequestBuilder) {
        if (aggregationWrapper.isPipeline()) {
            searchRequestBuilder.addPipelineAggregation(aggregationWrapper.getPipelineAggregation());
        } else {
            searchRequestBuilder.addAggregation(aggregationWrapper.getAggregation());
        }
    }

    private void _addChildAggregation(AggregationWrapper childAggregationWrapper, AggregationWrapper parentAggregationWrapper) {
        if (parentAggregationWrapper.isPipeline()) {
            return;
        }
        Aggregation aggregation = parentAggregationWrapper.getAggregation();
        if (childAggregationWrapper.isPipeline()) {
            aggregation.addPipelineAggregation(childAggregationWrapper.getPipelineAggregation());
        } else {
            aggregation.addChildAggregation(childAggregationWrapper.getAggregation());
        }
    }

    private void _processAggregation(JSONObject jsonObject, String name, AggregationWrapper parentAggregationWrapper, SearchRequestBuilder searchRequestBuilder) {
        JSONObject aggsJSONObject;
        Iterator iterator = jsonObject.keys();
        String type = (String)iterator.next();
        AggregationWrapper aggregationWrapper = this._toAggregationWrapper(jsonObject.getJSONObject(type), name, type);
        if (aggregationWrapper == null) {
            return;
        }
        if (!aggregationWrapper.isPipeline() && (aggsJSONObject = jsonObject.getJSONObject("aggs")) != null) {
            this._processAggregations(aggsJSONObject, aggregationWrapper, searchRequestBuilder);
        }
        if (parentAggregationWrapper == null) {
            this._addAggregation(aggregationWrapper, searchRequestBuilder);
        } else {
            this._addChildAggregation(aggregationWrapper, parentAggregationWrapper);
        }
    }

    private void _processAggregations(JSONObject jsonObject, AggregationWrapper parentAggregationWrapper, SearchRequestBuilder searchRequestBuilder) {
        if (jsonObject == null) {
            return;
        }
        for (String name : jsonObject.keySet()) {
            this._processAggregation(jsonObject.getJSONObject(name), name, parentAggregationWrapper, searchRequestBuilder);
        }
    }

    private AggregationWrapper _toAggregationWrapper(JSONObject jsonObject, String name, String type) {
        if (!jsonObject.getBoolean("enabled", true)) {
            return null;
        }
        return this._aggregationWrapperConverter.toAggregationWrapper(jsonObject, name, type);
    }
}

