/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.script;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.search.script.Script;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.search.script.Scripts;

public class ScriptConverter {
    private final Scripts _scripts;

    public ScriptConverter(Scripts scripts) {
        this._scripts = scripts;
    }

    public Scripts getScripts() {
        return this._scripts;
    }

    public Script toScript(Object object) {
        if (object instanceof JSONObject) {
            return this._toScript((JSONObject)object);
        }
        if (object instanceof String) {
            return this._toScript((String)object);
        }
        throw new IllegalArgumentException();
    }

    private void _processScriptOptions(JSONObject jsonObject, ScriptBuilder scriptBuilder) {
        if (jsonObject != null) {
            for (String key : jsonObject.keySet()) {
                scriptBuilder.putOption(key, jsonObject.getString(key));
            }
        }
    }

    private void _processScriptParams(JSONObject jsonObject, ScriptBuilder scriptBuilder) {
        if (jsonObject != null) {
            for (String key : jsonObject.keySet()) {
                scriptBuilder.putParameter(key, jsonObject.get(key));
            }
        }
    }

    private Script _toScript(JSONObject jsonObject) {
        ScriptBuilder scriptBuilder = this._scripts.builder();
        if (jsonObject.has("id")) {
            scriptBuilder.idOrCode(jsonObject.getString("id")).scriptType(ScriptType.STORED);
        } else if (jsonObject.has("source")) {
            scriptBuilder.idOrCode(jsonObject.getString("source")).scriptType(ScriptType.INLINE);
        }
        if (jsonObject.has("lang")) {
            scriptBuilder.language(jsonObject.getString("lang"));
        }
        this._processScriptOptions(jsonObject.getJSONObject("options"), scriptBuilder);
        this._processScriptParams(jsonObject.getJSONObject("params"), scriptBuilder);
        return scriptBuilder.build();
    }

    private Script _toScript(String string) {
        return this._scripts.builder().idOrCode(string).language("painless").scriptType(ScriptType.INLINE).build();
    }
}

