/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.query;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermQuery;
import com.liferay.search.experiences.internal.blueprint.property.PropertyValidator;
import java.util.Iterator;
import java.util.Objects;

public class QueryConverter {
    private final Queries _queries;

    public QueryConverter(Queries queries) {
        this._queries = queries;
    }

    public Query toQuery(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        Iterator iterator = jsonObject.keys();
        if (!iterator.hasNext()) {
            return null;
        }
        String type = (String)iterator.next();
        if (Objects.equals(type, "term")) {
            return this._toTermQuery(jsonObject.getJSONObject(type));
        }
        return this._queries.wrapper(PropertyValidator.validate(JSONUtil.toString((JSONObject)jsonObject)));
    }

    private Query _toTermQuery(JSONObject jsonObject1) {
        Iterator iterator = jsonObject1.keys();
        String field = (String)iterator.next();
        Object object = jsonObject1.get(field);
        if (object instanceof JSONObject) {
            JSONObject jsonObject2 = (JSONObject)object;
            TermQuery query = this._queries.term(field, PropertyValidator.validate(Objects.requireNonNull(jsonObject2.get("value"), "The key \"value\" is not set")));
            if (jsonObject2.get("boost") != null) {
                query.setBoost(Float.valueOf((float)jsonObject2.getDouble("boost")));
            }
            return query;
        }
        return this._queries.term(field, PropertyValidator.validate(object));
    }
}

