/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.parameter.util;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.search.experiences.blueprint.parameter.SXPParameter;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributor;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributorDefinition;
import com.liferay.search.experiences.internal.blueprint.parameter.BooleanSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.DateSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.DoubleSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.FloatSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.IntegerArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.IntegerSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.LongArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.LongSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.SXPParameterData;
import com.liferay.search.experiences.internal.blueprint.parameter.StringArraySXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.StringSXPParameter;
import com.liferay.search.experiences.rest.dto.v1_0.Configuration;
import com.liferay.search.experiences.rest.dto.v1_0.Parameter;
import com.liferay.search.experiences.rest.dto.v1_0.ParameterConfiguration;
import com.liferay.search.experiences.rest.dto.v1_0.SXPBlueprint;
import java.beans.ExceptionListener;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class SXPParameterDataCreatorUtil {
    public static SXPParameterData create(ExceptionListener exceptionListener, SearchContext searchContext, SXPBlueprint sxpBlueprint, SXPParameterContributor[] sxpParameterContributors) {
        LinkedHashMap<String, SXPParameter> sxpParameters = new LinkedHashMap<String, SXPParameter>();
        String keywords = SXPParameterDataCreatorUtil._addKeywordsSXPParameters(searchContext, sxpParameters);
        Configuration configuration = sxpBlueprint.getConfiguration();
        if (configuration != null) {
            SXPParameterDataCreatorUtil._addSXPParameters(configuration.getParameterConfiguration(), searchContext, sxpParameters);
        }
        SXPParameterDataCreatorUtil._contribute(exceptionListener, searchContext, sxpParameters, sxpParameterContributors);
        return new SXPParameterData(keywords, sxpParameters);
    }

    private static void _add(SXPParameter sxpParameter, Map<String, SXPParameter> sxpParameters) {
        sxpParameters.put(sxpParameter.getName(), sxpParameter);
    }

    private static String _addKeywordsSXPParameters(SearchContext searchContext, Map<String, SXPParameter> sxpParameters) {
        String keywords = GetterUtil.getString((String)searchContext.getKeywords());
        if (StringUtil.count((String)keywords, (char)'\"') % 2 != 0) {
            keywords = StringUtil.replace((String)keywords, (char)'\"', (String)"");
        }
        keywords = keywords.replaceAll("/", "&#8725;");
        keywords = keywords.replaceAll("\"", "&#34;");
        keywords = keywords.replaceAll("\\$", "&#36;");
        keywords = keywords.replaceAll("\\[", "&#91;");
        keywords = keywords.replaceAll("\\\\", "&#92;");
        keywords = keywords.replaceAll("\\]", "&#93;");
        SXPParameterDataCreatorUtil._add(new StringSXPParameter("keywords", true, keywords), sxpParameters);
        return keywords;
    }

    private static void _addSXPParameter(SearchContext searchContext, SXPParameterContributorDefinition sxpParameterContributorDefinition, Map<String, SXPParameter> sxpParameters) {
        String name = StringUtils.substringBetween((String)sxpParameterContributorDefinition.getTemplateVariable(), (String)"${", (String)"}");
        Serializable object = searchContext.getAttribute(name);
        if (object == null) {
            return;
        }
        SXPParameter sxpParameter = SXPParameterDataCreatorUtil._getSXPParameter(name, object, new Parameter(), searchContext, SXPParameterDataCreatorUtil._getType(sxpParameterContributorDefinition));
        if (sxpParameter == null) {
            return;
        }
        SXPParameterDataCreatorUtil._add(sxpParameter, sxpParameters);
    }

    private static void _addSXPParameter(String name, Parameter parameter, SearchContext searchContext, Map<String, SXPParameter> sxpParameters) {
        Serializable object = searchContext.getAttribute(name);
        if (object == null) {
            return;
        }
        SXPParameter sxpParameter = SXPParameterDataCreatorUtil._getSXPParameter(name, object, parameter, searchContext, parameter.getType());
        if (sxpParameter == null) {
            return;
        }
        SXPParameterDataCreatorUtil._add(sxpParameter, sxpParameters);
    }

    private static void _addSXPParameters(ParameterConfiguration parameterConfiguration, SearchContext searchContext, Map<String, SXPParameter> sxpParameters) {
        if (parameterConfiguration == null) {
            return;
        }
        MapUtil.isNotEmptyForEach((Map)parameterConfiguration.getParameters(), (name, parameter) -> SXPParameterDataCreatorUtil._addSXPParameter(name, parameter, searchContext, sxpParameters));
    }

    private static void _contribute(ExceptionListener exceptionListener, SearchContext searchContext, Map<String, SXPParameter> sxpParameters, SXPParameterContributor[] sxpParameterContributors) {
        if (ArrayUtil.isEmpty((Object[])sxpParameterContributors)) {
            return;
        }
        for (SXPParameterContributor sxpParameterContributor : sxpParameterContributors) {
            LinkedHashSet set = new LinkedHashSet();
            sxpParameterContributor.contribute(exceptionListener, searchContext, set);
            for (SXPParameter sxpParameter : set) {
                SXPParameterDataCreatorUtil._add(sxpParameter, sxpParameters);
            }
            List sxpParameterContributorDefinitions = sxpParameterContributor.getSXPParameterContributorDefinitions(searchContext.getCompanyId(), searchContext.getLocale());
            if (!ListUtil.isNotEmpty((List)sxpParameterContributorDefinitions)) continue;
            for (SXPParameterContributorDefinition sxpParameterContributorDefinition : sxpParameterContributorDefinitions) {
                SXPParameterDataCreatorUtil._addSXPParameter(searchContext, sxpParameterContributorDefinition, sxpParameters);
            }
        }
    }

    private static Double _fit(Double maxValue, Double minValue, Double value) {
        if (minValue != null && value < minValue) {
            return minValue;
        }
        if (maxValue != null && value > maxValue) {
            return maxValue;
        }
        return value;
    }

    private static Float _fit(Float maxValue, Float minValue, Float value) {
        if (minValue != null && value.floatValue() < minValue.floatValue()) {
            return minValue;
        }
        if (maxValue != null && value.floatValue() > maxValue.floatValue()) {
            return maxValue;
        }
        return value;
    }

    private static Integer _fit(Integer maxValue, Integer minValue, Integer value) {
        if (minValue != null && value < minValue) {
            return minValue;
        }
        if (maxValue != null && value > maxValue) {
            return maxValue;
        }
        return value;
    }

    private static Long _fit(Long maxValue, Long minValue, Long value) {
        if (minValue != null && value < minValue) {
            return minValue;
        }
        if (maxValue != null && value > maxValue) {
            return maxValue;
        }
        return value;
    }

    private static Boolean _getBoolean(Boolean defaultValue, Object object) {
        if (object != null) {
            return GetterUtil.getBoolean((Object)object);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static SXPParameter _getBooleanSXPParameter(String name, Object object, Parameter parameter) {
        Boolean value = SXPParameterDataCreatorUtil._getBoolean((Boolean)parameter.getDefaultValue(), object);
        if (value == null) {
            return null;
        }
        return new BooleanSXPParameter(name, true, value);
    }

    private static SXPParameter _getDateSXPParameter(String name, Object object, TimeZone timeZone, Parameter parameter) {
        String value = SXPParameterDataCreatorUtil._getString(null, object);
        if (value == null) {
            return null;
        }
        LocalDate localDate = LocalDate.parse(value, DateTimeFormatter.ofPattern(parameter.getFormat()));
        GregorianCalendar calendar = GregorianCalendar.from(localDate.atStartOfDay(timeZone.toZoneId()));
        Date date = calendar.getTime();
        if (date == null) {
            return null;
        }
        return new DateSXPParameter(name, true, date);
    }

    private static Double _getDouble(Double defaultValue, Object object) {
        if (object != null) {
            return GetterUtil.getDouble((Object)object);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static SXPParameter _getDoubleSXPParameter(String name, Object object, Parameter parameter) {
        Double value = SXPParameterDataCreatorUtil._getDouble((Double)parameter.getDefaultValue(), object);
        if (value == null) {
            return null;
        }
        return new DoubleSXPParameter(name, true, SXPParameterDataCreatorUtil._fit((Double)parameter.getMax(), (Double)parameter.getMin(), value));
    }

    private static Float _getFloat(Float defaultValue, Object object) {
        if (object != null) {
            return Float.valueOf(GetterUtil.getFloat((Object)object));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static SXPParameter _getFloatSXPParameter(String name, Object object, Parameter parameter) {
        Float value = SXPParameterDataCreatorUtil._getFloat((Float)parameter.getDefaultValue(), object);
        if (value == null) {
            return null;
        }
        return new FloatSXPParameter(name, true, SXPParameterDataCreatorUtil._fit((Float)parameter.getMax(), (Float)parameter.getMin(), value));
    }

    private static Integer _getInteger(Integer defaultValue, Object object) {
        if (object != null) {
            return GetterUtil.getInteger((Object)object);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static Integer[] _getIntegerArray(Integer[] defaultValue, Object object) {
        if (object instanceof String) {
            return ArrayUtil.toArray((int[])GetterUtil.getIntegerValues((String[])StringUtil.split((String)((String)object))));
        }
        if (object != null) {
            return ArrayUtil.toArray((int[])GetterUtil.getIntegerValues((Object)object));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static SXPParameter _getIntegerArraySXPParameter(String name, Object object, Parameter parameter) {
        Object[] value = SXPParameterDataCreatorUtil._getIntegerArray((Integer[])parameter.getDefaultValue(), object);
        if (ArrayUtil.isEmpty((Object[])value)) {
            return null;
        }
        return new IntegerArraySXPParameter(name, true, (Integer[])value);
    }

    private static SXPParameter _getIntegerSXPParameter(String name, Object object, Parameter parameter) {
        Integer value = SXPParameterDataCreatorUtil._getInteger((Integer)parameter.getDefaultValue(), object);
        if (value == null) {
            return null;
        }
        return new IntegerSXPParameter(name, true, SXPParameterDataCreatorUtil._fit((Integer)parameter.getMax(), (Integer)parameter.getMin(), value));
    }

    private static Long _getLong(Long defaultValue, Object object) {
        if (object != null) {
            return GetterUtil.getLong((Object)object);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static Long[] _getLongArray(Long[] defaultValue, Object object) {
        if (object instanceof String) {
            return ArrayUtil.toArray((long[])GetterUtil.getLongValues((String[])StringUtil.split((String)((String)object))));
        }
        if (object != null) {
            return ArrayUtil.toArray((long[])GetterUtil.getLongValues((Object)object));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static SXPParameter _getLongArraySXPParameter(String name, Object object, Parameter parameter) {
        Object[] value = SXPParameterDataCreatorUtil._getLongArray((Long[])parameter.getDefaultValue(), object);
        if (ArrayUtil.isEmpty((Object[])value)) {
            return null;
        }
        return new LongArraySXPParameter(name, true, (Long[])value);
    }

    private static SXPParameter _getLongSXPParameter(String name, Object object, Parameter parameter) {
        Long value = SXPParameterDataCreatorUtil._getLong((Long)parameter.getDefaultValue(), object);
        if (value == null) {
            return null;
        }
        return new LongSXPParameter(name, true, SXPParameterDataCreatorUtil._fit((Long)parameter.getMax(), (Long)parameter.getMin(), value));
    }

    private static String _getString(String defaultValue, Object object) {
        if (object != null) {
            return GetterUtil.getString((Object)object);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static String[] _getStringArray(String[] defaultValue, Object object) {
        if (object != null) {
            return GetterUtil.getStringValues((Object)object);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    private static SXPParameter _getStringArraySXPParameter(String name, Object object, Parameter parameter) {
        Object[] value = SXPParameterDataCreatorUtil._getStringArray((String[])parameter.getDefaultValue(), object);
        if (ArrayUtil.isEmpty((Object[])value)) {
            return null;
        }
        return new StringArraySXPParameter(name, true, (String[])value);
    }

    private static SXPParameter _getStringSXPParameter(String name, Object object, Parameter parameter) {
        String value = SXPParameterDataCreatorUtil._getString((String)parameter.getDefaultValue(), object);
        if (value == null) {
            return null;
        }
        return new StringSXPParameter(name, true, value);
    }

    private static SXPParameter _getSXPParameter(String name, Object object, Parameter parameter, SearchContext searchContext, Parameter.Type type) {
        if (type.equals((Object)Parameter.Type.BOOLEAN)) {
            return SXPParameterDataCreatorUtil._getBooleanSXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.DATE)) {
            return SXPParameterDataCreatorUtil._getDateSXPParameter(name, object, searchContext.getTimeZone(), parameter);
        }
        if (type.equals((Object)Parameter.Type.DOUBLE)) {
            return SXPParameterDataCreatorUtil._getDoubleSXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.FLOAT)) {
            return SXPParameterDataCreatorUtil._getFloatSXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.INTEGER)) {
            return SXPParameterDataCreatorUtil._getIntegerSXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.INTEGER_ARRAY)) {
            return SXPParameterDataCreatorUtil._getIntegerArraySXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.LONG)) {
            return SXPParameterDataCreatorUtil._getLongSXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.LONG_ARRAY)) {
            return SXPParameterDataCreatorUtil._getLongArraySXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.STRING)) {
            return SXPParameterDataCreatorUtil._getStringSXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.STRING_ARRAY)) {
            return SXPParameterDataCreatorUtil._getStringArraySXPParameter(name, object, parameter);
        }
        if (type.equals((Object)Parameter.Type.TIME_RANGE)) {
            return SXPParameterDataCreatorUtil._getTimeRangeSXPParameter(name, object);
        }
        throw new IllegalArgumentException();
    }

    private static SXPParameter _getTimeRangeSXPParameter(String name, Object object) {
        String value = SXPParameterDataCreatorUtil._getString(null, object);
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        if (value.equals("last-day")) {
            calendar.add(5, -1);
        } else if (value.equals("last-hour")) {
            calendar.add(11, -1);
        } else if (value.equals("last-month")) {
            calendar.add(2, -1);
        } else if (value.equals("last-week")) {
            calendar.add(4, -1);
        } else if (value.equals("last-year")) {
            calendar.add(1, -1);
        }
        return new DateSXPParameter(name, true, calendar.getTime());
    }

    private static Parameter.Type _getType(SXPParameterContributorDefinition sxpParameterContributorDefinition) {
        String className = sxpParameterContributorDefinition.getClassName();
        if (className.equals(BooleanSXPParameter.class.getName())) {
            return Parameter.Type.BOOLEAN;
        }
        if (className.equals(DateSXPParameter.class.getName())) {
            return Parameter.Type.DATE;
        }
        if (className.equals(DoubleSXPParameter.class.getName())) {
            return Parameter.Type.DOUBLE;
        }
        if (className.equals(FloatSXPParameter.class.getName())) {
            return Parameter.Type.FLOAT;
        }
        if (className.equals(IntegerSXPParameter.class.getName())) {
            return Parameter.Type.INTEGER;
        }
        if (className.equals(IntegerArraySXPParameter.class.getName())) {
            return Parameter.Type.INTEGER_ARRAY;
        }
        if (className.equals(LongSXPParameter.class.getName())) {
            return Parameter.Type.LONG;
        }
        if (className.equals(LongArraySXPParameter.class.getName())) {
            return Parameter.Type.LONG_ARRAY;
        }
        if (className.equals(StringSXPParameter.class.getName())) {
            return Parameter.Type.STRING;
        }
        if (className.equals(StringArraySXPParameter.class.getName())) {
            return Parameter.Type.STRING_ARRAY;
        }
        throw new IllegalArgumentException();
    }
}

