/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.parameter.contributor;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.search.experiences.blueprint.parameter.SXPParameter;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributor;
import com.liferay.search.experiences.blueprint.parameter.contributor.SXPParameterContributorDefinition;
import com.liferay.search.experiences.internal.blueprint.parameter.DoubleSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.IntegerSXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.StringSXPParameter;
import com.liferay.search.experiences.internal.configuration.IpstackConfiguration;
import com.liferay.search.experiences.internal.configuration.OpenWeatherMapConfiguration;
import com.liferay.search.experiences.internal.web.cache.IpstackWebCacheItem;
import com.liferay.search.experiences.internal.web.cache.OpenWeatherMapWebCacheItem;
import java.beans.ExceptionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class OpenWeatherMapSXPParameterContributor
implements SXPParameterContributor {
    private final ConfigurationProvider _configurationProvider;

    public OpenWeatherMapSXPParameterContributor(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    public void contribute(ExceptionListener exceptionListener, SearchContext searchContext, Set<SXPParameter> sxpParameters) {
        String longitude;
        OpenWeatherMapConfiguration openWeatherMapConfiguration = this._getOpenWeatherMapConfiguration(searchContext.getCompanyId());
        if (!openWeatherMapConfiguration.enabled()) {
            return;
        }
        String ipAddress = (String)((Object)searchContext.getAttribute("search.experiences.ip.address"));
        if (Validator.isNull((String)ipAddress)) {
            return;
        }
        JSONObject jsonObject = IpstackWebCacheItem.get(exceptionListener, ipAddress, this._getIpstackConfiguration(searchContext.getCompanyId()));
        if (jsonObject.length() == 0) {
            return;
        }
        String latitude = jsonObject.getString("latitude");
        if ((jsonObject = OpenWeatherMapWebCacheItem.get(exceptionListener, latitude, longitude = jsonObject.getString("longitude"), openWeatherMapConfiguration)).length() == 0) {
            return;
        }
        sxpParameters.add(new DoubleSXPParameter("openweathermap.temp", true, JSONUtil.getValueAsDouble((Object)jsonObject, (String[])new String[]{"JSONObject/main", "Object/temp"})));
        sxpParameters.add(new StringSXPParameter("openweathermap.weather_description", true, JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"JSONArray/weather", "JSONObject/0", "Object/description"})));
        sxpParameters.add(new IntegerSXPParameter("openweathermap.weather_id", true, JSONUtil.getValueAsInt((Object)jsonObject, (String[])new String[]{"JSONArray/weather", "JSONObject/0", "Object/id"})));
        sxpParameters.add(new StringSXPParameter("openweathermap.weather_main", true, JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"JSONArray/weather", "JSONObject/0", "Object/main"})));
        sxpParameters.add(new DoubleSXPParameter("openweathermap.wind_speed", true, JSONUtil.getValueAsDouble((Object)jsonObject, (String[])new String[]{"JSONObject/wind", "Object/speed"})));
    }

    public String getSXPParameterCategoryNameKey() {
        return "weather";
    }

    public List<SXPParameterContributorDefinition> getSXPParameterContributorDefinitions(long companyId, Locale locale) {
        OpenWeatherMapConfiguration openWeatherMapConfiguration = this._getOpenWeatherMapConfiguration(companyId);
        if (!openWeatherMapConfiguration.enabled()) {
            return Collections.emptyList();
        }
        return Arrays.asList(new SXPParameterContributorDefinition(DoubleSXPParameter.class, "temperature", "openweathermap.temp"), new SXPParameterContributorDefinition(StringSXPParameter.class, "description", "openweathermap.weather_description"), new SXPParameterContributorDefinition(IntegerSXPParameter.class, "weather-condition-id", "openweathermap.weather_id"), new SXPParameterContributorDefinition(StringSXPParameter.class, "weather-condition-name", "openweathermap.weather_main"), new SXPParameterContributorDefinition(DoubleSXPParameter.class, "wind-speed", "openweathermap.wind_speed"));
    }

    private IpstackConfiguration _getIpstackConfiguration(long companyId) {
        try {
            return (IpstackConfiguration)this._configurationProvider.getCompanyConfiguration(IpstackConfiguration.class, companyId);
        }
        catch (ConfigurationException configurationException) {
            return (IpstackConfiguration)ReflectionUtil.throwException((Throwable)configurationException);
        }
    }

    private OpenWeatherMapConfiguration _getOpenWeatherMapConfiguration(long companyId) {
        try {
            return (OpenWeatherMapConfiguration)this._configurationProvider.getCompanyConfiguration(OpenWeatherMapConfiguration.class, companyId);
        }
        catch (ConfigurationException configurationException) {
            return (OpenWeatherMapConfiguration)ReflectionUtil.throwException((Throwable)configurationException);
        }
    }
}

