/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.parameter;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.search.experiences.internal.blueprint.parameter.BaseSXPParameter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class DateSXPParameter
extends BaseSXPParameter {
    private final Date _value;

    public DateSXPParameter(String name, boolean templateVariable, Date value) {
        super(name, templateVariable);
        this._value = value;
    }

    @Override
    public boolean evaluateEquals(String format, Object object) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return Objects.equals(dateFormat.format(this._value), GetterUtil.getString((Object)object));
    }

    @Override
    public boolean evaluateRange(String format, Object gt, Object gte, Object lt, Object lte) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date value = this._parse(dateFormat, dateFormat.format(this._value));
        Function<Object, Integer> function = object -> value.compareTo(this._parse(dateFormat, String.valueOf(object)));
        if (gt != null && function.apply(gt) <= 0) {
            return false;
        }
        if (gte != null && function.apply(gte) < 0) {
            return false;
        }
        if (lt != null && function.apply(lt) >= 0) {
            return false;
        }
        return lte == null || function.apply(lte) <= 0;
    }

    @Override
    public String evaluateToString(Map<String, String> options) {
        String dateFormatString;
        if (options == null || options.get("date_format") == null) {
            return this._value.toString();
        }
        Date date = this._value;
        if (options.containsKey("modifier")) {
            date = this._modify(date, options.get("modifier"));
        }
        if ((dateFormatString = options.get("date_format")).equals("timestamp")) {
            return String.valueOf(date.getTime());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
        return dateFormat.format(date);
    }

    public Date getValue() {
        return this._value;
    }

    private Date _modify(Date date, String option) {
        if (Validator.isNull((String)option) || !option.matches("^[\\+|\\-][0-9]+[h|d|w|M|y]")) {
            return date;
        }
        char operator = option.charAt(0);
        char unit = option.charAt(option.length() - 1);
        option = option.replaceAll("\\D+", "");
        long amount = GetterUtil.getLong((String)option);
        if (operator == '-') {
            amount *= -1L;
        }
        Instant instant = date.toInstant();
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        if (unit == 'h') {
            localDateTime = localDateTime.plusHours(amount);
        } else if (unit == 'd') {
            localDateTime = localDateTime.plusDays(amount);
        } else if (unit == 'w') {
            localDateTime = localDateTime.plusWeeks(amount);
        } else if (unit == 'M') {
            localDateTime = localDateTime.plusMonths(amount);
        } else if (unit == 'y') {
            localDateTime = localDateTime.plusYears(amount);
        }
        zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    private Date _parse(DateFormat dateFormat, String string) {
        try {
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return (Date)ReflectionUtil.throwException((Throwable)parseException);
        }
    }
}

