/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.condition;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.search.experiences.blueprint.exception.InvalidParameterException;
import com.liferay.search.experiences.blueprint.parameter.SXPParameter;
import com.liferay.search.experiences.internal.blueprint.parameter.SXPParameterData;
import com.liferay.search.experiences.rest.dto.v1_0.Condition;
import com.liferay.search.experiences.rest.dto.v1_0.Contains;
import com.liferay.search.experiences.rest.dto.v1_0.Equals;
import com.liferay.search.experiences.rest.dto.v1_0.Exists;
import com.liferay.search.experiences.rest.dto.v1_0.In;
import com.liferay.search.experiences.rest.dto.v1_0.Range;
import java.util.Objects;

public class SXPConditionEvaluator {
    private final SXPParameterData _sxpParameterData;

    public SXPConditionEvaluator(SXPParameterData sxpParameterData) {
        this._sxpParameterData = sxpParameterData;
    }

    public boolean evaluate(Condition condition) {
        if (condition == null) {
            return true;
        }
        return this._evaluateAllConditions(condition.getAllConditions()) && this._evaluateAnyConditions(condition.getAnyConditions()) && this._evaluateContains(condition.getContains()) && this._evaluateEquals(condition.getEquals()) && this._evaluateExists(condition.getExists()) && this._evaluateIn(condition.getIn()) && this._evaluateNot(condition.getNot()) && this._evaluateRange(condition.getRange());
    }

    private boolean _evaluateAllConditions(Condition[] conditions) {
        if (conditions == null) {
            return true;
        }
        for (Condition condition : conditions) {
            if (this.evaluate(condition)) continue;
            return false;
        }
        return true;
    }

    private boolean _evaluateAnyConditions(Condition[] conditions) {
        if (conditions == null) {
            return true;
        }
        for (Condition condition : conditions) {
            if (!this.evaluate(condition)) continue;
            return true;
        }
        return false;
    }

    private boolean _evaluateContains(Contains contains) {
        if (contains == null) {
            return true;
        }
        SXPParameter sxpParameter = this._getSXPParameter(contains.getParameterName());
        return sxpParameter.evaluateContains(this._getValue(contains.getValue()));
    }

    private boolean _evaluateEquals(Equals equals) {
        if (equals == null) {
            return true;
        }
        SXPParameter sxpParameter = this._getSXPParameter(equals.getParameterName());
        if (equals.getFormat() != null) {
            return sxpParameter.evaluateEquals(equals.getFormat(), this._getValue(equals.getValue()));
        }
        return sxpParameter.evaluateEquals(this._getValue(equals.getValue()));
    }

    private boolean _evaluateExists(Exists exists) {
        if (exists == null) {
            return true;
        }
        return !Objects.isNull(this._sxpParameterData.getSXPParameterByName(exists.getParameterName()));
    }

    private boolean _evaluateIn(In in) {
        if (in == null) {
            return true;
        }
        SXPParameter sxpParameter = this._getSXPParameter(in.getParameterName());
        return sxpParameter.evaluateIn(this._getValue(in.getValue()));
    }

    private boolean _evaluateNot(Condition condition) {
        if (condition == null) {
            return true;
        }
        return !this.evaluate(condition);
    }

    private boolean _evaluateRange(Range range) {
        if (range == null) {
            return true;
        }
        SXPParameter sxpParameter = this._getSXPParameter(range.getParameterName());
        if (range.getFormat() != null) {
            return sxpParameter.evaluateRange(range.getFormat(), range.getGt(), range.getGte(), range.getLt(), range.getLte());
        }
        return sxpParameter.evaluateRange(range.getGt(), range.getGte(), range.getLt(), range.getLte());
    }

    private SXPParameter _getSXPParameter(String name) {
        SXPParameter sxpParameter = this._sxpParameterData.getSXPParameterByName(name);
        if (sxpParameter != null) {
            return sxpParameter;
        }
        throw InvalidParameterException.with((String)name);
    }

    private Object _getValue(Object value) {
        if (value instanceof JSONArray) {
            return JSONUtil.toObjectArray((JSONArray)((JSONArray)value));
        }
        return value;
    }
}

