/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.search.experiences.internal.blueprint.aggregation;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.bucket.CollectionMode;
import com.liferay.portal.search.aggregation.bucket.DateHistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.DateRangeAggregation;
import com.liferay.portal.search.aggregation.bucket.DiversifiedSamplerAggregation;
import com.liferay.portal.search.aggregation.bucket.FilterAggregation;
import com.liferay.portal.search.aggregation.bucket.FiltersAggregation;
import com.liferay.portal.search.aggregation.bucket.GeoDistanceAggregation;
import com.liferay.portal.search.aggregation.bucket.GeoHashGridAggregation;
import com.liferay.portal.search.aggregation.bucket.GlobalAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.IncludeExcludeClause;
import com.liferay.portal.search.aggregation.bucket.MissingAggregation;
import com.liferay.portal.search.aggregation.bucket.NestedAggregation;
import com.liferay.portal.search.aggregation.bucket.Order;
import com.liferay.portal.search.aggregation.bucket.Range;
import com.liferay.portal.search.aggregation.bucket.RangeAggregation;
import com.liferay.portal.search.aggregation.bucket.ReverseNestedAggregation;
import com.liferay.portal.search.aggregation.bucket.SamplerAggregation;
import com.liferay.portal.search.aggregation.bucket.SignificantTermsAggregation;
import com.liferay.portal.search.aggregation.bucket.SignificantTextAggregation;
import com.liferay.portal.search.aggregation.bucket.TermsAggregation;
import com.liferay.portal.search.aggregation.metrics.AvgAggregation;
import com.liferay.portal.search.aggregation.metrics.CardinalityAggregation;
import com.liferay.portal.search.aggregation.metrics.ExtendedStatsAggregation;
import com.liferay.portal.search.aggregation.metrics.GeoBoundsAggregation;
import com.liferay.portal.search.aggregation.metrics.GeoCentroidAggregation;
import com.liferay.portal.search.aggregation.metrics.MaxAggregation;
import com.liferay.portal.search.aggregation.metrics.MinAggregation;
import com.liferay.portal.search.aggregation.metrics.PercentileRanksAggregation;
import com.liferay.portal.search.aggregation.metrics.PercentilesAggregation;
import com.liferay.portal.search.aggregation.metrics.PercentilesMethod;
import com.liferay.portal.search.aggregation.metrics.ScriptedMetricAggregation;
import com.liferay.portal.search.aggregation.metrics.StatsAggregation;
import com.liferay.portal.search.aggregation.metrics.SumAggregation;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregation;
import com.liferay.portal.search.aggregation.metrics.ValueCountAggregation;
import com.liferay.portal.search.aggregation.metrics.WeightedAvgAggregation;
import com.liferay.portal.search.aggregation.pipeline.AvgBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketScriptPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketSelectorPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketSortPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.CumulativeSumPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.DerivativePipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.ExtendedStatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.GapPolicy;
import com.liferay.portal.search.aggregation.pipeline.MaxBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MinBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MovingFunctionPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SerialDiffPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SumBucketPipelineAggregation;
import com.liferay.portal.search.geolocation.DistanceUnit;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.geolocation.GeoDistanceType;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.script.Script;
import com.liferay.portal.search.script.ScriptField;
import com.liferay.portal.search.script.ScriptFieldBuilder;
import com.liferay.portal.search.script.Scripts;
import com.liferay.portal.search.significance.SignificanceHeuristic;
import com.liferay.portal.search.significance.SignificanceHeuristics;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.search.experiences.internal.blueprint.aggregation.AggregationWrapper;
import com.liferay.search.experiences.internal.blueprint.highlight.HighlightConverter;
import com.liferay.search.experiences.internal.blueprint.query.QueryConverter;
import com.liferay.search.experiences.internal.blueprint.script.ScriptConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class AggregationWrapperConverter {
    private final Aggregations _aggregations;
    private final Map<String, ConvertFunction> _convertFunctions = new HashMap<String, ConvertFunction>();
    private final GeoBuilders _geoBuilders;
    private final HighlightConverter _highlightConverter;
    private final QueryConverter _queryConverter;
    private final ScriptConverter _scriptConverter;
    private final Scripts _scripts;
    private final SignificanceHeuristics _significanceHeuristics;
    private final Sorts _sorts;

    public AggregationWrapperConverter(Aggregations aggregations, GeoBuilders geoBuilders, HighlightConverter highlightConverter, QueryConverter queryConverter, ScriptConverter scriptConverter, SignificanceHeuristics significanceHeuristics, Sorts sorts) {
        this._aggregations = aggregations;
        this._geoBuilders = geoBuilders;
        this._highlightConverter = highlightConverter;
        this._queryConverter = queryConverter;
        this._scriptConverter = scriptConverter;
        this._significanceHeuristics = significanceHeuristics;
        this._sorts = sorts;
        this._convertFunctions.putAll(HashMapBuilder.put((Object)"date_histogram", this::_toDateHistogramAggregation).put((Object)"date_range", this::_toDateRangeAggregation).put((Object)"diversified_sampler", this::_toDiversifiedSamplerAggregation).put((Object)"filter", this::_toFilterAggregation).put((Object)"filters", this::_toFiltersAggregation).put((Object)"geo_distance", this::_toGeoDistanceAggregation).put((Object)"geohash_grid", this::_toGeoHashGridAggregation).put((Object)"global", this::_toGlobalAggregation).put((Object)"histogram", this::_toHistogramAggregation).put((Object)"missing", this::_toMissingAggregation).put((Object)"nested", this::_toNestedAggregation).put((Object)"range", this::_toRangeAggregation).put((Object)"reverse_nested", this::_toReverseNestedAggregation).put((Object)"sampler", this::_toSamplerAggregation).put((Object)"significant_terms", this::_toSignificantTermsAggregation).put((Object)"significant_text", this::_toSignificantTextAggregation).put((Object)"terms", this::_toTermsAggregation).build());
        this._convertFunctions.putAll(HashMapBuilder.put((Object)"avg", this::_toAvgAggregation).put((Object)"cardinality", this::_toCardinalityAggregation).put((Object)"extended_stats", this::_toExtendedStatsAggregation).put((Object)"geo_bounds", this::_toGeoBoundsAggregation).put((Object)"geo_centroid", this::_toGeoCentroidAggregation).put((Object)"max", this::_toMaxAggregation).put((Object)"min", this::_toMinAggregation).put((Object)"percentile_ranks", this::_toPercentileRanksAggregation).put((Object)"percentiles", this::_toPercentilesAggregation).put((Object)"scripted_metric", this::_toScriptedMetricAggregation).put((Object)"stats", this::_toStatsAggregation).put((Object)"sum", this::_toSumAggregation).put((Object)"top_hits", this::_toTopHitsAggregation).put((Object)"value_count", this::_toValueCountAggregation).put((Object)"weighted_avg", this::_toWeightedAvgAggregation).build());
        this._convertFunctions.putAll(HashMapBuilder.put((Object)"avg_bucket", this::_toAvgBucketPipelineAggregation).put((Object)"bucket_script", this::_toBucketScriptPipelineAggregation).put((Object)"bucket_selector", this::_toBucketSelectorPipelineAggregation).put((Object)"bucket_sort", this::_toBucketSortPipelineAggregation).put((Object)"cumulative_sum", this::_toCumulativeSumPipelineAggregation).put((Object)"derivative", this::_toDerivativePipelineAggregation).put((Object)"extended_stats_bucket", this::_toExtendedStatsBucketPipelineAggregation).put((Object)"max_bucket", this::_toMaxBucketPipelineAggregation).put((Object)"min_bucket", this::_toMinBucketPipelineAggregation).put((Object)"moving_function", this::_toMovingFunctionPipelineAggregation).put((Object)"percentiles_bucket", this::_toPercentilesBucketPipelineAggregation).put((Object)"serial_differencing", this::_toSerialDiffPipelineAggregation).put((Object)"stats_bucket", this::_toStatsBucketPipelineAggregation).put((Object)"sum_bucket", this::_toSumBucketPipelineAggregation).build());
        this._scripts = scriptConverter.getScripts();
    }

    public AggregationWrapper toAggregationWrapper(JSONObject jsonObject, String name, String type) {
        ConvertFunction convertFunction = this._convertFunctions.get(type);
        if (convertFunction == null) {
            throw new IllegalArgumentException("Unknown aggregation " + type);
        }
        try {
            Object object = convertFunction.apply(jsonObject, name);
            if (object == null) {
                return null;
            }
            if (object instanceof Aggregation) {
                return new AggregationWrapper((Aggregation)object);
            }
            if (object instanceof PipelineAggregation) {
                return new AggregationWrapper((PipelineAggregation)object);
            }
            throw new RuntimeException(StringBundler.concat((Object[])new Object[]{"JSON ", jsonObject, " converted to unexpected class ", object.getClass()}));
        }
        catch (Exception exception) {
            return (AggregationWrapper)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private void _addBucketsPaths(BiConsumer<String, String> biConsumer, JSONObject jsonObject) {
        Object object = jsonObject.get("buckets_path");
        if (object == null || !(object instanceof JSONObject)) {
            return;
        }
        JSONObject bucketsPathJSONObject = (JSONObject)object;
        for (String key : bucketsPathJSONObject.keySet()) {
            biConsumer.accept(key, bucketsPathJSONObject.getString(key));
        }
    }

    private void _addOrders(Consumer<Order[]> consumer, JSONObject jsonObject) {
        JSONObject orderJSONObject = jsonObject.getJSONObject("order");
        if (orderJSONObject == null) {
            return;
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        for (String key : orderJSONObject.keySet()) {
            Order order = null;
            boolean ascending = StringUtil.equalsIgnoreCase((String)orderJSONObject.getString(key), (String)"asc");
            if ("_count".equals(key)) {
                order = Order.count((boolean)ascending);
            } else if ("_key".equals(key)) {
                order = Order.key((boolean)ascending);
            } else {
                order = new Order(key);
                order.setAscending(ascending);
            }
            orders.add(order);
        }
        consumer.accept(orders.toArray(new Order[0]));
    }

    private void _addRange(Consumer<Range> consumer, JSONObject jsonObject) {
        JSONArray rangesJSONArray = jsonObject.getJSONArray("ranges");
        if (rangesJSONArray == null) {
            return;
        }
        for (int i = 0; i < rangesJSONArray.length(); ++i) {
            JSONObject rangeJSONObject = rangesJSONArray.getJSONObject(i);
            String key = rangeJSONObject.getString("key");
            if (Validator.isNotNull((String)key)) {
                consumer.accept(new Range(key, rangeJSONObject.getString("from", null), rangeJSONObject.getString("to", null)));
                continue;
            }
            consumer.accept(new Range(rangeJSONObject.getString("from", null), rangeJSONObject.getString("to", null)));
        }
    }

    private SignificanceHeuristic _getSignificanceHeuristics(JSONObject jsonObject) {
        JSONObject chiSquareJSONObject = jsonObject.getJSONObject("chi_square");
        if (chiSquareJSONObject != null) {
            return this._significanceHeuristics.chiSquare(chiSquareJSONObject.getBoolean("background_is_superset", true), chiSquareJSONObject.getBoolean("include_negatives", true));
        }
        JSONObject gndJSONObject = jsonObject.getJSONObject("gnd");
        if (gndJSONObject != null) {
            return this._significanceHeuristics.gnd(gndJSONObject.getBoolean("background_is_superset", true));
        }
        if (jsonObject.has("jlh")) {
            return this._significanceHeuristics.jlhScore();
        }
        JSONObject mutualInformationJSONObject = jsonObject.getJSONObject("mutual_information");
        if (mutualInformationJSONObject != null) {
            return this._significanceHeuristics.mutualInformation(mutualInformationJSONObject.getBoolean("background_is_superset", true), mutualInformationJSONObject.getBoolean("include_negatives", true));
        }
        if (jsonObject.has("percentage")) {
            return this._significanceHeuristics.percentageScore();
        }
        JSONObject scriptHeuristicJSONObject = jsonObject.getJSONObject("script_heuristic");
        if (scriptHeuristicJSONObject != null) {
            Script script = this._scriptConverter.toScript(scriptHeuristicJSONObject);
            return this._significanceHeuristics.script(script);
        }
        return null;
    }

    private void _setBackgroundFilterQuery(Consumer<Query> consumer, JSONObject jsonObject) {
        JSONObject backgroundFilterJSONObject = jsonObject.getJSONObject("background_filter");
        if (backgroundFilterJSONObject == null) {
            return;
        }
        Query query = this._queryConverter.toQuery(backgroundFilterJSONObject);
        if (query == null) {
            return;
        }
        consumer.accept(query);
    }

    private void _setBoolean(Consumer<Boolean> consumer, JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return;
        }
        consumer.accept(jsonObject.getBoolean(key));
    }

    private void _setDouble(Consumer<Double> consumer, JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return;
        }
        consumer.accept(jsonObject.getDouble(key));
    }

    private void _setGapPolicy(Consumer<GapPolicy> consumer, JSONObject jsonObject) {
        String gapPolicy = jsonObject.getString("gap_policy");
        if (Validator.isNull((String)gapPolicy)) {
            return;
        }
        consumer.accept(GapPolicy.valueOf((String)StringUtil.toUpperCase((String)gapPolicy)));
    }

    private void _setIncludeExcludeClause(Consumer<IncludeExcludeClause> consumer, JSONObject jsonObject) {
        Object excludeObject = jsonObject.get("exclude");
        Object includeObject = jsonObject.get("include");
        if (excludeObject == null && includeObject == null) {
            return;
        }
        String[] excludedValues = null;
        String excludeRegex = null;
        String[] includedValues = null;
        String includeRegex = null;
        if (excludeObject != null) {
            if (excludeObject instanceof JSONArray) {
                excludedValues = JSONUtil.toStringArray((JSONArray)((JSONArray)excludeObject));
            } else {
                excludeRegex = GetterUtil.getString((Object)excludeObject);
            }
        }
        if (includeObject != null) {
            if (includeObject instanceof JSONArray) {
                includedValues = JSONUtil.toStringArray((JSONArray)((JSONArray)includeObject));
            } else {
                includeRegex = GetterUtil.getString((Object)includeObject);
            }
        }
        final String[] finalExcludedValues = excludedValues;
        final String finalExcludeRegex = excludeRegex;
        final String[] finalIncludedValues = includedValues;
        final String finalIncludeRegex = includeRegex;
        consumer.accept(new IncludeExcludeClause(){

            public String[] getExcludedValues() {
                return finalExcludedValues;
            }

            public String getExcludeRegex() {
                return finalExcludeRegex;
            }

            public String[] getIncludedValues() {
                return finalIncludedValues;
            }

            public String getIncludeRegex() {
                return finalIncludeRegex;
            }
        });
    }

    private void _setInteger(Consumer<Integer> consumer, JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return;
        }
        consumer.accept(jsonObject.getInt(key));
    }

    private void _setLong(Consumer<Long> consumer, JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return;
        }
        consumer.accept(jsonObject.getLong(key));
    }

    private void _setObject(Consumer<Object> consumer, JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return;
        }
        consumer.accept(jsonObject.get(key));
    }

    private void _setScript(Consumer<Script> consumer, JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return;
        }
        consumer.accept(this._scriptConverter.toScript(jsonObject.get(key)));
    }

    private void _setSignificanceHeuristics(Consumer<SignificanceHeuristic> consumer, JSONObject jsonObject) {
        SignificanceHeuristic significanceHeuristic = this._getSignificanceHeuristics(jsonObject);
        if (significanceHeuristic == null) {
            return;
        }
        consumer.accept(significanceHeuristic);
    }

    private void _setString(Consumer<String> consumer, JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return;
        }
        consumer.accept(jsonObject.getString(key));
    }

    private AvgAggregation _toAvgAggregation(JSONObject jsonObject, String name) {
        AvgAggregation avgAggregation = this._aggregations.avg(name, jsonObject.getString("field"));
        this._setObject(arg_0 -> ((AvgAggregation)avgAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((AvgAggregation)avgAggregation).setScript(arg_0), jsonObject, "script");
        return avgAggregation;
    }

    private AvgBucketPipelineAggregation _toAvgBucketPipelineAggregation(JSONObject jsonObject, String name) {
        AvgBucketPipelineAggregation avgBucketPipelineAggregation = this._aggregations.avgBucket(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((AvgBucketPipelineAggregation)avgBucketPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((AvgBucketPipelineAggregation)avgBucketPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return avgBucketPipelineAggregation;
    }

    private BucketScriptPipelineAggregation _toBucketScriptPipelineAggregation(JSONObject jsonObject, String name) {
        BucketScriptPipelineAggregation bucketScriptPipelineAggregation = this._aggregations.bucketScript(name, this._scriptConverter.toScript(jsonObject.get("script")));
        this._addBucketsPaths((arg_0, arg_1) -> ((BucketScriptPipelineAggregation)bucketScriptPipelineAggregation).addBucketPath(arg_0, arg_1), jsonObject);
        this._setString(arg_0 -> ((BucketScriptPipelineAggregation)bucketScriptPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        return bucketScriptPipelineAggregation;
    }

    private BucketSelectorPipelineAggregation _toBucketSelectorPipelineAggregation(JSONObject jsonObject, String name) {
        BucketSelectorPipelineAggregation bucketSelectorPipelineAggregation = this._aggregations.bucketSelector(name, this._scriptConverter.toScript(jsonObject.get("script")));
        this._addBucketsPaths((arg_0, arg_1) -> ((BucketSelectorPipelineAggregation)bucketSelectorPipelineAggregation).addBucketPath(arg_0, arg_1), jsonObject);
        this._setGapPolicy(arg_0 -> ((BucketSelectorPipelineAggregation)bucketSelectorPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return bucketSelectorPipelineAggregation;
    }

    private BucketSortPipelineAggregation _toBucketSortPipelineAggregation(JSONObject jsonObject, String name) {
        BucketSortPipelineAggregation bucketSortPipelineAggregation = this._aggregations.bucketSort(name);
        if (jsonObject.has("sort")) {
            JSONArray sortJSONArray = jsonObject.getJSONArray("sort");
            ArrayList<FieldSort> fieldSorts = new ArrayList<FieldSort>();
            for (int i = 0; i < sortJSONArray.length(); ++i) {
                Iterator iterator;
                String field;
                JSONObject sortJSONObject = sortJSONArray.getJSONObject(i);
                JSONObject fieldJSONObject = sortJSONObject.getJSONObject(field = (String)(iterator = sortJSONObject.keys()).next());
                if (fieldJSONObject.has("order")) {
                    fieldSorts.add(this._sorts.field(field, SortOrder.valueOf((String)StringUtil.toUpperCase((String)fieldJSONObject.getString("order")))));
                    continue;
                }
                fieldSorts.add(this._sorts.field(field));
            }
            bucketSortPipelineAggregation.addSortFields(fieldSorts.toArray(new FieldSort[0]));
        }
        this._setInteger(arg_0 -> ((BucketSortPipelineAggregation)bucketSortPipelineAggregation).setFrom(arg_0), jsonObject, "from");
        this._setGapPolicy(arg_0 -> ((BucketSortPipelineAggregation)bucketSortPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        this._setInteger(arg_0 -> ((BucketSortPipelineAggregation)bucketSortPipelineAggregation).setSize(arg_0), jsonObject, "size");
        return bucketSortPipelineAggregation;
    }

    private CardinalityAggregation _toCardinalityAggregation(JSONObject jsonObject, String name) {
        CardinalityAggregation cardinalityAggregation = this._aggregations.cardinality(name, jsonObject.getString("field"));
        this._setObject(arg_0 -> ((CardinalityAggregation)cardinalityAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setInteger(arg_0 -> ((CardinalityAggregation)cardinalityAggregation).setPrecisionThreshold(arg_0), jsonObject, "precision_threshold");
        this._setScript(arg_0 -> ((CardinalityAggregation)cardinalityAggregation).setScript(arg_0), jsonObject, "script");
        return cardinalityAggregation;
    }

    private CumulativeSumPipelineAggregation _toCumulativeSumPipelineAggregation(JSONObject jsonObject, String name) {
        CumulativeSumPipelineAggregation cumulativeSumPipelineAggregation = this._aggregations.cumulativeSum(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((CumulativeSumPipelineAggregation)cumulativeSumPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        return cumulativeSumPipelineAggregation;
    }

    private DateHistogramAggregation _toDateHistogramAggregation(JSONObject jsonObject, String name) {
        DateHistogramAggregation dateHistogramAggregation = this._aggregations.dateHistogram(name, jsonObject.getString("field"));
        this._addOrders(arg_0 -> ((DateHistogramAggregation)dateHistogramAggregation).addOrders(arg_0), jsonObject);
        this._setString(arg_0 -> ((DateHistogramAggregation)dateHistogramAggregation).setDateHistogramInterval(arg_0), jsonObject, "date_histogram_interval");
        JSONObject extendedBoundsJSONObject = jsonObject.getJSONObject("extended_bounds");
        if (extendedBoundsJSONObject != null) {
            dateHistogramAggregation.setBounds(Long.valueOf(extendedBoundsJSONObject.getLong("min")), Long.valueOf(extendedBoundsJSONObject.getLong("max")));
        } else {
            JSONObject hardBoundsJSONObject = jsonObject.getJSONObject("hard_bounds");
            if (hardBoundsJSONObject != null) {
                dateHistogramAggregation.setBounds(Long.valueOf(hardBoundsJSONObject.getLong("min")), Long.valueOf(hardBoundsJSONObject.getLong("max")));
            }
        }
        this._setBoolean(arg_0 -> ((DateHistogramAggregation)dateHistogramAggregation).setKeyed(arg_0), jsonObject, "keyed");
        this._setLong(arg_0 -> ((DateHistogramAggregation)dateHistogramAggregation).setMinDocCount(arg_0), jsonObject, "min_doc_count");
        this._setString(arg_0 -> ((DateHistogramAggregation)dateHistogramAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setLong(arg_0 -> ((DateHistogramAggregation)dateHistogramAggregation).setOffset(arg_0), jsonObject, "offset");
        this._setScript(arg_0 -> ((DateHistogramAggregation)dateHistogramAggregation).setScript(arg_0), jsonObject, "script");
        return dateHistogramAggregation;
    }

    private DateRangeAggregation _toDateRangeAggregation(JSONObject jsonObject, String name) {
        DateRangeAggregation dateRangeAggregation = this._aggregations.dateRange(name, jsonObject.getString("field"));
        this._addRange(arg_0 -> ((DateRangeAggregation)dateRangeAggregation).addRange(arg_0), jsonObject);
        this._setString(arg_0 -> ((DateRangeAggregation)dateRangeAggregation).setFormat(arg_0), jsonObject, "format");
        this._setBoolean(arg_0 -> ((DateRangeAggregation)dateRangeAggregation).setKeyed(arg_0), jsonObject, "keyed");
        this._setString(arg_0 -> ((DateRangeAggregation)dateRangeAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((DateRangeAggregation)dateRangeAggregation).setScript(arg_0), jsonObject, "script");
        return dateRangeAggregation;
    }

    private DerivativePipelineAggregation _toDerivativePipelineAggregation(JSONObject jsonObject, String name) {
        DerivativePipelineAggregation derivativePipelineAggregation = this._aggregations.derivative(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((DerivativePipelineAggregation)derivativePipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((DerivativePipelineAggregation)derivativePipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return derivativePipelineAggregation;
    }

    private DiversifiedSamplerAggregation _toDiversifiedSamplerAggregation(JSONObject jsonObject, String name) {
        DiversifiedSamplerAggregation diversifiedSamplerAggregation = this._aggregations.diversifiedSampler(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((DiversifiedSamplerAggregation)diversifiedSamplerAggregation).setExecutionHint(arg_0), jsonObject, "execution_hint");
        this._setInteger(arg_0 -> ((DiversifiedSamplerAggregation)diversifiedSamplerAggregation).setMaxDocsPerValue(arg_0), jsonObject, "max_docs_per_value");
        this._setString(arg_0 -> ((DiversifiedSamplerAggregation)diversifiedSamplerAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((DiversifiedSamplerAggregation)diversifiedSamplerAggregation).setScript(arg_0), jsonObject, "script");
        this._setInteger(arg_0 -> ((DiversifiedSamplerAggregation)diversifiedSamplerAggregation).setShardSize(arg_0), jsonObject, "shard_size");
        return diversifiedSamplerAggregation;
    }

    private double[] _toDoubleArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        return JSONUtil.toDoubleArray((JSONArray)jsonArray);
    }

    private ExtendedStatsAggregation _toExtendedStatsAggregation(JSONObject jsonObject, String name) {
        ExtendedStatsAggregation extendedStatsAggregation = this._aggregations.extendedStats(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((ExtendedStatsAggregation)extendedStatsAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((ExtendedStatsAggregation)extendedStatsAggregation).setScript(arg_0), jsonObject, "script");
        this._setInteger(arg_0 -> ((ExtendedStatsAggregation)extendedStatsAggregation).setSigma(arg_0), jsonObject, "sigma");
        return extendedStatsAggregation;
    }

    private ExtendedStatsBucketPipelineAggregation _toExtendedStatsBucketPipelineAggregation(JSONObject jsonObject, String name) {
        ExtendedStatsBucketPipelineAggregation extendedStatsBucketPipelineAggregation = this._aggregations.extendedStatsBucket(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((ExtendedStatsBucketPipelineAggregation)extendedStatsBucketPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((ExtendedStatsBucketPipelineAggregation)extendedStatsBucketPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        this._setDouble(arg_0 -> ((ExtendedStatsBucketPipelineAggregation)extendedStatsBucketPipelineAggregation).setSigma(arg_0), jsonObject, "sigma");
        return extendedStatsBucketPipelineAggregation;
    }

    private FilterAggregation _toFilterAggregation(JSONObject jsonObject, String name) {
        Query query = this._queryConverter.toQuery(jsonObject);
        if (query == null) {
            return null;
        }
        return this._aggregations.filter(name, query);
    }

    private FiltersAggregation _toFiltersAggregation(JSONObject jsonObject, String name) {
        FiltersAggregation filtersAggregation = this._aggregations.filters(name, jsonObject.getString("field"));
        JSONObject filtersJSONObject = jsonObject.getJSONObject("filters");
        if (filtersJSONObject != null) {
            for (String key : filtersJSONObject.keySet()) {
                Query query = this._queryConverter.toQuery(filtersJSONObject.getJSONObject(key));
                if (query == null) continue;
                filtersAggregation.addKeyedQuery(key, query);
            }
        }
        this._setBoolean(arg_0 -> ((FiltersAggregation)filtersAggregation).setOtherBucket(arg_0), jsonObject, "other_bucket");
        this._setString(arg_0 -> ((FiltersAggregation)filtersAggregation).setOtherBucketKey(arg_0), jsonObject, "other_bucket_key");
        return filtersAggregation;
    }

    private GeoBoundsAggregation _toGeoBoundsAggregation(JSONObject jsonObject, String name) {
        GeoBoundsAggregation geoBoundsAggregation = this._aggregations.geoBounds(name, jsonObject.getString("field"));
        this._setBoolean(arg_0 -> ((GeoBoundsAggregation)geoBoundsAggregation).setWrapLongitude(arg_0), jsonObject, "wrap_longitude");
        return geoBoundsAggregation;
    }

    private GeoCentroidAggregation _toGeoCentroidAggregation(JSONObject jsonObject, String name) {
        return this._aggregations.geoCentroid(name, jsonObject.getString("field"));
    }

    private GeoDistanceAggregation _toGeoDistanceAggregation(JSONObject jsonObject, String name) {
        String[] coordinates = StringUtil.split((String)jsonObject.getString("origin"));
        if (coordinates.length != 2) {
            return null;
        }
        GeoDistanceAggregation geoDistanceAggregation = this._aggregations.geoDistance(name, jsonObject.getString("field"), this._geoBuilders.geoLocationPoint(GetterUtil.getDouble((String)coordinates[0]), GetterUtil.getDouble((String)coordinates[1])));
        this._addRange(arg_0 -> ((GeoDistanceAggregation)geoDistanceAggregation).addRange(arg_0), jsonObject);
        geoDistanceAggregation.setDistanceUnit(DistanceUnit.create((String)jsonObject.getString("unit")));
        String distanceType = jsonObject.getString("distance_type");
        if (Validator.isNotNull((String)distanceType)) {
            geoDistanceAggregation.setGeoDistanceType(GeoDistanceType.valueOf((String)StringUtil.toUpperCase((String)distanceType)));
        }
        this._setBoolean(arg_0 -> ((GeoDistanceAggregation)geoDistanceAggregation).setKeyed(arg_0), jsonObject, "keyed");
        this._setScript(arg_0 -> ((GeoDistanceAggregation)geoDistanceAggregation).setScript(arg_0), jsonObject, "script");
        return geoDistanceAggregation;
    }

    private GeoHashGridAggregation _toGeoHashGridAggregation(JSONObject jsonObject, String name) {
        GeoHashGridAggregation geoHashGridAggregation = this._aggregations.geoHashGrid(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((GeoHashGridAggregation)geoHashGridAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setInteger(arg_0 -> ((GeoHashGridAggregation)geoHashGridAggregation).setPrecision(arg_0), jsonObject, "precision");
        this._setScript(arg_0 -> ((GeoHashGridAggregation)geoHashGridAggregation).setScript(arg_0), jsonObject, "script");
        this._setInteger(arg_0 -> ((GeoHashGridAggregation)geoHashGridAggregation).setShardSize(arg_0), jsonObject, "shard_size");
        this._setInteger(arg_0 -> ((GeoHashGridAggregation)geoHashGridAggregation).setSize(arg_0), jsonObject, "size");
        return geoHashGridAggregation;
    }

    private GlobalAggregation _toGlobalAggregation(JSONObject jsonObject, String name) {
        return this._aggregations.global(name);
    }

    private HistogramAggregation _toHistogramAggregation(JSONObject jsonObject, String name) {
        HistogramAggregation histogramAggregation = this._aggregations.histogram(name, jsonObject.getString("field"));
        this._addOrders(arg_0 -> ((HistogramAggregation)histogramAggregation).addOrders(arg_0), jsonObject);
        JSONObject extendedBoundsJSONObject = jsonObject.getJSONObject("extended_bounds");
        if (extendedBoundsJSONObject != null) {
            histogramAggregation.setBounds(Double.valueOf(extendedBoundsJSONObject.getDouble("min")), Double.valueOf(extendedBoundsJSONObject.getDouble("max")));
        } else {
            JSONObject hardBoundsJSONObject = jsonObject.getJSONObject("hard_bounds");
            if (hardBoundsJSONObject != null) {
                histogramAggregation.setBounds(Double.valueOf(hardBoundsJSONObject.getDouble("min")), Double.valueOf(hardBoundsJSONObject.getDouble("max")));
            }
        }
        this._setDouble(arg_0 -> ((HistogramAggregation)histogramAggregation).setInterval(arg_0), jsonObject, "interval");
        this._setBoolean(arg_0 -> ((HistogramAggregation)histogramAggregation).setKeyed(arg_0), jsonObject, "keyed");
        this._setLong(arg_0 -> ((HistogramAggregation)histogramAggregation).setMinDocCount(arg_0), jsonObject, "min_doc_count");
        this._setString(arg_0 -> ((HistogramAggregation)histogramAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setDouble(arg_0 -> ((HistogramAggregation)histogramAggregation).setOffset(arg_0), jsonObject, "offset");
        this._setScript(arg_0 -> ((HistogramAggregation)histogramAggregation).setScript(arg_0), jsonObject, "script");
        return histogramAggregation;
    }

    private MaxAggregation _toMaxAggregation(JSONObject jsonObject, String name) {
        MaxAggregation maxAggregation = this._aggregations.max(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((MaxAggregation)maxAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((MaxAggregation)maxAggregation).setScript(arg_0), jsonObject, "script");
        return maxAggregation;
    }

    private MaxBucketPipelineAggregation _toMaxBucketPipelineAggregation(JSONObject jsonObject, String name) {
        MaxBucketPipelineAggregation maxBucketPipelineAggregation = this._aggregations.maxBucket(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((MaxBucketPipelineAggregation)maxBucketPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((MaxBucketPipelineAggregation)maxBucketPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return maxBucketPipelineAggregation;
    }

    private MinAggregation _toMinAggregation(JSONObject jsonObject, String name) {
        MinAggregation minAggregation = this._aggregations.min(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((MinAggregation)minAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((MinAggregation)minAggregation).setScript(arg_0), jsonObject, "script");
        return minAggregation;
    }

    private MinBucketPipelineAggregation _toMinBucketPipelineAggregation(JSONObject jsonObject, String name) {
        MinBucketPipelineAggregation minBucketPipelineAggregation = this._aggregations.minBucket(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((MinBucketPipelineAggregation)minBucketPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((MinBucketPipelineAggregation)minBucketPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return minBucketPipelineAggregation;
    }

    private MissingAggregation _toMissingAggregation(JSONObject jsonObject, String name) {
        MissingAggregation missingAggregation = this._aggregations.missing(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((MissingAggregation)missingAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((MissingAggregation)missingAggregation).setScript(arg_0), jsonObject, "script");
        return missingAggregation;
    }

    private MovingFunctionPipelineAggregation _toMovingFunctionPipelineAggregation(JSONObject jsonObject, String name) {
        MovingFunctionPipelineAggregation movingFunctionPipelineAggregation = this._aggregations.movingFunction(name, this._scriptConverter.toScript(jsonObject.get("script")), jsonObject.getString("buckets_path"), jsonObject.getInt("window"));
        this._setGapPolicy(arg_0 -> ((MovingFunctionPipelineAggregation)movingFunctionPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return movingFunctionPipelineAggregation;
    }

    private NestedAggregation _toNestedAggregation(JSONObject jsonObject, String name) {
        return this._aggregations.nested(name, jsonObject.getString("path"));
    }

    private PercentileRanksAggregation _toPercentileRanksAggregation(JSONObject jsonObject, String name) {
        PercentileRanksAggregation percentileRanksAggregation = this._aggregations.percentileRanks(name, jsonObject.getString("field"), this._toDoubleArray(jsonObject.getJSONArray("values")));
        this._setBoolean(arg_0 -> ((PercentileRanksAggregation)percentileRanksAggregation).setKeyed(arg_0), jsonObject, "keyed");
        this._setString(arg_0 -> ((PercentileRanksAggregation)percentileRanksAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((PercentileRanksAggregation)percentileRanksAggregation).setScript(arg_0), jsonObject, "script");
        JSONObject hdrJSONObject = jsonObject.getJSONObject("hdr");
        JSONObject tDigestJSONObject = jsonObject.getJSONObject("tdigest");
        if (hdrJSONObject != null) {
            percentileRanksAggregation.setHdrSignificantValueDigits(Integer.valueOf(hdrJSONObject.getInt("number_of_significant_value_digits")));
            percentileRanksAggregation.setPercentilesMethod(PercentilesMethod.HDR);
        } else if (tDigestJSONObject != null) {
            percentileRanksAggregation.setCompression(Integer.valueOf(jsonObject.getInt("compression")));
            percentileRanksAggregation.setPercentilesMethod(PercentilesMethod.TDIGEST);
        }
        return percentileRanksAggregation;
    }

    private PercentilesAggregation _toPercentilesAggregation(JSONObject jsonObject, String name) {
        PercentilesAggregation percentilesAggregation = this._aggregations.percentiles(name, jsonObject.getString("field"));
        this._setBoolean(arg_0 -> ((PercentilesAggregation)percentilesAggregation).setKeyed(arg_0), jsonObject, "keyed");
        this._setString(arg_0 -> ((PercentilesAggregation)percentilesAggregation).setMissing(arg_0), jsonObject, "missing");
        percentilesAggregation.setPercents(this._toDoubleArray(jsonObject.getJSONArray("percents")));
        this._setScript(arg_0 -> ((PercentilesAggregation)percentilesAggregation).setScript(arg_0), jsonObject, "script");
        JSONObject hdrJSONObject = jsonObject.getJSONObject("hdr");
        JSONObject tDigestJSONObject = jsonObject.getJSONObject("tdigest");
        if (hdrJSONObject != null) {
            percentilesAggregation.setHdrSignificantValueDigits(Integer.valueOf(hdrJSONObject.getInt("number_of_significant_value_digits")));
            percentilesAggregation.setPercentilesMethod(PercentilesMethod.HDR);
        } else if (tDigestJSONObject != null) {
            percentilesAggregation.setCompression(Integer.valueOf(jsonObject.getInt("compression")));
            percentilesAggregation.setPercentilesMethod(PercentilesMethod.TDIGEST);
        }
        return percentilesAggregation;
    }

    private PercentilesBucketPipelineAggregation _toPercentilesBucketPipelineAggregation(JSONObject jsonObject, String name) {
        PercentilesBucketPipelineAggregation percentilesBucketPipelineAggregation = this._aggregations.percentilesBucket(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((PercentilesBucketPipelineAggregation)percentilesBucketPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((PercentilesBucketPipelineAggregation)percentilesBucketPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        percentilesBucketPipelineAggregation.setPercents(this._toDoubleArray(jsonObject.getJSONArray("percents")));
        return percentilesBucketPipelineAggregation;
    }

    private RangeAggregation _toRangeAggregation(JSONObject jsonObject, String name) {
        RangeAggregation rangeAggregation = this._aggregations.range(name, jsonObject.getString("field"));
        this._addRange(arg_0 -> ((RangeAggregation)rangeAggregation).addRange(arg_0), jsonObject);
        this._setString(arg_0 -> ((RangeAggregation)rangeAggregation).setFormat(arg_0), jsonObject, "format");
        this._setBoolean(arg_0 -> ((RangeAggregation)rangeAggregation).setKeyed(arg_0), jsonObject, "keyed");
        this._setString(arg_0 -> ((RangeAggregation)rangeAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((RangeAggregation)rangeAggregation).setScript(arg_0), jsonObject, "script");
        return rangeAggregation;
    }

    private ReverseNestedAggregation _toReverseNestedAggregation(JSONObject jsonObject, String name) {
        return this._aggregations.reverseNested(name, jsonObject.getString("path"));
    }

    private SamplerAggregation _toSamplerAggregation(JSONObject jsonObject, String name) {
        SamplerAggregation samplerAggregation = this._aggregations.sampler(name);
        this._setInteger(arg_0 -> ((SamplerAggregation)samplerAggregation).setShardSize(arg_0), jsonObject, "shard_size");
        return samplerAggregation;
    }

    private ScriptedMetricAggregation _toScriptedMetricAggregation(JSONObject jsonObject, String name) {
        ScriptedMetricAggregation scriptedMetricAggregation = this._aggregations.scriptedMetric(name);
        this._setScript(arg_0 -> ((ScriptedMetricAggregation)scriptedMetricAggregation).setCombineScript(arg_0), jsonObject, "combine_script");
        this._setScript(arg_0 -> ((ScriptedMetricAggregation)scriptedMetricAggregation).setInitScript(arg_0), jsonObject, "init_script");
        scriptedMetricAggregation.setMapScript(this._scriptConverter.toScript(jsonObject.get("map_script")));
        JSONObject paramsJSONObject = jsonObject.getJSONObject("params");
        if (paramsJSONObject != null) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Iterator iterator = paramsJSONObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                parameters.put(key, paramsJSONObject.get(key));
            }
            scriptedMetricAggregation.setParameters(parameters);
        }
        this._setScript(arg_0 -> ((ScriptedMetricAggregation)scriptedMetricAggregation).setReduceScript(arg_0), jsonObject, "reduce_script");
        return scriptedMetricAggregation;
    }

    private SerialDiffPipelineAggregation _toSerialDiffPipelineAggregation(JSONObject jsonObject, String name) {
        SerialDiffPipelineAggregation serialDiffPipelineAggregation = this._aggregations.serialDiff(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((SerialDiffPipelineAggregation)serialDiffPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((SerialDiffPipelineAggregation)serialDiffPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        this._setInteger(arg_0 -> ((SerialDiffPipelineAggregation)serialDiffPipelineAggregation).setLag(arg_0), jsonObject, "lag");
        return serialDiffPipelineAggregation;
    }

    private SignificantTermsAggregation _toSignificantTermsAggregation(JSONObject jsonObject, String name) {
        SignificantTermsAggregation significantTermsAggregation = this._aggregations.significantTerms(name, jsonObject.getString("field"));
        this._setBackgroundFilterQuery(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setBackgroundFilterQuery(arg_0), jsonObject);
        this._setString(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setExecutionHint(arg_0), jsonObject, "execution_hint");
        this._setIncludeExcludeClause(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setIncludeExcludeClause(arg_0), jsonObject);
        this._setLong(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setMinDocCount(arg_0), jsonObject, "min_doc_count");
        this._setString(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setScript(arg_0), jsonObject, "script");
        this._setLong(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setShardMinDocCount(arg_0), jsonObject, "shard_min_doc_count");
        this._setInteger(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setShardSize(arg_0), jsonObject, "shard_size");
        this._setSignificanceHeuristics(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setSignificanceHeuristic(arg_0), jsonObject);
        this._setInteger(arg_0 -> ((SignificantTermsAggregation)significantTermsAggregation).setSize(arg_0), jsonObject, "size");
        return significantTermsAggregation;
    }

    private SignificantTextAggregation _toSignificantTextAggregation(JSONObject jsonObject, String name) {
        SignificantTextAggregation significantTextAggregation = this._aggregations.significantText(name, jsonObject.getString("field"));
        this._setBackgroundFilterQuery(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setBackgroundFilterQuery(arg_0), jsonObject);
        this._setString(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setExecutionHint(arg_0), jsonObject, "execution_hint");
        this._setBoolean(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setFilterDuplicateText(arg_0), jsonObject, "filter_duplicate_text");
        this._setIncludeExcludeClause(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setIncludeExcludeClause(arg_0), jsonObject);
        this._setLong(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setMinDocCount(arg_0), jsonObject, "min_doc_count");
        this._setString(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setScript(arg_0), jsonObject, "script");
        this._setLong(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setShardMinDocCount(arg_0), jsonObject, "shard_min_doc_count");
        this._setInteger(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setShardSize(arg_0), jsonObject, "shard_size");
        this._setSignificanceHeuristics(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setSignificanceHeuristic(arg_0), jsonObject);
        this._setInteger(arg_0 -> ((SignificantTextAggregation)significantTextAggregation).setSize(arg_0), jsonObject, "size");
        return significantTextAggregation;
    }

    private StatsAggregation _toStatsAggregation(JSONObject jsonObject, String name) {
        StatsAggregation statsAggregation = this._aggregations.stats(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((StatsAggregation)statsAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((StatsAggregation)statsAggregation).setScript(arg_0), jsonObject, "script");
        return statsAggregation;
    }

    private StatsBucketPipelineAggregation _toStatsBucketPipelineAggregation(JSONObject jsonObject, String name) {
        StatsBucketPipelineAggregation statsBucketPipelineAggregation = this._aggregations.statsBucket(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((StatsBucketPipelineAggregation)statsBucketPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((StatsBucketPipelineAggregation)statsBucketPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return statsBucketPipelineAggregation;
    }

    private String[] _toStringArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        return JSONUtil.toStringArray((JSONArray)jsonArray);
    }

    private List<String> _toStringList(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        return JSONUtil.toStringList((JSONArray)jsonArray);
    }

    private SumAggregation _toSumAggregation(JSONObject jsonObject, String name) {
        SumAggregation sumAggregation = this._aggregations.sum(name, jsonObject.getString("field"));
        this._setString(arg_0 -> ((SumAggregation)sumAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setScript(arg_0 -> ((SumAggregation)sumAggregation).setScript(arg_0), jsonObject, "script");
        return sumAggregation;
    }

    private SumBucketPipelineAggregation _toSumBucketPipelineAggregation(JSONObject jsonObject, String name) {
        SumBucketPipelineAggregation sumBucketPipelineAggregation = this._aggregations.sumBucket(name, jsonObject.getString("buckets_path"));
        this._setString(arg_0 -> ((SumBucketPipelineAggregation)sumBucketPipelineAggregation).setFormat(arg_0), jsonObject, "format");
        this._setGapPolicy(arg_0 -> ((SumBucketPipelineAggregation)sumBucketPipelineAggregation).setGapPolicy(arg_0), jsonObject);
        return sumBucketPipelineAggregation;
    }

    private TermsAggregation _toTermsAggregation(JSONObject jsonObject, String name) {
        TermsAggregation termsAggregation = this._aggregations.terms(name, jsonObject.getString("field"));
        this._addOrders(arg_0 -> ((TermsAggregation)termsAggregation).addOrders(arg_0), jsonObject);
        String collectMode = jsonObject.getString("collect_mode");
        if (Validator.isNotNull((String)collectMode)) {
            termsAggregation.setCollectionMode(CollectionMode.valueOf((String)StringUtil.toUpperCase((String)collectMode)));
        }
        this._setString(arg_0 -> ((TermsAggregation)termsAggregation).setExecutionHint(arg_0), jsonObject, "execution_hint");
        this._setIncludeExcludeClause(arg_0 -> ((TermsAggregation)termsAggregation).setIncludeExcludeClause(arg_0), jsonObject);
        this._setInteger(arg_0 -> ((TermsAggregation)termsAggregation).setMinDocCount(arg_0), jsonObject, "min_doc_count");
        this._setString(arg_0 -> ((TermsAggregation)termsAggregation).setMissing(arg_0), jsonObject, "missing");
        this._setInteger(arg_0 -> ((TermsAggregation)termsAggregation).setShardMinDocCount(arg_0), jsonObject, "shard_min_doc_count");
        this._setInteger(arg_0 -> ((TermsAggregation)termsAggregation).setShardSize(arg_0), jsonObject, "shard_size");
        this._setBoolean(arg_0 -> ((TermsAggregation)termsAggregation).setShowTermDocCountError(arg_0), jsonObject, "show_term_doc_count_error");
        this._setScript(arg_0 -> ((TermsAggregation)termsAggregation).setScript(arg_0), jsonObject, "script");
        this._setInteger(arg_0 -> ((TermsAggregation)termsAggregation).setSize(arg_0), jsonObject, "size");
        return termsAggregation;
    }

    private TopHitsAggregation _toTopHitsAggregation(JSONObject jsonObject, String name) {
        TopHitsAggregation topHitsAggregation = this._aggregations.topHits(name);
        this._setBoolean(arg_0 -> ((TopHitsAggregation)topHitsAggregation).setExplain(arg_0), jsonObject, "explain");
        Object object = jsonObject.get("_source");
        if (object != null) {
            if (object instanceof JSONObject) {
                JSONObject sourceJSONObject = (JSONObject)object;
                topHitsAggregation.setFetchSourceIncludeExclude(this._toStringArray(sourceJSONObject.getJSONArray("includes")), this._toStringArray(sourceJSONObject.getJSONArray("excludes")));
            } else {
                topHitsAggregation.setFetchSource(Boolean.valueOf(GetterUtil.getBoolean((Object)object)));
            }
        }
        this._setInteger(arg_0 -> ((TopHitsAggregation)topHitsAggregation).setFrom(arg_0), jsonObject, "from");
        topHitsAggregation.setHighlight(this._highlightConverter.toHighlight(jsonObject.getJSONObject("highlight")));
        JSONArray scriptFieldsJSONArray = jsonObject.getJSONArray("script_fields");
        if (scriptFieldsJSONArray != null) {
            ArrayList<ScriptField> scriptFields = new ArrayList<ScriptField>();
            for (int i = 0; i < scriptFieldsJSONArray.length(); ++i) {
                Iterator iterator;
                JSONObject scriptFieldJSONObject = scriptFieldsJSONArray.getJSONObject(i);
                Script script = this._scriptConverter.toScript(scriptFieldJSONObject.get((String)(iterator = scriptFieldJSONObject.keys()).next()));
                if (script == null) continue;
                ScriptFieldBuilder scriptFieldBuilder = this._scripts.fieldBuilder();
                scriptFieldBuilder.script(script);
                scriptFields.add(scriptFieldBuilder.build());
            }
            topHitsAggregation.setScriptFields(scriptFields);
        }
        topHitsAggregation.setSelectedFields(this._toStringList(jsonObject.getJSONArray("docvalue_fields")));
        this._setInteger(arg_0 -> ((TopHitsAggregation)topHitsAggregation).setSize(arg_0), jsonObject, "size");
        this._setBoolean(arg_0 -> ((TopHitsAggregation)topHitsAggregation).setTrackScores(arg_0), jsonObject, "track_scores");
        this._setBoolean(arg_0 -> ((TopHitsAggregation)topHitsAggregation).setVersion(arg_0), jsonObject, "version");
        return topHitsAggregation;
    }

    private ValueCountAggregation _toValueCountAggregation(JSONObject jsonObject, String name) {
        ValueCountAggregation valueCountAggregation = this._aggregations.valueCount(name, jsonObject.getString("field"));
        this._setScript(arg_0 -> ((ValueCountAggregation)valueCountAggregation).setScript(arg_0), jsonObject, "script");
        return valueCountAggregation;
    }

    private WeightedAvgAggregation _toWeightedAvgAggregation(JSONObject jsonObject, String name) {
        JSONObject valueJSONObject = jsonObject.getJSONObject("value");
        JSONObject weightJSONObject = jsonObject.getJSONObject("weight");
        WeightedAvgAggregation weightedAvgAggregation = this._aggregations.weightedAvg(name, valueJSONObject.getString("field"), weightJSONObject.getString("field"));
        this._setString(arg_0 -> ((WeightedAvgAggregation)weightedAvgAggregation).setFormat(arg_0), jsonObject, "format");
        this._setObject(arg_0 -> ((WeightedAvgAggregation)weightedAvgAggregation).setValueMissing(arg_0), valueJSONObject, "missing");
        if (valueJSONObject.get("script") != null) {
            weightedAvgAggregation.setValueScript(this._scriptConverter.toScript(valueJSONObject.get("script")));
        }
        this._setObject(arg_0 -> ((WeightedAvgAggregation)weightedAvgAggregation).setWeightMissing(arg_0), weightJSONObject, "missing");
        if (weightJSONObject.get("script") != null) {
            weightedAvgAggregation.setWeightScript(this._scriptConverter.toScript(weightJSONObject.get("script")));
        }
        return weightedAvgAggregation;
    }

    @FunctionalInterface
    public static interface ConvertFunction {
        public Object apply(JSONObject var1, String var2) throws Exception;
    }
}

