/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saved.content.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.saved.content.model.SavedContentEntry;
import com.liferay.saved.content.service.base.SavedContentEntryServiceBaseImpl;
import com.liferay.saved.content.util.comparator.SavedContentEntryClassNameIdComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=savedcontententry", "json.web.service.context.path=SavedContentEntry"}, service={AopService.class})
public class SavedContentEntryServiceImpl
extends SavedContentEntryServiceBaseImpl {
    @Reference(target="(resource.name=com.liferay.saved.content)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.saved.content.model.SavedContentEntry)")
    private volatile ModelResourcePermission<SavedContentEntry> _savedContentEntryModelResourcePermission;

    public SavedContentEntry addSavedContentEntry(long groupId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_ENTRY");
        return this.savedContentEntryLocalService.addSavedContentEntry(this.getUserId(), groupId, className, classPK, serviceContext);
    }

    public void deleteSavedContentEntry(SavedContentEntry savedContentEntry) throws PortalException {
        this._savedContentEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)savedContentEntry, "DELETE");
        this.savedContentEntryLocalService.deleteSavedContentEntry(savedContentEntry);
    }

    public SavedContentEntry fetchSavedContentEntry(long groupId, String className, long classPK) throws PortalException {
        SavedContentEntry savedContentEntry = this.savedContentEntryLocalService.fetchSavedContentEntry(this.getUserId(), groupId, className, classPK);
        if (savedContentEntry != null) {
            this._savedContentEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)savedContentEntry, "VIEW");
        }
        return savedContentEntry;
    }

    public List<SavedContentEntry> getGroupUserSavedContentEntries(long groupId, int start, int end) throws PortalException {
        return this.savedContentEntryPersistence.findByG_U(groupId, this.getUserId(), start, end, (OrderByComparator)new SavedContentEntryClassNameIdComparator());
    }

    public List<SavedContentEntry> getGroupUserSavedContentEntries(long groupId, int start, int end, OrderByComparator<SavedContentEntry> orderByComparator) throws PortalException {
        return this.savedContentEntryPersistence.findByG_U(groupId, this.getUserId(), start, end, orderByComparator);
    }

    public int getGroupUserSavedContentEntriesCount(long groupId) throws PortalException {
        return this.savedContentEntryPersistence.filterCountByG_U(groupId, this.getUserId());
    }

    public SavedContentEntry getSavedContentEntry(long groupId, String className, long classPK) throws PortalException {
        SavedContentEntry savedContentEntry = this.savedContentEntryLocalService.getSavedContentEntry(this.getUserId(), groupId, className, classPK);
        this._savedContentEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)savedContentEntry, "VIEW");
        return savedContentEntry;
    }
}

