/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.internal.upgrade.v3_0_0;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.saml.persistence.internal.upgrade.v3_0_0.util.SamlSpSessionTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SamlSpSessionUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("SamlSpSession", "samlPeerBindingId")) {
                this.alter(SamlSpSessionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "samlPeerBindingId", "LONG null")});
            }
            int samlSpSessionIdOffset = 0;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select min(samlSpSessionId) - 1 from SamlSpSession");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    samlSpSessionIdOffset = resultSet.getInt(1);
                }
            }
            int latestSamlPeerBindingId = this._getLatestSamlPeerBindingId();
            this.runSQL(StringBundler.concat((Object[])new Object[]{"insert into SamlPeerBinding (samlPeerBindingId, ", "companyId, createDate, userId, userName, deleted, ", "samlNameIdFormat, samlNameIdNameQualifier, ", "samlNameIdSpNameQualifier, samlNameIdSpProvidedId, ", "samlNameIdValue, samlPeerEntityId) select ", "min(samlSpSessionId) + ", -samlSpSessionIdOffset + latestSamlPeerBindingId, ", companyId, min(createDate), userId, userName, '0' as ", "deleted, nameIdFormat, nameIdNameQualifier, null as ", "samlNameIdSpNameQualifier, null as nameIdSpProvidedId, ", "nameIdValue, samlIdpEntityId from SamlSpSession group by ", "companyId, userId, userName, nameIdFormat, ", "nameIdNameQualifier, nameIdSPNameQualifier, nameIdValue, ", "samlIdpEntityId"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update SamlSpSession set samlPeerBindingId = (", "select samlPeerBindingId from SamlPeerBinding where ", "SamlSpSession.companyId = SamlPeerBinding.companyId and ", "SamlSpSession.userId = SamlPeerBinding.userId and ", "SamlSpSession.samlIdpEntityId = ", "SamlPeerBinding.samlPeerEntityId and ", "SamlSpSession.nameIdFormat = ", "SamlPeerBinding.samlNameIdFormat and ", "SamlSpSession.nameIdNameQualifier = ", "SamlPeerBinding.samlNameIdNameQualifier and ", "SamlSpSession.nameIdValue = ", "SamlPeerBinding.samlNameIdValue)"}));
            CounterLocalServiceUtil.reset((String)"com.liferay.saml.persistence.model.SamlPeerBinding", (long)(this._getLatestSamlPeerBindingId() + 1));
        }
    }

    private int _getLatestSamlPeerBindingId() throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select max(samlPeerBindingId) from SamlPeerBinding");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }
}

