/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.internal.upgrade.v3_0_0;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.saml.persistence.internal.upgrade.v3_0_0.util.SamlIdpSpSessionTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SamlIdpSpSessionUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("SamlIdpSpSession", "samlPeerBindingId")) {
                this.alter(SamlIdpSpSessionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "samlPeerBindingId", "LONG null")});
            }
            int samlIdpSpSessionIdOffset = 0;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select min(samlIdpSpSessionId) - 1 from SamlIdpSpSession");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    samlIdpSpSessionIdOffset = resultSet.getInt(1);
                }
            }
            int latestSamlPeerBindingId = this._getLatestSamlPeerBindingId();
            this.runSQL(StringBundler.concat((Object[])new Object[]{"insert into SamlPeerBinding (samlPeerBindingId, ", "companyId, createDate, userId, userName, deleted, ", "samlNameIdFormat, samlNameIdNameQualifier, ", "samlNameIdSpNameQualifier, samlNameIdSpProvidedId, ", "samlNameIdValue, samlPeerEntityId) select ", "min(samlIdpSpSessionId) + ", -samlIdpSpSessionIdOffset + latestSamlPeerBindingId, ", companyId, min(createDate), userId, userName, '0' as ", "deleted, nameIdFormat, null as nameIdNameQualifier, null ", "as samlNameIdSpNameQualifier, null as ", "nameIdSpProvidedId, nameIdValue, samlSpEntityId from ", "SamlIdpSpSession group by companyId, userId, userName, ", "samlSpEntityId, nameIdFormat, nameIdValue"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"update SamlIdpSpSession set samlPeerBindingId = (", "select samlPeerBindingId from SamlPeerBinding where ", "SamlIdpSpSession.companyId = SamlPeerBinding.companyId ", "and SamlIdpSpSession.userId = SamlPeerBinding.userId and ", "SamlIdpSpSession.samlSpEntityId = ", "SamlPeerBinding.samlPeerEntityId and ", "SamlIdpSpSession.nameIdFormat = ", "SamlPeerBinding.samlNameIdFormat and ", "SamlIdpSpSession.nameIdValue = ", "SamlPeerBinding.samlNameIdValue)"}));
            CounterLocalServiceUtil.reset((String)"com.liferay.saml.persistence.model.SamlPeerBinding", (long)(this._getLatestSamlPeerBindingId() + 1));
        }
    }

    private int _getLatestSamlPeerBindingId() throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select max(samlPeerBindingId) from SamlPeerBinding");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }
}

