/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saml.persistence.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.persistence.model.SamlSpAuthRequest;
import com.liferay.saml.persistence.model.SamlSpAuthRequestModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SamlSpAuthRequest service. Represents a row in the &quot;SamlSpAuthRequest&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SamlSpAuthRequestModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SamlSpAuthRequestImpl}.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlSpAuthRequestImpl
 * @generated
 */
public class SamlSpAuthRequestModelImpl
	extends BaseModelImpl<SamlSpAuthRequest> implements SamlSpAuthRequestModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a saml sp auth request model instance should use the <code>SamlSpAuthRequest</code> interface instead.
	 */
	public static final String TABLE_NAME = "SamlSpAuthRequest";

	public static final Object[][] TABLE_COLUMNS = {
		{"samlSpAuthnRequestId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"samlIdpEntityId", Types.VARCHAR},
		{"samlSpAuthRequestKey", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("samlSpAuthnRequestId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("samlIdpEntityId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("samlSpAuthRequestKey", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SamlSpAuthRequest (samlSpAuthnRequestId LONG not null primary key,companyId LONG,createDate DATE null,samlIdpEntityId VARCHAR(1024) null,samlSpAuthRequestKey VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table SamlSpAuthRequest";

	public static final String ORDER_BY_JPQL =
		" ORDER BY samlSpAuthRequest.samlSpAuthnRequestId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SamlSpAuthRequest.samlSpAuthnRequestId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLIDPENTITYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLSPAUTHREQUESTKEY_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLSPAUTHNREQUESTID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public SamlSpAuthRequestModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _samlSpAuthnRequestId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSamlSpAuthnRequestId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _samlSpAuthnRequestId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SamlSpAuthRequest.class;
	}

	@Override
	public String getModelClassName() {
		return SamlSpAuthRequest.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SamlSpAuthRequest, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SamlSpAuthRequest, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SamlSpAuthRequest, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SamlSpAuthRequest)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SamlSpAuthRequest, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SamlSpAuthRequest, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SamlSpAuthRequest)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SamlSpAuthRequest, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SamlSpAuthRequest, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<SamlSpAuthRequest, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<SamlSpAuthRequest, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<SamlSpAuthRequest, Object>>();

			attributeGetterFunctions.put(
				"samlSpAuthnRequestId",
				SamlSpAuthRequest::getSamlSpAuthnRequestId);
			attributeGetterFunctions.put(
				"companyId", SamlSpAuthRequest::getCompanyId);
			attributeGetterFunctions.put(
				"createDate", SamlSpAuthRequest::getCreateDate);
			attributeGetterFunctions.put(
				"samlIdpEntityId", SamlSpAuthRequest::getSamlIdpEntityId);
			attributeGetterFunctions.put(
				"samlSpAuthRequestKey",
				SamlSpAuthRequest::getSamlSpAuthRequestKey);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<SamlSpAuthRequest, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<SamlSpAuthRequest, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<SamlSpAuthRequest, ?>>();

			attributeSetterBiConsumers.put(
				"samlSpAuthnRequestId",
				(BiConsumer<SamlSpAuthRequest, Long>)
					SamlSpAuthRequest::setSamlSpAuthnRequestId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<SamlSpAuthRequest, Long>)
					SamlSpAuthRequest::setCompanyId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<SamlSpAuthRequest, Date>)
					SamlSpAuthRequest::setCreateDate);
			attributeSetterBiConsumers.put(
				"samlIdpEntityId",
				(BiConsumer<SamlSpAuthRequest, String>)
					SamlSpAuthRequest::setSamlIdpEntityId);
			attributeSetterBiConsumers.put(
				"samlSpAuthRequestKey",
				(BiConsumer<SamlSpAuthRequest, String>)
					SamlSpAuthRequest::setSamlSpAuthRequestKey);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getSamlSpAuthnRequestId() {
		return _samlSpAuthnRequestId;
	}

	@Override
	public void setSamlSpAuthnRequestId(long samlSpAuthnRequestId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlSpAuthnRequestId = samlSpAuthnRequestId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalCreateDate() {
		return getColumnOriginalValue("createDate");
	}

	@Override
	public String getSamlIdpEntityId() {
		if (_samlIdpEntityId == null) {
			return "";
		}
		else {
			return _samlIdpEntityId;
		}
	}

	@Override
	public void setSamlIdpEntityId(String samlIdpEntityId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlIdpEntityId = samlIdpEntityId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSamlIdpEntityId() {
		return getColumnOriginalValue("samlIdpEntityId");
	}

	@Override
	public String getSamlSpAuthRequestKey() {
		if (_samlSpAuthRequestKey == null) {
			return "";
		}
		else {
			return _samlSpAuthRequestKey;
		}
	}

	@Override
	public void setSamlSpAuthRequestKey(String samlSpAuthRequestKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlSpAuthRequestKey = samlSpAuthRequestKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSamlSpAuthRequestKey() {
		return getColumnOriginalValue("samlSpAuthRequestKey");
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SamlSpAuthRequest.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SamlSpAuthRequest toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SamlSpAuthRequest>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SamlSpAuthRequestImpl samlSpAuthRequestImpl =
			new SamlSpAuthRequestImpl();

		samlSpAuthRequestImpl.setSamlSpAuthnRequestId(
			getSamlSpAuthnRequestId());
		samlSpAuthRequestImpl.setCompanyId(getCompanyId());
		samlSpAuthRequestImpl.setCreateDate(getCreateDate());
		samlSpAuthRequestImpl.setSamlIdpEntityId(getSamlIdpEntityId());
		samlSpAuthRequestImpl.setSamlSpAuthRequestKey(
			getSamlSpAuthRequestKey());

		samlSpAuthRequestImpl.resetOriginalValues();

		return samlSpAuthRequestImpl;
	}

	@Override
	public SamlSpAuthRequest cloneWithOriginalValues() {
		SamlSpAuthRequestImpl samlSpAuthRequestImpl =
			new SamlSpAuthRequestImpl();

		samlSpAuthRequestImpl.setSamlSpAuthnRequestId(
			this.<Long>getColumnOriginalValue("samlSpAuthnRequestId"));
		samlSpAuthRequestImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		samlSpAuthRequestImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		samlSpAuthRequestImpl.setSamlIdpEntityId(
			this.<String>getColumnOriginalValue("samlIdpEntityId"));
		samlSpAuthRequestImpl.setSamlSpAuthRequestKey(
			this.<String>getColumnOriginalValue("samlSpAuthRequestKey"));

		return samlSpAuthRequestImpl;
	}

	@Override
	public int compareTo(SamlSpAuthRequest samlSpAuthRequest) {
		long primaryKey = samlSpAuthRequest.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SamlSpAuthRequest)) {
			return false;
		}

		SamlSpAuthRequest samlSpAuthRequest = (SamlSpAuthRequest)object;

		long primaryKey = samlSpAuthRequest.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SamlSpAuthRequest> toCacheModel() {
		SamlSpAuthRequestCacheModel samlSpAuthRequestCacheModel =
			new SamlSpAuthRequestCacheModel();

		samlSpAuthRequestCacheModel.samlSpAuthnRequestId =
			getSamlSpAuthnRequestId();

		samlSpAuthRequestCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			samlSpAuthRequestCacheModel.createDate = createDate.getTime();
		}
		else {
			samlSpAuthRequestCacheModel.createDate = Long.MIN_VALUE;
		}

		samlSpAuthRequestCacheModel.samlIdpEntityId = getSamlIdpEntityId();

		String samlIdpEntityId = samlSpAuthRequestCacheModel.samlIdpEntityId;

		if ((samlIdpEntityId != null) && (samlIdpEntityId.length() == 0)) {
			samlSpAuthRequestCacheModel.samlIdpEntityId = null;
		}

		samlSpAuthRequestCacheModel.samlSpAuthRequestKey =
			getSamlSpAuthRequestKey();

		String samlSpAuthRequestKey =
			samlSpAuthRequestCacheModel.samlSpAuthRequestKey;

		if ((samlSpAuthRequestKey != null) &&
			(samlSpAuthRequestKey.length() == 0)) {

			samlSpAuthRequestCacheModel.samlSpAuthRequestKey = null;
		}

		return samlSpAuthRequestCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SamlSpAuthRequest, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SamlSpAuthRequest, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SamlSpAuthRequest, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(SamlSpAuthRequest)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SamlSpAuthRequest>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					SamlSpAuthRequest.class, ModelWrapper.class);

	}

	private long _samlSpAuthnRequestId;
	private long _companyId;
	private Date _createDate;
	private String _samlIdpEntityId;
	private String _samlSpAuthRequestKey;

	public <T> T getColumnValue(String columnName) {
		Function<SamlSpAuthRequest, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SamlSpAuthRequest)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put(
			"samlSpAuthnRequestId", _samlSpAuthnRequestId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("samlIdpEntityId", _samlIdpEntityId);
		_columnOriginalValues.put(
			"samlSpAuthRequestKey", _samlSpAuthRequestKey);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("samlSpAuthnRequestId", 1L);

		columnBitmasks.put("companyId", 2L);

		columnBitmasks.put("createDate", 4L);

		columnBitmasks.put("samlIdpEntityId", 8L);

		columnBitmasks.put("samlSpAuthRequestKey", 16L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SamlSpAuthRequest _escapedModel;

}