/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.saml.persistence.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.model.SamlPeerBindingModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SamlPeerBinding service. Represents a row in the &quot;SamlPeerBinding&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SamlPeerBindingModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SamlPeerBindingImpl}.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlPeerBindingImpl
 * @generated
 */
public class SamlPeerBindingModelImpl
	extends BaseModelImpl<SamlPeerBinding> implements SamlPeerBindingModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a saml peer binding model instance should use the <code>SamlPeerBinding</code> interface instead.
	 */
	public static final String TABLE_NAME = "SamlPeerBinding";

	public static final Object[][] TABLE_COLUMNS = {
		{"samlPeerBindingId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"deleted", Types.BOOLEAN},
		{"samlNameIdFormat", Types.VARCHAR},
		{"samlNameIdNameQualifier", Types.VARCHAR},
		{"samlNameIdSpNameQualifier", Types.VARCHAR},
		{"samlNameIdSpProvidedId", Types.VARCHAR},
		{"samlNameIdValue", Types.VARCHAR}, {"samlPeerEntityId", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("samlPeerBindingId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deleted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("samlNameIdFormat", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("samlNameIdNameQualifier", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("samlNameIdSpNameQualifier", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("samlNameIdSpProvidedId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("samlNameIdValue", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("samlPeerEntityId", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SamlPeerBinding (samlPeerBindingId LONG not null primary key,companyId LONG,createDate DATE null,userId LONG,userName VARCHAR(75) null,deleted BOOLEAN,samlNameIdFormat VARCHAR(75) null,samlNameIdNameQualifier VARCHAR(75) null,samlNameIdSpNameQualifier VARCHAR(75) null,samlNameIdSpProvidedId VARCHAR(75) null,samlNameIdValue VARCHAR(75) null,samlPeerEntityId VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table SamlPeerBinding";

	public static final String ORDER_BY_JPQL =
		" ORDER BY samlPeerBinding.samlPeerBindingId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SamlPeerBinding.samlPeerBindingId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DELETED_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLNAMEIDFORMAT_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLNAMEIDNAMEQUALIFIER_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLNAMEIDVALUE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLPEERENTITYID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLPEERBINDINGID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public SamlPeerBindingModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _samlPeerBindingId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSamlPeerBindingId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _samlPeerBindingId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SamlPeerBinding.class;
	}

	@Override
	public String getModelClassName() {
		return SamlPeerBinding.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SamlPeerBinding, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SamlPeerBinding, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SamlPeerBinding, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SamlPeerBinding)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SamlPeerBinding, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SamlPeerBinding, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SamlPeerBinding)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SamlPeerBinding, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SamlPeerBinding, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<SamlPeerBinding, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<SamlPeerBinding, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<SamlPeerBinding, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<SamlPeerBinding, Object>>();
		Map<String, BiConsumer<SamlPeerBinding, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<SamlPeerBinding, ?>>();

		attributeGetterFunctions.put(
			"samlPeerBindingId", SamlPeerBinding::getSamlPeerBindingId);
		attributeSetterBiConsumers.put(
			"samlPeerBindingId",
			(BiConsumer<SamlPeerBinding, Long>)
				SamlPeerBinding::setSamlPeerBindingId);
		attributeGetterFunctions.put(
			"companyId", SamlPeerBinding::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<SamlPeerBinding, Long>)SamlPeerBinding::setCompanyId);
		attributeGetterFunctions.put(
			"createDate", SamlPeerBinding::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<SamlPeerBinding, Date>)SamlPeerBinding::setCreateDate);
		attributeGetterFunctions.put("userId", SamlPeerBinding::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<SamlPeerBinding, Long>)SamlPeerBinding::setUserId);
		attributeGetterFunctions.put("userName", SamlPeerBinding::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<SamlPeerBinding, String>)SamlPeerBinding::setUserName);
		attributeGetterFunctions.put("deleted", SamlPeerBinding::getDeleted);
		attributeSetterBiConsumers.put(
			"deleted",
			(BiConsumer<SamlPeerBinding, Boolean>)SamlPeerBinding::setDeleted);
		attributeGetterFunctions.put(
			"samlNameIdFormat", SamlPeerBinding::getSamlNameIdFormat);
		attributeSetterBiConsumers.put(
			"samlNameIdFormat",
			(BiConsumer<SamlPeerBinding, String>)
				SamlPeerBinding::setSamlNameIdFormat);
		attributeGetterFunctions.put(
			"samlNameIdNameQualifier",
			SamlPeerBinding::getSamlNameIdNameQualifier);
		attributeSetterBiConsumers.put(
			"samlNameIdNameQualifier",
			(BiConsumer<SamlPeerBinding, String>)
				SamlPeerBinding::setSamlNameIdNameQualifier);
		attributeGetterFunctions.put(
			"samlNameIdSpNameQualifier",
			SamlPeerBinding::getSamlNameIdSpNameQualifier);
		attributeSetterBiConsumers.put(
			"samlNameIdSpNameQualifier",
			(BiConsumer<SamlPeerBinding, String>)
				SamlPeerBinding::setSamlNameIdSpNameQualifier);
		attributeGetterFunctions.put(
			"samlNameIdSpProvidedId",
			SamlPeerBinding::getSamlNameIdSpProvidedId);
		attributeSetterBiConsumers.put(
			"samlNameIdSpProvidedId",
			(BiConsumer<SamlPeerBinding, String>)
				SamlPeerBinding::setSamlNameIdSpProvidedId);
		attributeGetterFunctions.put(
			"samlNameIdValue", SamlPeerBinding::getSamlNameIdValue);
		attributeSetterBiConsumers.put(
			"samlNameIdValue",
			(BiConsumer<SamlPeerBinding, String>)
				SamlPeerBinding::setSamlNameIdValue);
		attributeGetterFunctions.put(
			"samlPeerEntityId", SamlPeerBinding::getSamlPeerEntityId);
		attributeSetterBiConsumers.put(
			"samlPeerEntityId",
			(BiConsumer<SamlPeerBinding, String>)
				SamlPeerBinding::setSamlPeerEntityId);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getSamlPeerBindingId() {
		return _samlPeerBindingId;
	}

	@Override
	public void setSamlPeerBindingId(long samlPeerBindingId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlPeerBindingId = samlPeerBindingId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public boolean getDeleted() {
		return _deleted;
	}

	@Override
	public boolean isDeleted() {
		return _deleted;
	}

	@Override
	public void setDeleted(boolean deleted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deleted = deleted;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalDeleted() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("deleted"));
	}

	@Override
	public String getSamlNameIdFormat() {
		if (_samlNameIdFormat == null) {
			return "";
		}
		else {
			return _samlNameIdFormat;
		}
	}

	@Override
	public void setSamlNameIdFormat(String samlNameIdFormat) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlNameIdFormat = samlNameIdFormat;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSamlNameIdFormat() {
		return getColumnOriginalValue("samlNameIdFormat");
	}

	@Override
	public String getSamlNameIdNameQualifier() {
		if (_samlNameIdNameQualifier == null) {
			return "";
		}
		else {
			return _samlNameIdNameQualifier;
		}
	}

	@Override
	public void setSamlNameIdNameQualifier(String samlNameIdNameQualifier) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlNameIdNameQualifier = samlNameIdNameQualifier;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSamlNameIdNameQualifier() {
		return getColumnOriginalValue("samlNameIdNameQualifier");
	}

	@Override
	public String getSamlNameIdSpNameQualifier() {
		if (_samlNameIdSpNameQualifier == null) {
			return "";
		}
		else {
			return _samlNameIdSpNameQualifier;
		}
	}

	@Override
	public void setSamlNameIdSpNameQualifier(String samlNameIdSpNameQualifier) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlNameIdSpNameQualifier = samlNameIdSpNameQualifier;
	}

	@Override
	public String getSamlNameIdSpProvidedId() {
		if (_samlNameIdSpProvidedId == null) {
			return "";
		}
		else {
			return _samlNameIdSpProvidedId;
		}
	}

	@Override
	public void setSamlNameIdSpProvidedId(String samlNameIdSpProvidedId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlNameIdSpProvidedId = samlNameIdSpProvidedId;
	}

	@Override
	public String getSamlNameIdValue() {
		if (_samlNameIdValue == null) {
			return "";
		}
		else {
			return _samlNameIdValue;
		}
	}

	@Override
	public void setSamlNameIdValue(String samlNameIdValue) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlNameIdValue = samlNameIdValue;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSamlNameIdValue() {
		return getColumnOriginalValue("samlNameIdValue");
	}

	@Override
	public String getSamlPeerEntityId() {
		if (_samlPeerEntityId == null) {
			return "";
		}
		else {
			return _samlPeerEntityId;
		}
	}

	@Override
	public void setSamlPeerEntityId(String samlPeerEntityId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlPeerEntityId = samlPeerEntityId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSamlPeerEntityId() {
		return getColumnOriginalValue("samlPeerEntityId");
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SamlPeerBinding.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SamlPeerBinding toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SamlPeerBinding>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SamlPeerBindingImpl samlPeerBindingImpl = new SamlPeerBindingImpl();

		samlPeerBindingImpl.setSamlPeerBindingId(getSamlPeerBindingId());
		samlPeerBindingImpl.setCompanyId(getCompanyId());
		samlPeerBindingImpl.setCreateDate(getCreateDate());
		samlPeerBindingImpl.setUserId(getUserId());
		samlPeerBindingImpl.setUserName(getUserName());
		samlPeerBindingImpl.setDeleted(isDeleted());
		samlPeerBindingImpl.setSamlNameIdFormat(getSamlNameIdFormat());
		samlPeerBindingImpl.setSamlNameIdNameQualifier(
			getSamlNameIdNameQualifier());
		samlPeerBindingImpl.setSamlNameIdSpNameQualifier(
			getSamlNameIdSpNameQualifier());
		samlPeerBindingImpl.setSamlNameIdSpProvidedId(
			getSamlNameIdSpProvidedId());
		samlPeerBindingImpl.setSamlNameIdValue(getSamlNameIdValue());
		samlPeerBindingImpl.setSamlPeerEntityId(getSamlPeerEntityId());

		samlPeerBindingImpl.resetOriginalValues();

		return samlPeerBindingImpl;
	}

	@Override
	public SamlPeerBinding cloneWithOriginalValues() {
		SamlPeerBindingImpl samlPeerBindingImpl = new SamlPeerBindingImpl();

		samlPeerBindingImpl.setSamlPeerBindingId(
			this.<Long>getColumnOriginalValue("samlPeerBindingId"));
		samlPeerBindingImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		samlPeerBindingImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		samlPeerBindingImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		samlPeerBindingImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		samlPeerBindingImpl.setDeleted(
			this.<Boolean>getColumnOriginalValue("deleted"));
		samlPeerBindingImpl.setSamlNameIdFormat(
			this.<String>getColumnOriginalValue("samlNameIdFormat"));
		samlPeerBindingImpl.setSamlNameIdNameQualifier(
			this.<String>getColumnOriginalValue("samlNameIdNameQualifier"));
		samlPeerBindingImpl.setSamlNameIdSpNameQualifier(
			this.<String>getColumnOriginalValue("samlNameIdSpNameQualifier"));
		samlPeerBindingImpl.setSamlNameIdSpProvidedId(
			this.<String>getColumnOriginalValue("samlNameIdSpProvidedId"));
		samlPeerBindingImpl.setSamlNameIdValue(
			this.<String>getColumnOriginalValue("samlNameIdValue"));
		samlPeerBindingImpl.setSamlPeerEntityId(
			this.<String>getColumnOriginalValue("samlPeerEntityId"));

		return samlPeerBindingImpl;
	}

	@Override
	public int compareTo(SamlPeerBinding samlPeerBinding) {
		long primaryKey = samlPeerBinding.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SamlPeerBinding)) {
			return false;
		}

		SamlPeerBinding samlPeerBinding = (SamlPeerBinding)object;

		long primaryKey = samlPeerBinding.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SamlPeerBinding> toCacheModel() {
		SamlPeerBindingCacheModel samlPeerBindingCacheModel =
			new SamlPeerBindingCacheModel();

		samlPeerBindingCacheModel.samlPeerBindingId = getSamlPeerBindingId();

		samlPeerBindingCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			samlPeerBindingCacheModel.createDate = createDate.getTime();
		}
		else {
			samlPeerBindingCacheModel.createDate = Long.MIN_VALUE;
		}

		samlPeerBindingCacheModel.userId = getUserId();

		samlPeerBindingCacheModel.userName = getUserName();

		String userName = samlPeerBindingCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			samlPeerBindingCacheModel.userName = null;
		}

		samlPeerBindingCacheModel.deleted = isDeleted();

		samlPeerBindingCacheModel.samlNameIdFormat = getSamlNameIdFormat();

		String samlNameIdFormat = samlPeerBindingCacheModel.samlNameIdFormat;

		if ((samlNameIdFormat != null) && (samlNameIdFormat.length() == 0)) {
			samlPeerBindingCacheModel.samlNameIdFormat = null;
		}

		samlPeerBindingCacheModel.samlNameIdNameQualifier =
			getSamlNameIdNameQualifier();

		String samlNameIdNameQualifier =
			samlPeerBindingCacheModel.samlNameIdNameQualifier;

		if ((samlNameIdNameQualifier != null) &&
			(samlNameIdNameQualifier.length() == 0)) {

			samlPeerBindingCacheModel.samlNameIdNameQualifier = null;
		}

		samlPeerBindingCacheModel.samlNameIdSpNameQualifier =
			getSamlNameIdSpNameQualifier();

		String samlNameIdSpNameQualifier =
			samlPeerBindingCacheModel.samlNameIdSpNameQualifier;

		if ((samlNameIdSpNameQualifier != null) &&
			(samlNameIdSpNameQualifier.length() == 0)) {

			samlPeerBindingCacheModel.samlNameIdSpNameQualifier = null;
		}

		samlPeerBindingCacheModel.samlNameIdSpProvidedId =
			getSamlNameIdSpProvidedId();

		String samlNameIdSpProvidedId =
			samlPeerBindingCacheModel.samlNameIdSpProvidedId;

		if ((samlNameIdSpProvidedId != null) &&
			(samlNameIdSpProvidedId.length() == 0)) {

			samlPeerBindingCacheModel.samlNameIdSpProvidedId = null;
		}

		samlPeerBindingCacheModel.samlNameIdValue = getSamlNameIdValue();

		String samlNameIdValue = samlPeerBindingCacheModel.samlNameIdValue;

		if ((samlNameIdValue != null) && (samlNameIdValue.length() == 0)) {
			samlPeerBindingCacheModel.samlNameIdValue = null;
		}

		samlPeerBindingCacheModel.samlPeerEntityId = getSamlPeerEntityId();

		String samlPeerEntityId = samlPeerBindingCacheModel.samlPeerEntityId;

		if ((samlPeerEntityId != null) && (samlPeerEntityId.length() == 0)) {
			samlPeerBindingCacheModel.samlPeerEntityId = null;
		}

		return samlPeerBindingCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SamlPeerBinding, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SamlPeerBinding, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SamlPeerBinding, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((SamlPeerBinding)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<SamlPeerBinding, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<SamlPeerBinding, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SamlPeerBinding, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((SamlPeerBinding)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SamlPeerBinding>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					SamlPeerBinding.class, ModelWrapper.class);

	}

	private long _samlPeerBindingId;
	private long _companyId;
	private Date _createDate;
	private long _userId;
	private String _userName;
	private boolean _deleted;
	private String _samlNameIdFormat;
	private String _samlNameIdNameQualifier;
	private String _samlNameIdSpNameQualifier;
	private String _samlNameIdSpProvidedId;
	private String _samlNameIdValue;
	private String _samlPeerEntityId;

	public <T> T getColumnValue(String columnName) {
		Function<SamlPeerBinding, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SamlPeerBinding)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("samlPeerBindingId", _samlPeerBindingId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("deleted", _deleted);
		_columnOriginalValues.put("samlNameIdFormat", _samlNameIdFormat);
		_columnOriginalValues.put(
			"samlNameIdNameQualifier", _samlNameIdNameQualifier);
		_columnOriginalValues.put(
			"samlNameIdSpNameQualifier", _samlNameIdSpNameQualifier);
		_columnOriginalValues.put(
			"samlNameIdSpProvidedId", _samlNameIdSpProvidedId);
		_columnOriginalValues.put("samlNameIdValue", _samlNameIdValue);
		_columnOriginalValues.put("samlPeerEntityId", _samlPeerEntityId);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("samlPeerBindingId", 1L);

		columnBitmasks.put("companyId", 2L);

		columnBitmasks.put("createDate", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("deleted", 32L);

		columnBitmasks.put("samlNameIdFormat", 64L);

		columnBitmasks.put("samlNameIdNameQualifier", 128L);

		columnBitmasks.put("samlNameIdSpNameQualifier", 256L);

		columnBitmasks.put("samlNameIdSpProvidedId", 512L);

		columnBitmasks.put("samlNameIdValue", 1024L);

		columnBitmasks.put("samlPeerEntityId", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SamlPeerBinding _escapedModel;

}