/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.internal.upgrade.v3_0_0;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.saml.persistence.internal.upgrade.v3_0_0.util.SamlIdpSpSessionTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class SamlIdpSpSessionUpgradeProcess
extends UpgradeProcess {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("SamlIdpSpSession", "samlPeerBindingId")) {
                this.alter(SamlIdpSpSessionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "samlPeerBindingId", "LONG null")});
            }
            this.runSQL("delete from SamlPeerBinding");
            int samlIdpSpSessionIdOffset = this._getSamlIdpSpSessionIdOffset();
            int latestSamlPeerBindingId = this._getLatestSamlPeerBindingId();
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select min(samlIdpSpSessionId) as ", "samlIdpSpSessionId, companyId, min(createDate) ", "as createDate, userId, userName, nameIdFormat, ", "nameIdValue, samlSpEntityId from ", "SamlIdpSpSession group by companyId, userId, ", "userName, nameIdFormat, nameIdValue, ", "samlSpEntityId"}));
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    PreparedStatement insertPreparedStatement;
                    block47: {
                        int samlIdpSpSessionId = resultSet.getInt("samlIdpSpSessionId");
                        long companyId = resultSet.getLong("companyId");
                        Timestamp createDate = resultSet.getTimestamp("createDate");
                        long userId = resultSet.getLong("userId");
                        String userName = resultSet.getString("userName");
                        String nameIdFormat = resultSet.getString("nameIdFormat");
                        String nameIdValue = resultSet.getString("nameIdValue");
                        String samlSpEntityId = resultSet.getString("samlSpEntityId");
                        int samlPeerBindingId = samlIdpSpSessionId + -samlIdpSpSessionIdOffset + latestSamlPeerBindingId;
                        String sql = StringBundler.concat((String[])new String[]{"insert into SamlPeerBinding (samlPeerBindingId, ", "companyId, createDate, userId, userName, deleted, ", "samlNameIdFormat, samlNameIdNameQualifier, ", "samlNameIdSpNameQualifier, samlNameIdSpProvidedId, ", "samlNameIdValue, samlPeerEntityId) values (?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?)"});
                        insertPreparedStatement = this.connection.prepareStatement(sql);
                        Throwable throwable = null;
                        try {
                            insertPreparedStatement.setInt(1, samlPeerBindingId);
                            insertPreparedStatement.setLong(2, companyId);
                            insertPreparedStatement.setTimestamp(3, createDate);
                            insertPreparedStatement.setLong(4, userId);
                            insertPreparedStatement.setString(5, userName);
                            insertPreparedStatement.setBoolean(6, false);
                            insertPreparedStatement.setString(7, nameIdFormat);
                            insertPreparedStatement.setString(8, null);
                            insertPreparedStatement.setString(9, null);
                            insertPreparedStatement.setString(10, null);
                            insertPreparedStatement.setString(11, nameIdValue);
                            insertPreparedStatement.setString(12, samlSpEntityId);
                            insertPreparedStatement.executeUpdate();
                            if (insertPreparedStatement == null) continue;
                            if (throwable == null) break block47;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (insertPreparedStatement == null) throw throwable3;
                                if (throwable == null) {
                                    insertPreparedStatement.close();
                                    throw throwable3;
                                }
                                try {
                                    insertPreparedStatement.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            insertPreparedStatement.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    insertPreparedStatement.close();
                }
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"update SamlIdpSpSession set samlPeerBindingId = (", "select samlPeerBindingId from SamlPeerBinding where ", "SamlIdpSpSession.companyId = SamlPeerBinding.companyId ", "and SamlIdpSpSession.userId = SamlPeerBinding.userId and ", "SamlIdpSpSession.samlSpEntityId = ", "SamlPeerBinding.samlPeerEntityId and ", "SamlIdpSpSession.nameIdFormat = ", "SamlPeerBinding.samlNameIdFormat and ", "SamlIdpSpSession.nameIdValue = ", "SamlPeerBinding.samlNameIdValue)"}));
            CounterLocalServiceUtil.reset((String)"com.liferay.saml.persistence.model.SamlPeerBinding", (long)(this._getLatestSamlPeerBindingId() + 1));
            return;
        }
    }

    private int _getLatestSamlPeerBindingId() throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select max(samlPeerBindingId) from SamlPeerBinding");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }

    private int _getSamlIdpSpSessionIdOffset() throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select min(samlIdpSpSessionId) - 1 from SamlIdpSpSession");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }
}

