/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.persistence.exception.DuplicateSamlIdpSpConnectionSamlSpEntityIdException;
import com.liferay.saml.persistence.exception.SamlIdpSpConnectionMetadataUrlException;
import com.liferay.saml.persistence.exception.SamlIdpSpConnectionMetadataXmlException;
import com.liferay.saml.persistence.exception.SamlIdpSpConnectionNameException;
import com.liferay.saml.persistence.exception.SamlIdpSpConnectionSamlSpEntityIdException;
import com.liferay.saml.persistence.model.SamlIdpSpConnection;
import com.liferay.saml.persistence.service.base.SamlIdpSpConnectionLocalServiceBaseImpl;
import com.liferay.saml.util.MetadataUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.saml.persistence.model.SamlIdpSpConnection"}, service={AopService.class})
public class SamlIdpSpConnectionLocalServiceImpl
extends SamlIdpSpConnectionLocalServiceBaseImpl {
    @Reference
    private MetadataUtil _metadataUtil;

    public SamlIdpSpConnection addSamlIdpSpConnection(String samlSpEntityId, int assertionLifetime, String attributeNames, boolean attributesEnabled, boolean attributesNamespaceEnabled, boolean enabled, boolean encryptionForced, String metadataUrl, InputStream metadataXmlInputStream, String name, String nameIdAttribute, String nameIdFormat, ServiceContext serviceContext) throws PortalException {
        Date now = new Date();
        if (Validator.isNull((String)samlSpEntityId)) {
            throw new SamlIdpSpConnectionSamlSpEntityIdException("SAML SP entity ID is null");
        }
        if (Validator.isNull((String)name)) {
            throw new SamlIdpSpConnectionNameException("Name is null");
        }
        SamlIdpSpConnection existingSamlIdpSpConnection = this.samlIdpSpConnectionPersistence.fetchByC_SSEI(serviceContext.getCompanyId(), samlSpEntityId);
        if (existingSamlIdpSpConnection != null) {
            throw new DuplicateSamlIdpSpConnectionSamlSpEntityIdException();
        }
        long samlIdpSpConnectionId = this.counterLocalService.increment(SamlIdpSpConnection.class.getName());
        SamlIdpSpConnection samlIdpSpConnection = this.samlIdpSpConnectionPersistence.create(samlIdpSpConnectionId);
        samlIdpSpConnection.setCompanyId(serviceContext.getCompanyId());
        samlIdpSpConnection.setCreateDate(now);
        samlIdpSpConnection.setModifiedDate(now);
        samlIdpSpConnection.setSamlSpEntityId(samlSpEntityId);
        samlIdpSpConnection.setAssertionLifetime(assertionLifetime);
        samlIdpSpConnection.setAttributeNames(attributeNames);
        samlIdpSpConnection.setAttributesEnabled(attributesEnabled);
        samlIdpSpConnection.setAttributesNamespaceEnabled(attributesNamespaceEnabled);
        samlIdpSpConnection.setEnabled(enabled);
        samlIdpSpConnection.setEncryptionForced(encryptionForced);
        samlIdpSpConnection.setExpandoBridgeAttributes(serviceContext);
        samlIdpSpConnection.setMetadataUpdatedDate(now);
        if (metadataXmlInputStream == null && Validator.isNotNull((String)metadataUrl)) {
            samlIdpSpConnection.setMetadataUrl(metadataUrl);
            try {
                metadataXmlInputStream = this._metadataUtil.getMetadata(metadataUrl);
            }
            catch (Exception exception) {
                throw new SamlIdpSpConnectionMetadataUrlException(StringBundler.concat((String[])new String[]{"Unable to get metadata from ", metadataUrl, ": ", exception.getMessage()}), (Throwable)exception);
            }
        }
        if (metadataXmlInputStream == null) {
            throw new SamlIdpSpConnectionMetadataUrlException("Unable to get metadata from " + metadataUrl);
        }
        samlIdpSpConnection.setMetadataXml(this.getMetadataXml(metadataXmlInputStream, samlSpEntityId));
        samlIdpSpConnection.setName(name);
        samlIdpSpConnection.setNameIdAttribute(nameIdAttribute);
        samlIdpSpConnection.setNameIdFormat(nameIdFormat);
        return (SamlIdpSpConnection)this.samlIdpSpConnectionPersistence.update((BaseModel)samlIdpSpConnection);
    }

    public SamlIdpSpConnection getSamlIdpSpConnection(long companyId, String samlSpEntityId) throws PortalException {
        return this.samlIdpSpConnectionPersistence.findByC_SSEI(companyId, samlSpEntityId);
    }

    public List<SamlIdpSpConnection> getSamlIdpSpConnections(long companyId) {
        return this.samlIdpSpConnectionPersistence.findByCompanyId(companyId);
    }

    public List<SamlIdpSpConnection> getSamlIdpSpConnections(long companyId, int start, int end) {
        return this.samlIdpSpConnectionPersistence.findByCompanyId(companyId, start, end);
    }

    public List<SamlIdpSpConnection> getSamlIdpSpConnections(long companyId, int start, int end, OrderByComparator orderByComparator) {
        return this.samlIdpSpConnectionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getSamlIdpSpConnectionsCount(long companyId) {
        return this.samlIdpSpConnectionPersistence.countByCompanyId(companyId);
    }

    public void updateMetadata(long samlIdpSpConnectionId) throws PortalException {
        SamlIdpSpConnection samlIdpSpConnection = this.samlIdpSpConnectionPersistence.findByPrimaryKey(samlIdpSpConnectionId);
        String metadataUrl = samlIdpSpConnection.getMetadataUrl();
        if (Validator.isNull((String)metadataUrl)) {
            return;
        }
        InputStream metadataXmlInputStream = null;
        try {
            metadataXmlInputStream = this._metadataUtil.getMetadata(metadataUrl);
        }
        catch (Exception exception) {
            throw new SamlIdpSpConnectionMetadataUrlException(StringBundler.concat((String[])new String[]{"Unable to get metadata from ", metadataUrl, ": ", exception.getMessage()}), (Throwable)exception);
        }
        String metadataXml = "";
        try {
            metadataXml = this._metadataUtil.parseMetadataXml(metadataXmlInputStream, samlIdpSpConnection.getSamlSpEntityId());
        }
        catch (Exception exception) {
            throw new SamlIdpSpConnectionMetadataXmlException("Unable to parse SAML metadata from " + metadataUrl, (Throwable)exception);
        }
        samlIdpSpConnection.setMetadataUpdatedDate(new Date());
        samlIdpSpConnection.setMetadataXml(metadataXml);
        this.samlIdpSpConnectionPersistence.update((BaseModel)samlIdpSpConnection);
    }

    public SamlIdpSpConnection updateSamlIdpSpConnection(long samlIdpSpConnectionId, String samlSpEntityId, int assertionLifetime, String attributeNames, boolean attributesEnabled, boolean attributesNamespaceEnabled, boolean enabled, boolean encryptionForced, String metadataUrl, InputStream metadataXmlInputStream, String name, String nameIdAttribute, String nameIdFormat, ServiceContext serviceContext) throws PortalException {
        SamlIdpSpConnection existingSamlIdpSpConnection;
        Date now = new Date();
        if (Validator.isNull((String)samlSpEntityId)) {
            throw new SamlIdpSpConnectionSamlSpEntityIdException("SAML SP entity ID is null");
        }
        SamlIdpSpConnection samlIdpSpConnection = this.samlIdpSpConnectionPersistence.fetchByPrimaryKey(samlIdpSpConnectionId);
        if (!samlSpEntityId.equals(samlIdpSpConnection.getSamlSpEntityId()) && (existingSamlIdpSpConnection = this.samlIdpSpConnectionPersistence.fetchByC_SSEI(serviceContext.getCompanyId(), samlSpEntityId)) != null) {
            throw new DuplicateSamlIdpSpConnectionSamlSpEntityIdException("Duplicate SAML IDP SP connection for " + samlSpEntityId);
        }
        samlIdpSpConnection.setModifiedDate(now);
        samlIdpSpConnection.setSamlSpEntityId(samlSpEntityId);
        samlIdpSpConnection.setAssertionLifetime(assertionLifetime);
        samlIdpSpConnection.setAttributeNames(attributeNames);
        samlIdpSpConnection.setAttributesEnabled(attributesEnabled);
        samlIdpSpConnection.setAttributesNamespaceEnabled(attributesNamespaceEnabled);
        samlIdpSpConnection.setEnabled(enabled);
        samlIdpSpConnection.setEncryptionForced(encryptionForced);
        samlIdpSpConnection.setExpandoBridgeAttributes(serviceContext);
        if (metadataXmlInputStream == null && Validator.isNotNull((String)metadataUrl)) {
            samlIdpSpConnection.setMetadataUrl(metadataUrl);
            try {
                metadataXmlInputStream = this._metadataUtil.getMetadata(metadataUrl);
            }
            catch (Exception exception) {
                throw new SamlIdpSpConnectionMetadataUrlException(StringBundler.concat((String[])new String[]{"Unable to get metadata from ", metadataUrl, ": ", exception.getMessage()}), (Throwable)exception);
            }
        }
        String metadataXml = "";
        if (metadataXmlInputStream != null) {
            metadataXml = this.getMetadataXml(metadataXmlInputStream, samlSpEntityId);
        }
        if (Validator.isNotNull((String)metadataXml)) {
            samlIdpSpConnection.setMetadataUpdatedDate(now);
            samlIdpSpConnection.setMetadataXml(metadataXml);
        }
        samlIdpSpConnection.setName(name);
        samlIdpSpConnection.setNameIdAttribute(nameIdAttribute);
        samlIdpSpConnection.setNameIdFormat(nameIdFormat);
        return (SamlIdpSpConnection)this.samlIdpSpConnectionPersistence.update((BaseModel)samlIdpSpConnection);
    }

    protected String getMetadataXml(InputStream metadataXmlInputStream, String samlSpEntityId) throws PortalException {
        String metadataXml = "";
        try {
            metadataXml = this._metadataUtil.parseMetadataXml(metadataXmlInputStream, samlSpEntityId);
        }
        catch (Exception exception) {
            throw new SamlIdpSpConnectionMetadataXmlException((Throwable)exception);
        }
        if (Validator.isNull((String)metadataXml)) {
            throw new SamlIdpSpConnectionSamlSpEntityIdException("Metadata XML is null for " + samlSpEntityId);
        }
        return metadataXml;
    }
}

