/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.saml.persistence.exception.DuplicateSamlSpIdpConnectionSamlIdpEntityIdException;
import com.liferay.saml.persistence.exception.SamlSpIdpConnectionMetadataUrlException;
import com.liferay.saml.persistence.exception.SamlSpIdpConnectionMetadataXmlException;
import com.liferay.saml.persistence.exception.SamlSpIdpConnectionSamlIdpEntityIdException;
import com.liferay.saml.persistence.model.SamlSpIdpConnection;
import com.liferay.saml.persistence.service.base.SamlSpIdpConnectionLocalServiceBaseImpl;
import com.liferay.saml.util.MetadataUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class SamlSpIdpConnectionLocalServiceImpl
extends SamlSpIdpConnectionLocalServiceBaseImpl {
    @ServiceReference(type=MetadataUtil.class)
    private MetadataUtil _metadataUtil;

    public SamlSpIdpConnection addSamlSpIdpConnection(String samlIdpEntityId, boolean assertionSignatureRequired, long clockSkew, boolean enabled, boolean forceAuthn, boolean ldapImportEnabled, String metadataUrl, InputStream metadataXmlInputStream, String name, String nameIdFormat, boolean signAuthnRequest, String userAttributeMappings, ServiceContext serviceContext) throws PortalException {
        Date now = new Date();
        if (Validator.isNull((String)samlIdpEntityId)) {
            throw new SamlSpIdpConnectionSamlIdpEntityIdException("SAML IDP entity ID is null");
        }
        SamlSpIdpConnection existingSamlSpIdpConnection = this.samlSpIdpConnectionPersistence.fetchByC_SIEI(serviceContext.getCompanyId(), samlIdpEntityId);
        if (existingSamlSpIdpConnection != null) {
            throw new DuplicateSamlSpIdpConnectionSamlIdpEntityIdException("Duplicate SAML SP IDP connection for " + samlIdpEntityId);
        }
        long samlSpIdpConnectionId = this.counterLocalService.increment(SamlSpIdpConnection.class.getName());
        SamlSpIdpConnection samlSpIdpConnection = this.samlSpIdpConnectionPersistence.create(samlSpIdpConnectionId);
        samlSpIdpConnection.setCompanyId(serviceContext.getCompanyId());
        samlSpIdpConnection.setCreateDate(now);
        samlSpIdpConnection.setModifiedDate(now);
        samlSpIdpConnection.setSamlIdpEntityId(samlIdpEntityId);
        samlSpIdpConnection.setAssertionSignatureRequired(assertionSignatureRequired);
        samlSpIdpConnection.setClockSkew(clockSkew);
        samlSpIdpConnection.setEnabled(enabled);
        samlSpIdpConnection.setForceAuthn(forceAuthn);
        samlSpIdpConnection.setLdapImportEnabled(ldapImportEnabled);
        samlSpIdpConnection.setMetadataUpdatedDate(now);
        if (metadataXmlInputStream == null && Validator.isNotNull((String)metadataUrl)) {
            samlSpIdpConnection.setMetadataUrl(metadataUrl);
            try {
                metadataXmlInputStream = this._metadataUtil.getMetadata(metadataUrl);
            }
            catch (Exception exception) {
                throw new SamlSpIdpConnectionMetadataUrlException(StringBundler.concat((String[])new String[]{"Unable to get metadata from ", metadataUrl, ": ", exception.getMessage()}), (Throwable)exception);
            }
        }
        if (metadataXmlInputStream == null) {
            throw new SamlSpIdpConnectionMetadataUrlException("Unable to get metadata from " + metadataUrl);
        }
        samlSpIdpConnection.setSamlIdpEntityId(samlIdpEntityId);
        samlSpIdpConnection.setMetadataXml(this.getMetadataXml(metadataXmlInputStream, samlIdpEntityId));
        samlSpIdpConnection.setName(name);
        samlSpIdpConnection.setNameIdFormat(nameIdFormat);
        samlSpIdpConnection.setSignAuthnRequest(signAuthnRequest);
        samlSpIdpConnection.setUserAttributeMappings(userAttributeMappings);
        samlSpIdpConnection.setExpandoBridgeAttributes(serviceContext);
        return (SamlSpIdpConnection)this.samlSpIdpConnectionPersistence.update((BaseModel)samlSpIdpConnection);
    }

    public SamlSpIdpConnection getSamlSpIdpConnection(long companyId, String samlIdpEntityId) throws PortalException {
        return this.samlSpIdpConnectionPersistence.findByC_SIEI(companyId, samlIdpEntityId);
    }

    public List<SamlSpIdpConnection> getSamlSpIdpConnections(long companyId) {
        return this.samlSpIdpConnectionPersistence.findByCompanyId(companyId);
    }

    public List<SamlSpIdpConnection> getSamlSpIdpConnections(long companyId, int start, int end) {
        return this.samlSpIdpConnectionPersistence.findByCompanyId(companyId, start, end);
    }

    public List<SamlSpIdpConnection> getSamlSpIdpConnections(long companyId, int start, int end, OrderByComparator orderByComparator) {
        return this.samlSpIdpConnectionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getSamlSpIdpConnectionsCount(long companyId) {
        return this.samlSpIdpConnectionPersistence.countByCompanyId(companyId);
    }

    public void updateMetadata(long samlSpIdpConnectionId) throws PortalException {
        SamlSpIdpConnection samlSpIdpConnection = this.samlSpIdpConnectionPersistence.findByPrimaryKey(samlSpIdpConnectionId);
        String metadataUrl = samlSpIdpConnection.getMetadataUrl();
        if (Validator.isNull((String)metadataUrl)) {
            return;
        }
        InputStream metadataXmlInputStream = null;
        try {
            metadataXmlInputStream = this._metadataUtil.getMetadata(metadataUrl);
        }
        catch (Exception exception) {
            throw new SamlSpIdpConnectionMetadataUrlException(StringBundler.concat((String[])new String[]{"Unable to get metadata from ", metadataUrl, ": ", exception.getMessage()}), (Throwable)exception);
        }
        String metadataXml = "";
        try {
            metadataXml = this._metadataUtil.parseMetadataXml(metadataXmlInputStream, samlSpIdpConnection.getSamlIdpEntityId());
        }
        catch (Exception exception) {
            throw new SamlSpIdpConnectionMetadataXmlException(StringBundler.concat((String[])new String[]{"Unable to parse metadata from ", metadataUrl, ": ", exception.getMessage()}), (Throwable)exception);
        }
        samlSpIdpConnection.setMetadataXml(metadataXml);
        samlSpIdpConnection.setMetadataUpdatedDate(new Date());
        this.samlSpIdpConnectionPersistence.update((BaseModel)samlSpIdpConnection);
    }

    /*
     * Unable to fully structure code
     */
    public SamlSpIdpConnection updateSamlSpIdpConnection(long samlSpIdpConnectionId, String samlIdpEntityId, boolean assertionSignatureRequired, long clockSkew, boolean enabled, boolean forceAuthn, boolean ldapImportEnabled, String metadataUrl, InputStream metadataXmlInputStream, String name, String nameIdFormat, boolean signAuthnRequest, String userAttributeMappings, ServiceContext serviceContext) throws PortalException {
        now = new Date();
        if (Validator.isNull((String)samlIdpEntityId)) {
            throw new SamlSpIdpConnectionSamlIdpEntityIdException("SAML IDP entity ID is null");
        }
        samlSpIdpConnection = this.samlSpIdpConnectionPersistence.findByPrimaryKey(samlSpIdpConnectionId);
        if (!samlIdpEntityId.equals(samlSpIdpConnection.getSamlIdpEntityId()) && (existingSamlSpIdpConnection = this.samlSpIdpConnectionPersistence.fetchByC_SIEI(serviceContext.getCompanyId(), samlIdpEntityId)) != null) {
            throw new DuplicateSamlSpIdpConnectionSamlIdpEntityIdException("Duplicate SAML SP IDP connection for " + samlIdpEntityId);
        }
        samlSpIdpConnection.setCompanyId(serviceContext.getCompanyId());
        samlSpIdpConnection.setCreateDate(now);
        samlSpIdpConnection.setModifiedDate(now);
        samlSpIdpConnection.setSamlIdpEntityId(samlIdpEntityId);
        samlSpIdpConnection.setAssertionSignatureRequired(assertionSignatureRequired);
        samlSpIdpConnection.setClockSkew(clockSkew);
        samlSpIdpConnection.setEnabled(enabled);
        samlSpIdpConnection.setForceAuthn(forceAuthn);
        samlSpIdpConnection.setLdapImportEnabled(ldapImportEnabled);
        samlSpIdpConnection.setMetadataUpdatedDate(now);
        if (metadataXmlInputStream == null && Validator.isNotNull((String)metadataUrl)) {
            samlSpIdpConnection.setMetadataUrl(metadataUrl);
            try {
                metadataXmlInputStream = this._metadataUtil.getMetadata(metadataUrl);
            }
            catch (Exception exception) {
                if (!enabled) ** GOTO lbl26
                throw new SamlSpIdpConnectionMetadataUrlException(StringBundler.concat((String[])new String[]{"Unable to get metadata from ", metadataUrl, ": ", exception.getMessage()}), (Throwable)exception);
            }
        } else {
            samlSpIdpConnection.setMetadataUrl("");
        }
lbl26:
        // 3 sources

        metadataXml = "";
        if (metadataXmlInputStream != null) {
            metadataXml = this.getMetadataXml(metadataXmlInputStream, samlIdpEntityId);
        }
        if (Validator.isNotNull((String)metadataXml)) {
            samlSpIdpConnection.setMetadataXml(metadataXml);
            samlSpIdpConnection.setMetadataUpdatedDate(now);
        }
        samlSpIdpConnection.setSamlIdpEntityId(samlIdpEntityId);
        samlSpIdpConnection.setName(name);
        samlSpIdpConnection.setNameIdFormat(nameIdFormat);
        samlSpIdpConnection.setSignAuthnRequest(signAuthnRequest);
        samlSpIdpConnection.setUserAttributeMappings(userAttributeMappings);
        samlSpIdpConnection.setExpandoBridgeAttributes(serviceContext);
        return (SamlSpIdpConnection)this.samlSpIdpConnectionPersistence.update((BaseModel)samlSpIdpConnection);
    }

    protected String getMetadataXml(InputStream metadataXmlInputStream, String samlIdpEntityId) throws PortalException {
        String metadataXml = "";
        try {
            metadataXml = this._metadataUtil.parseMetadataXml(metadataXmlInputStream, samlIdpEntityId);
        }
        catch (Exception exception) {
            throw new SamlSpIdpConnectionMetadataXmlException((Throwable)exception);
        }
        if (Validator.isNull((String)metadataXml)) {
            throw new SamlSpIdpConnectionSamlIdpEntityIdException("Metadata XML is null for " + samlIdpEntityId);
        }
        return metadataXml;
    }
}

