/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.saml.persistence.exception.DuplicateSamlIdpSsoSessionException;
import com.liferay.saml.persistence.model.SamlIdpSsoSession;
import com.liferay.saml.persistence.service.base.SamlIdpSsoSessionLocalServiceBaseImpl;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import java.util.Date;
import org.osgi.service.cm.ConfigurationAdmin;

public class SamlIdpSsoSessionLocalServiceImpl
extends SamlIdpSsoSessionLocalServiceBaseImpl {
    @ServiceReference(type=ConfigurationAdmin.class)
    private ConfigurationAdmin _configurationAdmin;
    @ServiceReference(type=SamlProviderConfigurationHelper.class)
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;

    public SamlIdpSsoSession addSamlIdpSsoSession(String samlIdpSsoSessionKey, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUserById(serviceContext.getUserId());
        Date now = new Date();
        SamlIdpSsoSession samlIdpSsoSession = this.samlIdpSsoSessionPersistence.fetchBySamlIdpSsoSessionKey(samlIdpSsoSessionKey);
        if (samlIdpSsoSession != null) {
            throw new DuplicateSamlIdpSsoSessionException("Duplicate SAML IDP SSO session for " + samlIdpSsoSessionKey);
        }
        long samlIdpSsoSessionId = this.counterLocalService.increment(SamlIdpSsoSession.class.getName());
        samlIdpSsoSession = this.samlIdpSsoSessionPersistence.create(samlIdpSsoSessionId);
        samlIdpSsoSession.setCompanyId(serviceContext.getCompanyId());
        samlIdpSsoSession.setUserId(user.getUserId());
        samlIdpSsoSession.setUserName(user.getFullName());
        samlIdpSsoSession.setCreateDate(now);
        samlIdpSsoSession.setModifiedDate(now);
        samlIdpSsoSession.setSamlIdpSsoSessionKey(samlIdpSsoSessionKey);
        return (SamlIdpSsoSession)this.samlIdpSsoSessionPersistence.update((BaseModel)samlIdpSsoSession);
    }

    public void deleteExpiredSamlIdpSsoSessions() {
        Date createDate = new Date();
        SamlProviderConfiguration samlProviderConfiguration = this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
        createDate.setTime(createDate.getTime() - samlProviderConfiguration.sessionMaximumAge());
        this.samlIdpSsoSessionPersistence.removeByCreateDate(createDate);
        this.samlIdpSpSessionPersistence.removeByCreateDate(createDate);
    }

    public SamlIdpSsoSession fetchSamlIdpSso(String samlIdpSsoSessionKey) {
        return this.samlIdpSsoSessionPersistence.fetchBySamlIdpSsoSessionKey(samlIdpSsoSessionKey);
    }

    public SamlIdpSsoSession getSamlIdpSso(String samlIdpSsoSessionKey) throws PortalException {
        return this.samlIdpSsoSessionPersistence.findBySamlIdpSsoSessionKey(samlIdpSsoSessionKey);
    }

    public SamlIdpSsoSession updateModifiedDate(String samlIdpSsoSessionKey) throws PortalException {
        SamlIdpSsoSession samlIdpSsoSession = this.samlIdpSsoSessionPersistence.findBySamlIdpSsoSessionKey(samlIdpSsoSessionKey);
        samlIdpSsoSession.setModifiedDate(new Date());
        return (SamlIdpSsoSession)this.samlIdpSsoSessionPersistence.update((BaseModel)samlIdpSsoSession);
    }
}

