/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.util;

import com.liferay.petra.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.lang.reflect.Method;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;

public class ConfigurationServiceBootstrapUtil {
    private static final DefaultNoticeableFuture<Void> _initializationDefaultNoticeableFuture = new DefaultNoticeableFuture(() -> {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(ConfigurationServiceBootstrapUtil.class.getClassLoader());
            InitializationService.initialize();
            ConfigurationServiceBootstrapUtil._initializeParserPool();
            Method method = Signer.class.getDeclaredMethod("getSignerProvider", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            method = SignatureValidator.class.getDeclaredMethod("getSignatureValidationProvider", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            if (XMLSecurityConstants.xmlOutputFactory == null) {
                throw new IllegalStateException();
            }
            Void void_ = null;
            return void_;
        }
        finally {
            currentThread.setContextClassLoader(classLoader);
        }
    });

    public static <T> T get(Class<T> configurationClass) {
        _initializationDefaultNoticeableFuture.run();
        return (T)ConfigurationService.get(configurationClass);
    }

    public static <T> void register(Class<T> configurationClass, T configuration) {
        _initializationDefaultNoticeableFuture.addFutureListener(future -> ConfigurationService.register((Class)configurationClass, (Object)configuration));
    }

    private static void _initializeParserPool() throws InitializationException {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.setBuilderFeatures(HashMapBuilder.put((Object)"http://apache.org/xml/features/disallow-doctype-decl", (Object)Boolean.TRUE).put((Object)"http://apache.org/xml/features/dom/defer-node-expansion", (Object)Boolean.FALSE).put((Object)"http://javax.xml.XMLConstants/feature/secure-processing", (Object)Boolean.TRUE).put((Object)"http://xml.org/sax/features/external-general-entities", (Object)Boolean.FALSE).put((Object)"http://xml.org/sax/features/external-parameter-entities", (Object)Boolean.FALSE).build());
        parserPool.setDTDValidating(false);
        parserPool.setExpandEntityReferences(false);
        parserPool.setMaxPoolSize(50);
        parserPool.setNamespaceAware(true);
        try {
            parserPool.initialize();
            parserPool.getBuilder();
            XMLObjectProviderRegistry xmlObjectProviderRegistry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            xmlObjectProviderRegistry.setParserPool((ParserPool)parserPool);
        }
        catch (Exception exception) {
            throw new InitializationException("Unable to initialize parser pool: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

