/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.field.expression.handler;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.saml.opensaml.integration.field.expression.handler.UserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.processor.context.ProcessorContext;
import com.liferay.saml.opensaml.integration.processor.context.UserProcessorContext;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.joda.time.DateTime;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"display.index:Integer=0", "prefix=", "processing.index:Integer=-1"}, service={UserFieldExpressionHandler.class})
public class DefaultUserFieldExpressionHandler
implements UserFieldExpressionHandler {
    private static final Log _log = LogFactoryUtil.getLog(DefaultUserFieldExpressionHandler.class);
    private final Set<String> _authFieldExpressions = new HashSet<String>(Arrays.asList("emailAddress", "screenName", "uuid"));
    @Reference
    private LDAPUserImporter _ldapUserImporter;
    @Reference
    private PrefsProps _prefsProps;
    private int _processingIndex;
    @Reference
    private UserLocalService _userLocalService;
    private final List<String> _validFieldExpressions = Collections.unmodifiableList(Arrays.asList("emailAddress", "firstName", "lastName", "screenName", "uuid"));

    @Override
    public void bindProcessorContext(UserProcessorContext processorContext) {
        ProcessorContext.Bind userBind = processorContext.bind(Integer.MIN_VALUE, (currentUser, newUser, serviceContext) -> newUser);
        userBind.mapString("emailAddress", UserModel::setEmailAddress);
        userBind.mapString("firstName", UserModel::setFirstName);
        userBind.mapString("lastName", UserModel::setLastName);
        userBind.mapUnsafeString("modifiedDate", (user, value) -> {
            DateTime dateTime = new DateTime(value);
            user.setModifiedDate(dateTime.toDate());
        });
        userBind.mapString("screenName", (user, screenName) -> {
            if (this._prefsProps.getBoolean(user.getCompanyId(), "users.screen.name.always.autogenerate")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Ignored incoming screen name because autogeneration is configured");
                }
            } else {
                user.setScreenName(screenName);
            }
        });
        userBind.mapString("uuid", UserModel::setUuid);
        processorContext.bind(this._processingIndex, this::_updateUser);
    }

    @Override
    public User getLdapUser(long companyId, String userIdentifier, String userIdentifierExpression) throws Exception {
        if (userIdentifierExpression.equals("emailAddress")) {
            return this._ldapUserImporter.importUser(companyId, userIdentifier, "");
        }
        if (userIdentifierExpression.equals("screenName")) {
            return this._ldapUserImporter.importUser(companyId, "", userIdentifier);
        }
        if (userIdentifierExpression.equals("uuid")) {
            return this._ldapUserImporter.importUserByUuid(companyId, userIdentifier);
        }
        return null;
    }

    @Override
    public String getSectionLabel(Locale locale) {
        return ResourceBundleUtil.getString((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, DefaultUserFieldExpressionHandler.class), (String)"basic-user-fields");
    }

    @Override
    public User getUser(long companyId, String userIdentifier, String userIdentifierExpression) throws PortalException {
        block5: {
            try {
                if (userIdentifierExpression.equals("emailAddress")) {
                    return this._userLocalService.getUserByEmailAddress(companyId, userIdentifier);
                }
                if (userIdentifierExpression.equals("screenName")) {
                    return this._userLocalService.getUserByScreenName(companyId, userIdentifier);
                }
                if (userIdentifierExpression.equals("uuid")) {
                    return this._userLocalService.getUserByUuidAndCompanyId(userIdentifier, companyId);
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)noSuchUserException);
            }
        }
        return null;
    }

    @Override
    public List<String> getValidFieldExpressions() {
        return this._validFieldExpressions;
    }

    @Override
    public boolean isSupportedForUserMatching(String userFieldExpression) {
        return this._authFieldExpressions.contains(userFieldExpression);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._processingIndex = GetterUtil.getInteger((Object)properties.get("processing.index"));
    }

    private User _addUser(User newUser, ServiceContext serviceContext) throws PortalException {
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        int prefixListTypeId = 0;
        int suffixListTypeId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        boolean sendEmail = false;
        if (!Validator.isBlank((String)newUser.getUuid())) {
            serviceContext.setUuid(newUser.getUuid());
        }
        User user = this._userLocalService.addUser(creatorUserId, newUser.getCompanyId(), autoPassword, password1, password2, autoScreenName, newUser.getScreenName(), newUser.getEmailAddress(), serviceContext.getLocale(), newUser.getFirstName(), newUser.getMiddleName(), newUser.getLastName(), (long)prefixListTypeId, (long)suffixListTypeId, male, birthdayMonth, birthdayDay, birthdayYear, newUser.getJobTitle(), 1, newUser.getGroupIds(), newUser.getOrganizationIds(), newUser.getRoleIds(), newUser.getUserGroupIds(), sendEmail, serviceContext);
        user = this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        user = this._userLocalService.updatePasswordReset(user.getUserId(), false);
        if (newUser.getModifiedDate() != null) {
            user = this._userLocalService.updateModifiedDate(user.getUserId(), newUser.getModifiedDate());
        }
        return user;
    }

    private User _updateUser(User currentUser, User newUser, ServiceContext serviceContext) throws PortalException {
        if (newUser.isNew()) {
            return this._addUser(newUser, serviceContext);
        }
        if (!Objects.equals((currentUser = this._userLocalService.getUserById(currentUser.getUserId())).getEmailAddress(), newUser.getEmailAddress())) {
            newUser = this._userLocalService.updateEmailAddress(newUser.getUserId(), "", newUser.getEmailAddress(), newUser.getEmailAddress());
            newUser = this._userLocalService.updateEmailAddressVerified(newUser.getUserId(), true);
        }
        if (Objects.equals(currentUser.getFirstName(), newUser.getFirstName()) && Objects.equals(currentUser.getLastName(), newUser.getLastName()) && Objects.equals(currentUser.getModifiedDate(), newUser.getModifiedDate()) && Objects.equals(currentUser.getScreenName(), newUser.getScreenName()) && Objects.equals(currentUser.getUuid(), newUser.getUuid())) {
            return newUser;
        }
        Contact contact = newUser.getContact();
        Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar();
        birthdayCalendar.setTime(contact.getBirthday());
        Date modifiedDate = newUser.getModifiedDate();
        serviceContext.setUuid(newUser.getUuid());
        newUser = this._userLocalService.updateUser(newUser.getUserId(), "", "", "", false, newUser.getReminderQueryQuestion(), newUser.getReminderQueryAnswer(), newUser.getScreenName(), newUser.getEmailAddress(), true, null, newUser.getLanguageId(), newUser.getTimeZoneId(), newUser.getGreeting(), newUser.getComments(), newUser.getFirstName(), newUser.getMiddleName(), newUser.getLastName(), contact.getPrefixListTypeId(), contact.getSuffixListTypeId(), newUser.getMale(), birthdayCalendar.get(2), birthdayCalendar.get(5), birthdayCalendar.get(1), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), contact.getJobTitle(), null, null, null, null, null, serviceContext);
        if (!Objects.equals(currentUser.getModifiedDate(), newUser.getModifiedDate())) {
            newUser = this._userLocalService.updateModifiedDate(newUser.getUserId(), modifiedDate);
        }
        return newUser;
    }
}

