/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.servlet.profile;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.helper.SamlHttpRequestHelper;
import com.liferay.saml.opensaml.integration.internal.binding.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.BaseProfile;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.ExceptionHandlerUtil;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.SamlSloContext;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.SamlSloRequestInfo;
import com.liferay.saml.opensaml.integration.internal.transport.HttpClientFactory;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.persistence.model.SamlIbSloMessage;
import com.liferay.saml.persistence.model.SamlIdpSpSession;
import com.liferay.saml.persistence.model.SamlIdpSsoSession;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlIbSloMessageLocalService;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSpSessionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSsoSessionLocalService;
import com.liferay.saml.persistence.service.SamlPeerBindingLocalService;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.exception.UnsolicitedLogoutResponseException;
import com.liferay.saml.runtime.exception.UnsupportedBindingException;
import com.liferay.saml.runtime.servlet.profile.SingleLogoutProfile;
import com.liferay.saml.util.JspUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.servlet.HttpServletRequestMessageDecoder;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.servlet.HttpServletResponseMessageEncoder;
import org.opensaml.messaging.pipeline.httpclient.BasicHttpClientMessagePipeline;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipeline;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipelineFactory;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.security.credential.Credential;
import org.opensaml.soap.client.http.PipelineFactoryHttpSOAPClient;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={SingleLogoutProfile.class})
public class SingleLogoutProfileImpl
extends BaseProfile
implements SingleLogoutProfile {
    private static final Log _log = LogFactoryUtil.getLog(SingleLogoutProfileImpl.class);
    @Reference
    private HttpClientFactory _httpClientFactory;
    @Reference
    private SamlHttpRequestHelper _samlHttpRequestHelper;
    @Reference
    private SamlIbSloMessageLocalService _samlIbSloMessageLocalService;
    @Reference
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    @Reference
    private SamlIdpSpSessionLocalService _samlIdpSpSessionLocalService;
    @Reference
    private SamlIdpSsoSessionLocalService _samlIdpSsoSessionLocalService;
    @Reference
    private SamlPeerBindingLocalService _samlPeerBindingLocalService;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public boolean isSingleLogoutSupported(HttpServletRequest httpServletRequest) {
        block6: {
            try {
                String binding;
                SamlPeerBinding samlPeerBinding;
                SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
                if (samlSpSession == null || samlSpSession.isTerminated()) {
                    return false;
                }
                User user = this._userLocalService.getUser(samlSpSession.getUserId());
                if (!user.isSetupComplete()) {
                    return false;
                }
                MetadataResolver metadataResolver = this.getMetadataResolver();
                EntityDescriptor entityDescriptor = (EntityDescriptor)metadataResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion((samlPeerBinding = this._samlPeerBindingLocalService.getSamlPeerBinding(samlSpSession.getSamlPeerBindingId())).getSamlPeerEntityId())}));
                SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService((SSODescriptor)entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"), "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                if (singleLogoutService != null && !(binding = singleLogoutService.getBinding()).equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                    return true;
                }
            }
            catch (Exception exception) {
                String message = "Unable to verify single logout support: " + exception.getMessage();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)exception);
                }
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)message);
            }
        }
        return false;
    }

    public void processIdpLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        String requestPath = this._samlHttpRequestHelper.getRequestPath(httpServletRequest);
        try {
            httpServletResponse.addHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.addHeader("Pragma", "no-cache");
            if (requestPath.equals("/c/portal/logout")) {
                this._initiateIdpSingleLogout(httpServletRequest, httpServletResponse);
            } else if (requestPath.equals("/c/portal/saml/slo_logout")) {
                SamlSloContext samlSloContext = this._getSamlSloContext(httpServletRequest, null);
                if (samlSloContext == null) {
                    this._redirectToLogout(httpServletRequest, httpServletResponse);
                    return;
                }
                String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
                if (Validator.isNull((String)cmd)) {
                    httpServletRequest.setAttribute("SAML_SLO_CONTEXT", (Object)samlSloContext.toJSONObject());
                    JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo.jsp", (String)"single-sign-out");
                } else if (cmd.equals("logout")) {
                    this.performIdpSpLogout(httpServletRequest, httpServletResponse, samlSloContext);
                } else if (cmd.equals("finish")) {
                    this._performIdpFinishLogout(httpServletRequest, httpServletResponse, samlSloContext);
                } else if (cmd.equals("status")) {
                    this._performIdpStatus(httpServletResponse, samlSloContext);
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandlerUtil.handleException(exception);
        }
    }

    public void processSingleLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        block10: {
            SamlBinding samlBinding = null;
            String method = httpServletRequest.getMethod();
            String requestPath = this._samlHttpRequestHelper.getRequestPath(httpServletRequest);
            if (requestPath.endsWith("/slo") && StringUtil.equalsIgnoreCase((String)method, (String)"GET")) {
                samlBinding = this.samlBindingProvider.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            } else if (requestPath.endsWith("/slo") && StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
                samlBinding = this.samlBindingProvider.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            } else if (requestPath.endsWith("/slo_soap") && StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
                samlBinding = this.samlBindingProvider.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            } else {
                throw new UnsupportedBindingException();
            }
            try {
                MessageContext<?> messageContext = this.decodeSamlMessage(httpServletRequest, httpServletResponse, samlBinding, true);
                InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
                MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
                Object inboundSamlMessage = inboundMessageContext.getMessage();
                if (inboundSamlMessage instanceof LogoutRequest) {
                    this._processSingleLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
                    break block10;
                }
                if (inboundSamlMessage instanceof LogoutResponse) {
                    this._processSingleLogoutResponse(httpServletRequest, httpServletResponse, messageContext);
                    break block10;
                }
                throw new SamlException("Unrecognized inbound SAML message " + String.valueOf(inboundSamlMessage.getClass()));
            }
            catch (Exception exception) {
                ExceptionHandlerUtil.handleException(exception);
            }
        }
    }

    public void processSpLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        try {
            this.sendSpLogoutRequest(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            ExceptionHandlerUtil.handleException(exception);
        }
    }

    public void terminateSpSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
            if (samlSpSession == null) {
                return;
            }
            this.samlSpSessionLocalService.deleteSamlSpSession(samlSpSession);
            CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"SAML_SP_SESSION_KEY"});
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)systemException);
            }
            _log.error((Throwable)systemException);
        }
    }

    public void terminateSsoSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String samlSsoSessionId = this.getSamlSsoSessionId(httpServletRequest);
        if (Validator.isNotNull((String)samlSsoSessionId)) {
            try {
                SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId);
                if (samlIdpSsoSession != null) {
                    this._samlIdpSsoSessionLocalService.deleteSamlIdpSsoSession(samlIdpSsoSession);
                    List samlIdpSpSessions = this._samlIdpSpSessionLocalService.getSamlIdpSpSessions(samlIdpSsoSession.getSamlIdpSsoSessionId());
                    for (SamlIdpSpSession samlIdpSpSession : samlIdpSpSessions) {
                        this._samlIdpSpSessionLocalService.deleteSamlIdpSpSession(samlIdpSpSession);
                    }
                }
            }
            catch (SystemException systemException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)systemException);
                }
                _log.error((Throwable)systemException);
            }
        }
        CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"SAML_SSO_SESSION_ID"});
    }

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    protected void performIdpSpLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSloContext samlSloContext) throws Exception {
        String entityId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"entityId");
        SamlSloRequestInfo samlSloRequestInfo = samlSloContext.getSamlSloRequestInfo(entityId);
        if (samlSloRequestInfo == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Received logout request for service provider " + entityId + " that the user is not logged into"));
            }
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/error.jsp", (String)"single-sign-out", (boolean)true);
            return;
        }
        if (samlSloRequestInfo.getStatus() == 2) {
            httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
            return;
        }
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, entityId);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlPeerMetadataContext.getRoleDescriptor();
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService((SSODescriptor)spSSODescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        if (singleLogoutService == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Single logout not supported by " + entityId));
            }
            samlSloRequestInfo.setStatus(4);
            samlSloRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding");
            httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
        } else {
            try {
                this.sendIdpLogoutRequest(httpServletRequest, httpServletResponse, samlSloContext, samlSloRequestInfo);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to perform a single logout for service ", "provider ", entityId, " with binding ", singleLogoutService.getBinding(), " to ", singleLogoutService.getLocation()}), (Throwable)exception);
                }
                samlSloRequestInfo.setStatus(3);
                samlSloRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
                httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
                JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
            }
        }
    }

    protected void sendIdpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSloContext samlSloContext, SamlSloRequestInfo samlSloRequestInfo) throws Exception {
        SamlIdpSpSession samlIdpSpSession = samlSloRequestInfo.getSamlIdpSpSession();
        MessageContext<LogoutRequest> messageContext = this._buildLogoutRequestMessageContext(httpServletRequest, httpServletResponse, samlSloRequestInfo.getEntityId(), this._samlPeerBindingLocalService.getSamlPeerBinding(samlIdpSpSession.getSamlPeerBindingId()));
        samlSloRequestInfo.setInitiateTime(new DateTime(DateTimeZone.UTC));
        samlSloRequestInfo.setStatus(1);
        if ("urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equals(this._getSAMLPeerEntityBinding(messageContext))) {
            samlSloRequestInfo.setStatusCode(this._sendSyncLogoutRequest(messageContext, samlSloContext));
            httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
            JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
        } else {
            this._sendAsyncLogoutRequest(httpServletResponse, messageContext, samlSloContext.getSamlSsoSessionId());
        }
    }

    protected void sendSpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SamlSpSession samlSpSession = this.getSamlSpSession(httpServletRequest);
        if (samlSpSession == null || samlSpSession.isTerminated()) {
            this._redirectToLogout(httpServletRequest, httpServletResponse);
            return;
        }
        SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.getSamlPeerBinding(samlSpSession.getSamlPeerBindingId());
        this._terminateSamlSpSessions(samlPeerBinding.getSamlNameIdFormat(), samlPeerBinding.getSamlNameIdNameQualifier(), samlPeerBinding.getSamlNameIdSpNameQualifier(), samlPeerBinding.getSamlNameIdValue(), samlPeerBinding.getSamlPeerEntityId(), Collections.singletonList(samlSpSession.getSessionIndex()));
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, samlPeerBinding.getSamlPeerEntityId());
        InOutOperationContext<?, LogoutRequest> inOutOperationContext = this._buildInOutOperationContext(httpServletRequest, messageContext);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        logoutRequest.setDestination(this._getSAMLPeerEntityLocation(outboundMessageContext));
        logoutRequest.setID(this.generateIdentifier(20));
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)outboundMessageContext.getSubcontext(SAMLSelfEntityContext.class);
        logoutRequest.setIssuer(OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId()));
        logoutRequest.setNameID(OpenSamlUtil.buildNameId(samlPeerBinding.getSamlNameIdFormat(), samlPeerBinding.getSamlNameIdNameQualifier(), samlPeerBinding.getSamlNameIdSpNameQualifier(), samlPeerBinding.getSamlNameIdValue()));
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        outboundMessageContext.setMessage((Object)logoutRequest);
        this._addSessionIndex(logoutRequest, samlSpSession.getSessionIndex());
        HttpSession httpSession = httpServletRequest.getSession();
        if (this.samlProviderConfigurationHelper.isRoleIb() && Validator.isNotNull((Object)httpSession.getAttribute("SAML_SSO_SESSION_ID"))) {
            this._samlIbSloMessageLocalService.addSamlIbSloMessage(samlSpSession.getCompanyId(), samlPeerBinding.getSamlPeerEntityId(), OpenSamlUtil.marshall((XMLObject)logoutRequest), samlSpSession.getSessionIndex());
            List<SamlIdpSpSession> samlIdpSpSessions = this._getSamlIdpSpSessions(samlSpSession.getSessionIndex());
            SamlIdpSpSession samlIdpSpSession = this._samlIdpSpSessionLocalService.deleteSamlIdpSpSession(samlIdpSpSessions.get(0));
            this._sendIbLogoutRequest(httpServletRequest, httpServletResponse, samlIdpSpSession, samlSpSession.getSessionIndex());
            return;
        }
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    private void _addSessionIndex(LogoutRequest logoutRequest, String sessionIndexString) {
        if (Validator.isNull((String)sessionIndexString)) {
            return;
        }
        List sessionIndexes = logoutRequest.getSessionIndexes();
        SessionIndex sessionIndex = OpenSamlUtil.buildSessionIndex(sessionIndexString);
        sessionIndexes.add(sessionIndex);
    }

    private MessageContext<?> _buildIbLogoutRequestMessageContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LogoutRequest logoutRequest, String samlIdpEntityId) throws Exception {
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, samlIdpEntityId);
        InOutOperationContext<?, LogoutRequest> inOutOperationContext = this._buildInOutOperationContext(httpServletRequest, messageContext);
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        outboundMessageContext.setMessage((Object)logoutRequest);
        return messageContext;
    }

    private MessageContext<?> _buildIbLogoutResponseMessageContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LogoutRequest logoutRequest, String samlIdpEntityId) throws Exception {
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, samlIdpEntityId);
        InOutOperationContext inOutOperationContext = new InOutOperationContext(new MessageContext(), new MessageContext());
        this._buildInOutOperationContext(inOutOperationContext, logoutRequest, messageContext, "urn:oasis:names:tc:SAML:2.0:status:Success");
        messageContext.addSubcontext((BaseContext)inOutOperationContext);
        return messageContext;
    }

    private InOutOperationContext<?, LogoutRequest> _buildInOutOperationContext(HttpServletRequest httpServletRequest, MessageContext<?> messageContext) throws Exception {
        InOutOperationContext inOutOperationContext = new InOutOperationContext(new MessageContext(), new MessageContext());
        messageContext.addSubcontext((BaseContext)inOutOperationContext);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)outboundMessageContext.getSubcontext(SAMLBindingContext.class, true);
        samlBindingContext.setRelayState(this.portal.getPortalURL(httpServletRequest));
        outboundMessageContext.addSubcontext((BaseContext)samlBindingContext);
        outboundMessageContext.addSubcontext((BaseContext)this._buildSamlPeerEntityContext(true, messageContext, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true)));
        outboundMessageContext.addSubcontext(messageContext.getSubcontext(SAMLSelfEntityContext.class));
        return inOutOperationContext;
    }

    private void _buildInOutOperationContext(InOutOperationContext<?, LogoutResponse> inOutOperationContext, LogoutRequest logoutRequest, MessageContext<?> messageContext, String statusCodeURI) throws Exception {
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        samlBindingContext.setBindingUri("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        outboundMessageContext.addSubcontext((BaseContext)samlBindingContext);
        outboundMessageContext.addSubcontext((BaseContext)this._buildSamlPeerEntityContext(false, messageContext, samlBindingContext.getBindingUri(), (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true)));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        outboundMessageContext.addSubcontext((BaseContext)samlSelfEntityContext);
        outboundMessageContext.setMessage((Object)this._buildLogoutResponse(this._getSAMLPeerEntityLocation(outboundMessageContext), samlSelfEntityContext.getEntityId(), logoutRequest.getID(), statusCodeURI));
    }

    private MessageContext<LogoutRequest> _buildLogoutRequestMessageContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String peerEntityId, SamlPeerBinding samlPeerBinding) throws Exception {
        MessageContext<?> messageContext = this.getMessageContext(httpServletRequest, httpServletResponse, peerEntityId);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointContext.setEndpoint((Endpoint)SamlUtil.resolveSingleLogoutService(samlMetadataContext.getRoleDescriptor(), "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"));
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class, true);
        samlSubjectNameIdentifierContext.setSubjectNameIdentifier((SAMLObject)OpenSamlUtil.buildNameId(samlPeerBinding.getSamlNameIdFormat(), samlPeerBinding.getSamlNameIdValue()));
        return messageContext;
    }

    private LogoutResponse _buildLogoutResponse(String destination, String issuer, String logoutRequestID, String statusCodeURI) {
        LogoutResponse logoutResponse = OpenSamlUtil.buildLogoutResponse();
        logoutResponse.setDestination(destination);
        logoutResponse.setID(this.generateIdentifier(20));
        logoutResponse.setInResponseTo(logoutRequestID);
        logoutResponse.setIssueInstant(new DateTime(DateTimeZone.UTC));
        logoutResponse.setIssuer(OpenSamlUtil.buildIssuer(issuer));
        logoutResponse.setStatus(OpenSamlUtil.buildStatus(OpenSamlUtil.buildStatusCode(statusCodeURI)));
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        return logoutResponse;
    }

    private SAMLPeerEntityContext _buildSamlPeerEntityContext(boolean forceAutoCreateSAMLMetadataContext, MessageContext<?> messageContext, String preferredBinding, SecurityParametersContext securityParametersContext) throws Exception {
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext samlPeerEndpointSubcontext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class, samlPeerEntityContext.isAutoCreateSubcontexts() || forceAutoCreateSAMLMetadataContext);
        samlPeerEndpointSubcontext.setEndpoint((Endpoint)SamlUtil.resolveSingleLogoutService(samlMetadataContext.getRoleDescriptor(), preferredBinding));
        OpenSamlUtil.prepareSecurityParametersContext(this.getSigningCredential(), securityParametersContext, samlMetadataContext.getRoleDescriptor());
        return samlPeerEntityContext;
    }

    private List<SamlIdpSpSession> _getSamlIdpSpSessions(String idpSessionIndex) throws Exception {
        SamlSpSession samlSpSession = this.samlSpSessionLocalService.getSamlSpSessionBySessionIndex(CompanyThreadLocal.getCompanyId().longValue(), idpSessionIndex);
        SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSsoByUserId(samlSpSession.getUserId());
        return this._samlIdpSpSessionLocalService.getSamlIdpSpSessions(samlIdpSsoSession.getSamlIdpSsoSessionId());
    }

    private String _getSAMLPeerEntityBinding(MessageContext<?> messageContext) {
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, false);
        Endpoint endpoint = samlPeerEndpointContext.getEndpoint();
        return endpoint.getBinding();
    }

    private String _getSAMLPeerEntityLocation(MessageContext<?> messageContext) {
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, false);
        Endpoint endpoint = samlPeerEndpointContext.getEndpoint();
        return endpoint.getLocation();
    }

    private SamlSloContext _getSamlSloContext(HttpServletRequest httpServletRequest, MessageContext<?> messageContext) {
        SamlIdpSsoSession samlIdpSsoSession;
        InOutOperationContext inOutOperationContext;
        MessageContext inboundMessageContext;
        LogoutRequest logoutRequest;
        List sessionIndexes;
        HttpSession httpSession = httpServletRequest.getSession();
        SamlSloContext samlSloContext = (SamlSloContext)httpSession.getAttribute("SAML_SLO_CONTEXT");
        String samlSsoSessionId = this.getSamlSsoSessionId(httpServletRequest);
        if (messageContext != null && !(sessionIndexes = (logoutRequest = (LogoutRequest)(inboundMessageContext = (inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class)).getInboundMessageContext()).getMessage()).getSessionIndexes()).isEmpty()) {
            SessionIndex sessionIndex = (SessionIndex)sessionIndexes.get(0);
            samlSsoSessionId = sessionIndex.getSessionIndex();
        }
        if (samlSloContext == null && Validator.isNotNull((String)samlSsoSessionId) && (samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSso(samlSsoSessionId)) != null) {
            samlSloContext = new SamlSloContext(samlIdpSsoSession, messageContext);
            samlSloContext.setSamlSsoSessionId(samlSsoSessionId);
            if (messageContext != null) {
                SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
                samlSloContext.setRelayState(samlBindingContext.getRelayState());
            }
            samlSloContext.setUserId(this.portal.getUserId(httpServletRequest));
            httpSession.setAttribute("SAML_SLO_CONTEXT", (Object)samlSloContext);
        }
        return samlSloContext;
    }

    private void _initiateIdpSingleLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SamlSloContext samlSloContext = this._getSamlSloContext(httpServletRequest, null);
        if (samlSloContext != null) {
            String redirect = StringBundler.concat((String[])new String[]{this.portal.getPortalURL(httpServletRequest), this.portal.getPathMain(), "/portal/saml/slo_logout"});
            httpServletResponse.sendRedirect(redirect);
        } else {
            this._redirectToLogout(httpServletRequest, httpServletResponse);
        }
    }

    private boolean _isIdpSpConnection(String entityId) {
        try {
            this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(CompanyThreadLocal.getCompanyId().longValue(), entityId);
            return true;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    private boolean _isSpIdPConnection(String entityId) {
        try {
            this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(CompanyThreadLocal.getCompanyId().longValue(), entityId);
            return true;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    private void _performIdpFinishLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlSloContext samlSloContext) throws Exception {
        if (samlSloContext.getMessageContext() != null) {
            String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
            for (SamlSloRequestInfo samlRequestInfo : samlSloContext.getSamlSloRequestInfos()) {
                String samlRequestInfoStatusCode = samlRequestInfo.getStatusCode();
                if (samlRequestInfoStatusCode.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) continue;
                statusCode = "urn:oasis:names:tc:SAML:2.0:status:PartialLogout";
                break;
            }
            this._sendIdpLogoutResponse(httpServletRequest, httpServletResponse, statusCode, samlSloContext);
        } else {
            this._redirectToLogout(httpServletRequest, httpServletResponse);
        }
    }

    private void _performIdpStatus(HttpServletResponse httpServletResponse, SamlSloContext samlSloContext) throws Exception {
        for (SamlSloRequestInfo samlRequestInfo : samlSloContext.getSamlSloRequestInfos()) {
            DateTime initiateDateTime;
            DateTime expireDateTime;
            int status = samlRequestInfo.getStatus();
            if (status != 1 || !(expireDateTime = (initiateDateTime = samlRequestInfo.getInitiateTime()).plusSeconds(10)).isBeforeNow()) continue;
            samlRequestInfo.setStatus(5);
            samlRequestInfo.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
        }
        httpServletResponse.setContentType("text/javascript");
        PrintWriter writer = httpServletResponse.getWriter();
        JSONObject jsonObject = samlSloContext.toJSONObject();
        ((Writer)writer).write(jsonObject.toString());
    }

    private void _processIbLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String idpSessionIndex) throws Exception {
        List<SamlIdpSpSession> samlIdpSpSessions = this._getSamlIdpSpSessions(idpSessionIndex);
        if (!samlIdpSpSessions.isEmpty()) {
            SamlIdpSpSession samlIdpSpSession = this._samlIdpSpSessionLocalService.deleteSamlIdpSpSession(samlIdpSpSessions.get(0));
            this._sendIbLogoutRequest(httpServletRequest, httpServletResponse, samlIdpSpSession, idpSessionIndex);
        } else {
            MessageContext<?> messageContext = null;
            SamlIbSloMessage samlIbSloMessage = this._samlIbSloMessageLocalService.getSamlIbSloMessageBySamlIdpSessionIndex(idpSessionIndex);
            LogoutRequest logoutRequest = (LogoutRequest)OpenSamlUtil.unmarshall(samlIbSloMessage.getLogoutRequestXml());
            Issuer issuer = logoutRequest.getIssuer();
            messageContext = !Objects.equals(issuer.getValue(), samlIbSloMessage.getSamlIdpEntityId()) ? this._buildIbLogoutRequestMessageContext(httpServletRequest, httpServletResponse, logoutRequest, samlIbSloMessage.getSamlIdpEntityId()) : this._buildIbLogoutResponseMessageContext(httpServletRequest, httpServletResponse, logoutRequest, samlIbSloMessage.getSamlIdpEntityId());
            this.sendSamlMessage(messageContext, httpServletResponse);
            this._samlIbSloMessageLocalService.deleteSamlIbSloMessage(samlIbSloMessage);
        }
    }

    private void _processIdpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        SamlSloContext samlSloContext = this._getSamlSloContext(httpServletRequest, messageContext);
        if (samlSloContext == null) {
            this._sendIdpLogoutResponse(httpServletRequest, httpServletResponse, "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", new SamlSloContext(null, messageContext));
            return;
        }
        Set<String> samlSpEntityIds = samlSloContext.getSamlSpEntityIds();
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        String binding = samlBindingContext.getBindingUri();
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            this._sendIdpLogoutResponse(httpServletRequest, httpServletResponse, "urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding", samlSloContext);
        } else if (!samlSpEntityIds.isEmpty()) {
            this._initiateIdpSingleLogout(httpServletRequest, httpServletResponse);
        } else {
            this._sendIdpLogoutResponse(httpServletRequest, httpServletResponse, "urn:oasis:names:tc:SAML:2.0:status:Success", samlSloContext);
        }
    }

    private void _processIdpLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        SamlSloContext samlSloContext = this._getSamlSloContext(httpServletRequest, null);
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        if (samlSloContext == null) {
            throw new UnsolicitedLogoutResponseException("Received logout response from " + samlPeerEntityContext.getEntityId() + " without an active SSO session");
        }
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        LogoutResponse logoutResponse = (LogoutResponse)inboundMessageContext.getMessage();
        Issuer issuer = logoutResponse.getIssuer();
        String entityId = issuer.getValue();
        SamlSloRequestInfo samlSloRequestInfo = samlSloContext.getSamlSloRequestInfo(entityId);
        if (samlSloRequestInfo == null) {
            throw new UnsolicitedLogoutResponseException("Received unsolicited logout response from " + samlPeerEntityContext.getEntityId());
        }
        Status status = logoutResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        samlSloRequestInfo.setStatusCode(statusCode.getValue());
        httpServletRequest.setAttribute("SAML_SLO_REQUEST_INFO", (Object)samlSloRequestInfo.toJSONObject());
        JspUtil.dispatch((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"/portal/saml/slo_sp_status.jsp", (String)"single-sign-out", (boolean)true);
    }

    private void _processSingleLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIb()) {
            SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            if (this._isIdpSpConnection(samlPeerEntityContext.getEntityId())) {
                this._processIdpLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
            } else {
                this._processSpLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
            }
        } else if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this._processIdpLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this._processSpLogoutRequest(httpServletRequest, httpServletResponse, messageContext);
        }
    }

    private void _processSingleLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        if (this.samlProviderConfigurationHelper.isRoleIb()) {
            SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            String relayState = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"RelayState");
            if (Validator.isNotNull((String)relayState)) {
                this._processIbLogoutResponse(httpServletRequest, httpServletResponse, relayState);
            } else if (this._isSpIdPConnection(samlPeerEntityContext.getEntityId())) {
                this._processSpLogoutResponse(httpServletRequest, httpServletResponse);
            } else {
                this._processIdpLogoutResponse(httpServletRequest, httpServletResponse, messageContext);
            }
        } else if (this.samlProviderConfigurationHelper.isRoleIdp()) {
            this._processIdpLogoutResponse(httpServletRequest, httpServletResponse, messageContext);
        } else if (this.samlProviderConfigurationHelper.isRoleSp()) {
            this._processSpLogoutResponse(httpServletRequest, httpServletResponse);
        }
    }

    private void _processSpLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MessageContext<?> messageContext) throws Exception {
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        LogoutRequest logoutRequest = (LogoutRequest)inboundMessageContext.getMessage();
        NameID nameID = logoutRequest.getNameID();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        List sessionIndexes = TransformUtil.transform((Collection)logoutRequest.getSessionIndexes(), SessionIndex::getSessionIndex);
        String statusCodeURI = this._terminateSamlSpSessions(nameID.getFormat(), nameID.getNameQualifier(), nameID.getSPNameQualifier(), nameID.getValue(), samlPeerEntityContext.getEntityId(), sessionIndexes);
        if (Objects.equals(statusCodeURI, "urn:oasis:names:tc:SAML:2.0:status:Success") && this.samlProviderConfigurationHelper.isRoleIb()) {
            List<SamlIdpSpSession> samlIdpSpSessions = this._getSamlIdpSpSessions((String)sessionIndexes.get(0));
            SamlIdpSpSession samlIdpSpSession = this._samlIdpSpSessionLocalService.deleteSamlIdpSpSession(samlIdpSpSessions.get(0));
            this._samlIbSloMessageLocalService.addSamlIbSloMessage(samlIdpSpSession.getCompanyId(), samlPeerEntityContext.getEntityId(), OpenSamlUtil.marshall((XMLObject)logoutRequest), (String)sessionIndexes.get(0));
            this._sendIbLogoutRequest(httpServletRequest, httpServletResponse, samlIdpSpSession, (String)sessionIndexes.get(0));
            return;
        }
        this._buildInOutOperationContext(inOutOperationContext, logoutRequest, messageContext, statusCodeURI);
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    private void _processSpLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this._redirectToLogout(httpServletRequest, httpServletResponse);
    }

    private void _redirectToLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String relayState;
        if (!this.samlProviderConfigurationHelper.isRoleSp()) {
            this.terminateSsoSession(httpServletRequest, httpServletResponse);
        }
        if (Validator.isNotNull((String)(relayState = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"RelayState")))) {
            httpServletResponse.sendRedirect(this.portal.escapeRedirect(StringBundler.concat((String[])new String[]{relayState, this.portal.getPathMain(), "/portal/logout"})));
        } else {
            httpServletResponse.sendRedirect(StringBundler.concat((String[])new String[]{this.portal.getPortalURL(httpServletRequest), this.portal.getPathMain(), "/portal/logout"}));
        }
    }

    private void _sendAsyncLogoutRequest(HttpServletResponse httpServletResponse, MessageContext<LogoutRequest> messageContext, String samlSsoSessionId) throws Exception {
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        logoutRequest.setDestination(this._getSAMLPeerEntityLocation(messageContext));
        logoutRequest.setID(this.generateIdentifier(20));
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        logoutRequest.setIssuer(OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId()));
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class);
        logoutRequest.setNameID(samlSubjectNameIdentifierContext.getSAML2SubjectNameID());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this._addSessionIndex(logoutRequest, samlSsoSessionId);
        messageContext.setMessage((Object)logoutRequest);
        Credential credential = this.getSigningCredential();
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, true);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        OpenSamlUtil.signObject((SignableSAMLObject)logoutRequest, credential, samlMetadataContext.getRoleDescriptor());
        SamlBinding samlBinding = this.samlBindingProvider.getSamlBinding(this._getSAMLPeerEntityBinding(messageContext));
        Supplier<HttpServletResponseMessageEncoder> httpServletResponseMessageEncoderSupplier = samlBinding.getHttpServletResponseMessageEncoderSupplier();
        HttpServletResponseMessageEncoder httpServletResponseMessageEncoder = httpServletResponseMessageEncoderSupplier.get();
        OpenSamlUtil.prepareSecurityParametersContext(credential, (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class), samlMetadataContext.getRoleDescriptor());
        httpServletResponseMessageEncoder.setHttpServletResponse(httpServletResponse);
        httpServletResponseMessageEncoder.setMessageContext(messageContext);
        httpServletResponseMessageEncoder.initialize();
        httpServletResponseMessageEncoder.encode();
    }

    private void _sendIbLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SamlIdpSpSession samlIdpSpSession, String sessionIndex) throws Exception {
        SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.getSamlPeerBinding(samlIdpSpSession.getSamlPeerBindingId());
        MessageContext<LogoutRequest> messageContext = this._buildLogoutRequestMessageContext(httpServletRequest, httpServletResponse, samlPeerBinding.getSamlPeerEntityId(), samlPeerBinding);
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        samlBindingContext.setRelayState(sessionIndex);
        SamlIdpSsoSession samlIdpSsoSession = this._samlIdpSsoSessionLocalService.fetchSamlIdpSsoSession(samlIdpSpSession.getSamlIdpSsoSessionId());
        this._sendAsyncLogoutRequest(httpServletResponse, messageContext, samlIdpSsoSession.getSamlIdpSsoSessionKey());
    }

    private void _sendIdpLogoutResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String statusCodeURI, SamlSloContext samlSloContext) throws Exception {
        MessageContext<?> messageContext = samlSloContext.getMessageContext();
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SAMLBindingContext samlBindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class);
        SingleLogoutService singleLogoutService = SamlUtil.resolveSingleLogoutService((SSODescriptor)samlPeerMetadataContext.getRoleDescriptor(), samlBindingContext.getBindingUri());
        LogoutRequest logoutRequest = (LogoutRequest)inboundMessageContext.getMessage();
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        outboundMessageContext.setMessage((Object)this._buildLogoutResponse(singleLogoutService.getLocation(), samlSelfEntityContext.getEntityId(), logoutRequest.getID(), statusCodeURI));
        outboundMessageContext.addSubcontext((BaseContext)samlPeerEntityContext);
        samlBindingContext = (SAMLBindingContext)outboundMessageContext.getSubcontext(SAMLBindingContext.class, true);
        samlBindingContext.setRelayState(samlSloContext.getRelayState());
        OpenSamlUtil.prepareSecurityParametersContext(this.getSigningCredential(), (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true), samlPeerMetadataContext.getRoleDescriptor());
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)outboundMessageContext.getSubcontext(SAMLProtocolContext.class, true);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SAMLEndpointContext samlPeerEndpointContext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        samlPeerEndpointContext.setEndpoint((Endpoint)singleLogoutService);
        if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding")) {
            this.terminateSsoSession(httpServletRequest, httpServletResponse);
            this.logout(httpServletRequest, httpServletResponse);
        }
        this.sendSamlMessage(messageContext, httpServletResponse);
    }

    private String _sendSyncLogoutRequest(MessageContext<?> messageContext, SamlSloContext samlSloContext) throws Exception {
        LogoutRequest logoutRequest = OpenSamlUtil.buildLogoutRequest();
        logoutRequest.setDestination(this._getSAMLPeerEntityLocation(messageContext));
        logoutRequest.setID(this.generateIdentifier(20));
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        SAMLSelfEntityContext samlSelfEntityContext = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        logoutRequest.setIssuer(OpenSamlUtil.buildIssuer(samlSelfEntityContext.getEntityId()));
        SAMLSubjectNameIdentifierContext samlSubjectNameIdentifierContext = (SAMLSubjectNameIdentifierContext)messageContext.getSubcontext(SAMLSubjectNameIdentifierContext.class);
        logoutRequest.setNameID(samlSubjectNameIdentifierContext.getSAML2SubjectNameID());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        this._addSessionIndex(logoutRequest, samlSloContext.getSamlSsoSessionId());
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class);
        MessageContext outboundMessageContext = inOutOperationContext.getOutboundMessageContext();
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLEndpointContext samlPeerEndpointSubcontext = (SAMLEndpointContext)samlPeerEntityContext.getSubcontext(SAMLEndpointContext.class);
        outboundMessageContext.addSubcontext((BaseContext)samlPeerEndpointSubcontext);
        outboundMessageContext.setMessage((Object)logoutRequest);
        Credential credential = this.getSigningCredential();
        SAMLMetadataContext samlPeerMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        OpenSamlUtil.prepareSecurityParametersContext(credential, (SecurityParametersContext)outboundMessageContext.getSubcontext(SecurityParametersContext.class, true), samlPeerMetadataContext.getRoleDescriptor());
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)outboundMessageContext.getSubcontext(SAMLProtocolContext.class);
        samlProtocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        OpenSamlUtil.signObject((SignableSAMLObject)logoutRequest, credential, samlPeerMetadataContext.getRoleDescriptor());
        final SamlBinding samlBinding = this.samlBindingProvider.getSamlBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        PipelineFactoryHttpSOAPClient pipelineFactoryHttpSOAPClient = new PipelineFactoryHttpSOAPClient();
        pipelineFactoryHttpSOAPClient.setPipelineFactory((HttpClientMessagePipelineFactory)new HttpClientMessagePipelineFactory<Object, Object>(){

            @Nonnull
            public HttpClientMessagePipeline<Object, Object> newInstance() {
                Supplier<HttpServletResponseMessageEncoder> httpServletResponseMessageEncoderSupplier = samlBinding.getHttpServletResponseMessageEncoderSupplier();
                Supplier<HttpServletRequestMessageDecoder> httpServletResponseMessageDecoder = samlBinding.getHttpServletRequestMessageDecoderSupplier();
                return new BasicHttpClientMessagePipeline((MessageEncoder)httpServletResponseMessageEncoderSupplier.get(), (MessageDecoder)httpServletResponseMessageDecoder.get());
            }

            @Nonnull
            public HttpClientMessagePipeline<Object, Object> newInstance(@Nullable String pipelineName) {
                return this.newInstance();
            }
        });
        pipelineFactoryHttpSOAPClient.setHttpClient(this._httpClientFactory.getHttpClient());
        pipelineFactoryHttpSOAPClient.initialize();
        pipelineFactoryHttpSOAPClient.send(this._getSAMLPeerEntityLocation(messageContext), inOutOperationContext);
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        LogoutResponse logoutResponse = (LogoutResponse)inboundMessageContext.getMessage();
        Status status = logoutResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        return statusCode.getValue();
    }

    private String _terminateSamlSpSessions(String nameIDFormat, String nameIDNameQualifier, String nameIDSPNameQualifier, String nameIDValue, String samlPeerEntityId, List<String> sessionIndexes) throws Exception {
        String statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal";
        if (sessionIndexes.isEmpty()) {
            List samlSpSessions = this.samlSpSessionLocalService.getSamlSpSessions(CompanyThreadLocal.getCompanyId().longValue(), nameIDFormat, nameIDNameQualifier, nameIDSPNameQualifier, nameIDValue, samlPeerEntityId);
            if (!samlSpSessions.isEmpty()) {
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:Success";
            }
            for (SamlSpSession samlSpSession : samlSpSessions) {
                samlSpSession.setTerminated(true);
                this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession);
            }
        }
        for (String sessionIndex : sessionIndexes) {
            List samlSpSessions = this.samlSpSessionLocalService.fetchSamlSpSessionsBySessionIndex(CompanyThreadLocal.getCompanyId().longValue(), sessionIndex);
            for (SamlSpSession samlSpSession : samlSpSessions) {
                SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.getSamlPeerBinding(samlSpSession.getSamlPeerBindingId());
                if (!Objects.equals(samlPeerBinding.getSamlNameIdValue(), nameIDValue) || !Objects.equals(samlPeerBinding.getSamlNameIdFormat(), nameIDFormat)) continue;
                statusCodeURI = "urn:oasis:names:tc:SAML:2.0:status:Success";
                samlSpSession.setTerminated(true);
                this.samlSpSessionLocalService.updateSamlSpSession(samlSpSession);
            }
        }
        return statusCodeURI;
    }
}

