/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util;

import java.io.InputStream;

public class ClassUtils {
    private ClassUtils() {
    }

    public static Class getClass(String clazz) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return Class.forName(clazz, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(clazz);
    }

    public static Object getNewInstance(String clazz) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassUtils.getClass(clazz).newInstance();
    }

    public static InputStream getResourceAsStream(Class claz, String name) {
        InputStream result = null;
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = claz.getClassLoader();
            result = classLoader.getResourceAsStream(name);
        } else {
            result = classLoader.getResourceAsStream(name);
            if (result == null && (classLoader = claz.getClassLoader()) != null) {
                result = classLoader.getResourceAsStream(name);
            }
        }
        return result;
    }
}

