/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.certificate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.runtime.certificate.CertificateEntityId;
import com.liferay.saml.runtime.certificate.CertificateTool;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={CertificateTool.class})
public class CertificateToolImpl
implements CertificateTool {
    /*
     * Enabled aggressive exception aggregation
     */
    public X509Certificate generateCertificate(KeyPair keyPair, CertificateEntityId issuerCertificateEntityId, CertificateEntityId subjectCertificateEntityId, Date startDate, Date endDate, String signatureAlgorithm) throws CertificateException {
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        PublicKey publicKey = keyPair.getPublic();
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());){
            X509Certificate x509Certificate;
            try (ASN1InputStream asn1InputStream = new ASN1InputStream(byteArrayInputStream);){
                X500Name issuerX500Name = this._createX500Name(issuerCertificateEntityId);
                X500Name subjectX500Name = this._createX500Name(subjectCertificateEntityId);
                X509v1CertificateBuilder x509v1CertificateBuilder = new X509v1CertificateBuilder(issuerX500Name, BigInteger.valueOf(System.currentTimeMillis()), startDate, endDate, subjectX500Name, new SubjectPublicKeyInfo((ASN1Sequence)asn1InputStream.readObject()));
                JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(signatureAlgorithm);
                x509Certificate = jcaX509CertificateConverter.getCertificate(x509v1CertificateBuilder.build(jcaContentSignerBuilder.build(keyPair.getPrivate())));
            }
            return x509Certificate;
        }
        catch (Exception exception) {
            throw new CertificateException(exception);
        }
    }

    public KeyPair generateKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }

    public String getFingerprint(String algorithm, X509Certificate x509Certificate) throws CertificateException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(x509Certificate.getEncoded());
        byte[] digest = messageDigest.digest();
        StringBundler sb = new StringBundler(digest.length * 2 - 1);
        for (int i = 0; i < digest.length; ++i) {
            String hex = String.format("%02X", digest[i]);
            sb.append(hex);
            if (i + 1 >= digest.length) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public String getSerialNumber(X509Certificate x509Certificate) {
        BigInteger serialNumber = x509Certificate.getSerialNumber();
        byte[] bytes = serialNumber.toByteArray();
        StringBundler sb = new StringBundler(bytes.length);
        for (byte b : bytes) {
            sb.append(Integer.toHexString(b & 0xFF));
        }
        return sb.toString();
    }

    public String getSubjectName(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        Principal principal = x509Certificate.getSubjectDN();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    private X500Name _createX500Name(CertificateEntityId certificateEntityId) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        if (Validator.isNotNull((String)certificateEntityId.getCommonName())) {
            x500NameBuilder.addRDN(BCStyle.CN, certificateEntityId.getCommonName());
        }
        if (Validator.isNotNull((String)certificateEntityId.getOrganization())) {
            x500NameBuilder.addRDN(BCStyle.O, certificateEntityId.getOrganization());
        }
        if (Validator.isNotNull((String)certificateEntityId.getOrganizationUnit())) {
            x500NameBuilder.addRDN(BCStyle.OU, certificateEntityId.getOrganizationUnit());
        }
        if (Validator.isNotNull((String)certificateEntityId.getLocality())) {
            x500NameBuilder.addRDN(BCStyle.L, certificateEntityId.getLocality());
        }
        if (Validator.isNotNull((String)certificateEntityId.getState())) {
            x500NameBuilder.addRDN(BCStyle.ST, certificateEntityId.getState());
        }
        if (Validator.isAlphanumericName((String)certificateEntityId.getCountry())) {
            x500NameBuilder.addRDN(BCStyle.C, certificateEntityId.getCountry());
        }
        return x500NameBuilder.build();
    }
}

