/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.log.internal.Log4jUtil;

public class SimpleLog4JLogSystem
implements LogSystem {
    private RuntimeServices rsvc = null;
    private RollingFileAppender appender = null;
    protected Logger logger = null;
    private static final String _FQCN = AbstractLogger.class.getName();

    @Override
    public void init(RuntimeServices rs) {
        this.rsvc = rs;
        String categoryname = (String)this.rsvc.getProperty("runtime.log.logsystem.log4j.category");
        if (categoryname != null) {
            this.logger = (Logger)LogManager.getLogger((String)categoryname);
            this.logVelocityMessage(0, "SimpleLog4JLogSystem using category '" + categoryname + "'");
            return;
        }
        String logfile = this.rsvc.getString("runtime.log");
        try {
            this.internalInit(logfile);
            this.logVelocityMessage(0, "SimpleLog4JLogSystem initialized using logfile '" + logfile + "'");
        }
        catch (Exception e) {
            System.err.println("PANIC : error configuring SimpleLog4JLogSystem : " + e);
        }
    }

    private void internalInit(String logfile) throws Exception {
        String loggerName = this.getClass().getName();
        this.logger = (Logger)LogManager.getLogger((String)loggerName);
        Log4jUtil.setLevel(loggerName, Level.DEBUG);
        LoggerConfig loggerConfig = this.logger.get();
        loggerConfig.setAdditive(false);
        this.appender = Log4jUtil.createRollingFileAppender(logfile);
        this.logger.addAppender((Appender)this.appender);
    }

    @Override
    public void logVelocityMessage(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.logIfEnabled(_FQCN, Level.WARN, null, (Object)message, null);
                break;
            }
            case 1: {
                this.logger.logIfEnabled(_FQCN, Level.INFO, null, (Object)message, null);
                break;
            }
            case 3: {
                this.logger.logIfEnabled(_FQCN, Level.ERROR, null, (Object)message, null);
                break;
            }
            default: {
                this.logger.logIfEnabled(_FQCN, Level.DEBUG, null, (Object)message, null);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
        if (this.appender != null) {
            this.logger.removeAppender((Appender)this.appender);
            this.appender.stop();
            this.appender = null;
        }
    }
}

