/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.helper;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.saml.helper.RelayStateHelper;
import java.io.Serializable;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RelayStateHelper.class})
public class RelayStateHelperImpl
implements RelayStateHelper {
    private PortalCache<String, String> _redirectsToRelayStateTokensPortalCache;
    private PortalCache<String, String> _relayStateTokensToRedirectsPortalCache;
    @Reference
    private SingleVMPool _singleVMPool;

    public String getRedirectFromRelayStateToken(String relayStateToken) {
        if (Validator.isNotNull((String)relayStateToken) && relayStateToken.startsWith("RDR_")) {
            return (String)this._relayStateTokensToRedirectsPortalCache.get((Serializable)((Object)relayStateToken));
        }
        return relayStateToken;
    }

    public String getRelayStateTokenFromRedirect(String redirect) {
        String relayStateToken = (String)this._redirectsToRelayStateTokensPortalCache.get((Serializable)((Object)redirect));
        if (relayStateToken != null) {
            String mappedRedirect = (String)this._relayStateTokensToRedirectsPortalCache.get((Serializable)((Object)relayStateToken));
            if (Objects.equals(redirect, mappedRedirect)) {
                return relayStateToken;
            }
            this._redirectsToRelayStateTokensPortalCache.remove((Serializable)((Object)redirect));
            this._relayStateTokensToRedirectsPortalCache.remove((Serializable)((Object)relayStateToken));
        }
        relayStateToken = "RDR_" + PortalUUIDUtil.generate();
        this._redirectsToRelayStateTokensPortalCache.put((Serializable)((Object)redirect), (Object)relayStateToken);
        this._relayStateTokensToRedirectsPortalCache.put((Serializable)((Object)relayStateToken), (Object)redirect);
        return relayStateToken;
    }

    @Activate
    protected void activate() {
        this._redirectsToRelayStateTokensPortalCache = this._singleVMPool.getPortalCache(RelayStateHelperImpl.class.getName() + "#_redirectsToRelayStateTokens");
        this._relayStateTokensToRedirectsPortalCache = this._singleVMPool.getPortalCache(RelayStateHelperImpl.class.getName() + "#_relayStateTokensToRedirects");
    }
}

