/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.metadata;

import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.util.KeyStoreUtil;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import com.liferay.saml.runtime.exception.CredentialAuthException;
import com.liferay.saml.runtime.exception.CredentialException;
import com.liferay.saml.runtime.exception.EntityIdException;
import com.liferay.saml.runtime.metadata.LocalEntityManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.X509Credential;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlKeyStoreManagerConfiguration"}, service={LocalEntityManager.class})
public class KeyStoreLocalEntityManager
implements LocalEntityManager {
    @Reference
    private CredentialResolver _credentialResolver;
    @Reference(name="KeyStoreManager", target="(default=true)")
    private KeyStoreManager _keyStoreManager;
    @Reference
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;

    public void authenticateLocalEntityCertificate(String certificateKeyPassword, LocalEntityManager.CertificateUsage certificateUsage, String entityId) throws CredentialAuthException, CredentialException {
        KeyStore.Entry entry = null;
        entry = certificateUsage == LocalEntityManager.CertificateUsage.ENCRYPTION ? KeyStoreUtil.getKeyStoreEntry(KeyStoreUtil.getAlias(entityId, UsageType.ENCRYPTION), certificateKeyPassword, this._keyStoreManager) : KeyStoreUtil.getKeyStoreEntry(KeyStoreUtil.getAlias(entityId, UsageType.SIGNING), certificateKeyPassword, this._keyStoreManager);
        if (entry == null) {
            throw new CredentialException("Certificate not found");
        }
    }

    public void deleteLocalEntityCertificate(LocalEntityManager.CertificateUsage certificateUsage) throws KeyStoreException {
        KeyStore keyStore = this._keyStoreManager.getKeyStore();
        keyStore.deleteEntry(KeyStoreUtil.getAlias(this.getLocalEntityId(), this._getUsageType(certificateUsage)));
        try {
            this._keyStoreManager.saveKeyStore(keyStore);
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception);
        }
    }

    public String getEncodedLocalEntityCertificate(LocalEntityManager.CertificateUsage certificateUsage) throws SamlException {
        try {
            X509Certificate x509Certificate = this.getLocalEntityCertificate(certificateUsage);
            if (x509Certificate == null) {
                return null;
            }
            return Base64.encode((byte[])x509Certificate.getEncoded(), (int)76);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SamlException((Throwable)certificateEncodingException);
        }
    }

    public X509Certificate getLocalEntityCertificate(LocalEntityManager.CertificateUsage certificateUsage) throws SamlException {
        UsageType usageType = this._getUsageType(certificateUsage);
        if (usageType == null) {
            return null;
        }
        String entityId = this.getLocalEntityId();
        if (Validator.isBlank((String)entityId)) {
            throw new SamlException((Throwable)new EntityIdException("An Entity ID must be configured"));
        }
        UsageCriterion usageCriterion = new UsageCriterion(usageType);
        try {
            X509Credential x509Credential = (X509Credential)this._credentialResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId), usageCriterion}));
            if (x509Credential == null) {
                return null;
            }
            return x509Credential.getEntityCertificate();
        }
        catch (ResolverException resolverException) {
            throw new SamlException((Throwable)resolverException);
        }
    }

    public String getLocalEntityId() {
        SamlProviderConfiguration samlProviderConfiguration = this._samlProviderConfigurationHelper.getSamlProviderConfiguration();
        return samlProviderConfiguration.entityId();
    }

    public boolean hasDefaultIdpRole() {
        List samlSpIdpConnections = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnections(CompanyThreadLocal.getCompanyId().longValue());
        return !samlSpIdpConnections.isEmpty();
    }

    public void storeLocalEntityCertificate(PrivateKey privateKey, String certificateKeyPassword, X509Certificate x509Certificate, LocalEntityManager.CertificateUsage certificateUsage) throws Exception {
        KeyStore keyStore = this._keyStoreManager.getKeyStore();
        keyStore.setEntry(KeyStoreUtil.getAlias(this.getLocalEntityId(), this._getUsageType(certificateUsage)), new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{x509Certificate}), new KeyStore.PasswordProtection(certificateKeyPassword.toCharArray()));
        this._keyStoreManager.saveKeyStore(keyStore);
    }

    private UsageType _getUsageType(LocalEntityManager.CertificateUsage certificateUsage) {
        UsageType usageType = null;
        if (certificateUsage == LocalEntityManager.CertificateUsage.ENCRYPTION) {
            usageType = UsageType.ENCRYPTION;
        } else if (certificateUsage == LocalEntityManager.CertificateUsage.SIGNING) {
            usageType = UsageType.SIGNING;
        }
        return usageType;
    }
}

