/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.log.internal.Log4jUtil;

public class Log4JLogChute
implements LogChute {
    public static final String RUNTIME_LOG_LOG4J_LOGGER = "runtime.log.logsystem.log4j.logger";
    public static final String RUNTIME_LOG_LOG4J_LOGGER_LEVEL = "runtime.log.logsystem.log4j.logger.level";
    private RuntimeServices rsvc = null;
    private RollingFileAppender appender = null;
    protected Logger logger = null;
    private static final String _FQCN = AbstractLogger.class.getName();

    @Override
    public void init(RuntimeServices rs) throws Exception {
        this.rsvc = rs;
        String name = (String)this.rsvc.getProperty(RUNTIME_LOG_LOG4J_LOGGER);
        if (name != null) {
            this.logger = (Logger)LogManager.getLogger((String)name);
            this.log(0, "Log4JLogChute using logger '" + name + '\'');
        } else {
            this.logger = (Logger)LogManager.getLogger((String)this.getClass().getName());
            String file = this.rsvc.getString("runtime.log");
            if (file != null && file.length() > 0) {
                this.appender = Log4jUtil.createRollingFileAppender(file);
                this.logger.addAppender((Appender)this.appender);
                LoggerConfig loggerConfig = this.logger.get();
                loggerConfig.setAdditive(false);
                this.log(0, "Log4JLogChute initialized using file '" + file + '\'');
            }
        }
        String lvl = this.rsvc.getString(RUNTIME_LOG_LOG4J_LOGGER_LEVEL);
        if (lvl != null) {
            Log4jUtil.setLevel(this.logger.getName(), Level.toLevel((String)lvl));
        }
    }

    @Override
    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.logIfEnabled(_FQCN, Level.WARN, null, (Object)message, null);
                break;
            }
            case 1: {
                this.logger.logIfEnabled(_FQCN, Level.INFO, null, (Object)message, null);
                break;
            }
            case -1: {
                this.logger.logIfEnabled(_FQCN, Level.TRACE, null, (Object)message, null);
                break;
            }
            case 3: {
                this.logger.logIfEnabled(_FQCN, Level.ERROR, null, (Object)message, null);
                break;
            }
            default: {
                this.logger.logIfEnabled(_FQCN, Level.DEBUG, null, (Object)message, null);
            }
        }
    }

    @Override
    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.logger.logIfEnabled(_FQCN, Level.WARN, null, (Object)message, t);
                break;
            }
            case 1: {
                this.logger.logIfEnabled(_FQCN, Level.INFO, null, (Object)message, t);
                break;
            }
            case -1: {
                this.logger.logIfEnabled(_FQCN, Level.TRACE, null, (Object)message, t);
                break;
            }
            case 3: {
                this.logger.logIfEnabled(_FQCN, Level.ERROR, null, (Object)message, t);
                break;
            }
            default: {
                this.logger.logIfEnabled(_FQCN, Level.DEBUG, null, (Object)message, t);
            }
        }
    }

    @Override
    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 0: {
                return this.logger.isDebugEnabled();
            }
            case 1: {
                return this.logger.isInfoEnabled();
            }
            case -1: {
                return this.logger.isTraceEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: {
                return this.logger.isErrorEnabled();
            }
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
        if (this.appender != null) {
            this.logger.removeAppender((Appender)this.appender);
            this.appender.stop();
            this.appender = null;
        }
    }
}

