/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CachingChainingMetadataResolver
extends AbstractMetadataResolver {
    private final List<MetadataResolver> _metadataResolvers = new CopyOnWriteArrayList<MetadataResolver>();
    private final Map<String, MetadataResolver> _metadataResolversMap = new ConcurrentHashMap<String, MetadataResolver>();
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock(true);
    private final ServiceTracker<MetadataResolver, MetadataResolver> _serviceTracker;

    public CachingChainingMetadataResolver(final BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, MetadataResolver.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<MetadataResolver, MetadataResolver>(){

            public MetadataResolver addingService(ServiceReference<MetadataResolver> serviceReference) {
                MetadataResolver metadataResolver = (MetadataResolver)bundleContext.getService(serviceReference);
                CachingChainingMetadataResolver.this.addMetadataResolver(metadataResolver);
                return metadataResolver;
            }

            public void modifiedService(ServiceReference<MetadataResolver> serviceReference, MetadataResolver metadataResolver) {
            }

            public void removedService(ServiceReference<MetadataResolver> serviceReference, MetadataResolver metadataResolver) {
                CachingChainingMetadataResolver.this.removeMetadataResolver(metadataResolver);
                bundleContext.ungetService(serviceReference);
            }
        });
        this._serviceTracker.open();
    }

    public void addMetadataResolver(MetadataResolver metadataResolver) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            if (metadataResolver != null) {
                metadataResolver.setRequireValidMetadata(this.isRequireValidMetadata());
                this._metadataResolvers.add(metadataResolver);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroy() {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            this._serviceTracker.close();
            this._metadataResolversMap.clear();
            for (MetadataResolver metadataProvider : this._metadataResolvers) {
                if (!(metadataProvider instanceof AbstractMetadataResolver)) continue;
                AbstractMetadataResolver baseMetadataProvider = (AbstractMetadataResolver)metadataProvider;
                baseMetadataProvider.destroy();
            }
            this._metadataResolvers.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public void removeMetadataResolver(MetadataResolver metadataResolver) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            this._metadataResolvers.remove(metadataResolver);
            this._metadataResolversMap.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) throws ResolverException {
        ArrayList entityDescriptors = new ArrayList();
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            for (MetadataResolver metadataResolver : this._metadataResolvers) {
                Iterable iterable = metadataResolver.resolve((Object)criteria);
                iterable.forEach(entityDescriptors::add);
            }
            ArrayList arrayList = entityDescriptors;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        super.setRequireValidMetadata(requireValidMetadata);
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            for (MetadataResolver metadataProvider : this._metadataResolvers) {
                metadataProvider.setRequireValidMetadata(requireValidMetadata);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

