/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.helper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.liferay.portal.kernel.uuid.PortalUUID;
import com.liferay.saml.helper.RelayStateHelper;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RelayStateHelper.class})
public class RelayStateHelperImpl
implements RelayStateHelper {
    @Reference
    private PortalUUID _portalUUID;
    private ConcurrentMap<String, String> _redirectsToRelayStateTokens;
    private ConcurrentMap<String, String> _relayStateTokensToRedirects;

    public String getRedirectFromRelayStateToken(String relayStateToken) {
        return (String)this._relayStateTokensToRedirects.get(relayStateToken);
    }

    public String getRelayStateTokenFromRedirect(String redirect) {
        String relayStateToken = (String)this._redirectsToRelayStateTokens.get(redirect);
        if (relayStateToken != null) {
            String mappedRedirect = (String)this._relayStateTokensToRedirects.get(relayStateToken);
            if (Objects.equals(redirect, mappedRedirect)) {
                return relayStateToken;
            }
            this._redirectsToRelayStateTokens.remove(redirect);
            this._relayStateTokensToRedirects.remove(relayStateToken);
        }
        relayStateToken = this._portalUUID.generate();
        this._redirectsToRelayStateTokens.put(redirect, relayStateToken);
        this._relayStateTokensToRedirects.put(relayStateToken, redirect);
        return relayStateToken;
    }

    @Activate
    protected void activate() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.expireAfterAccess(10L, TimeUnit.MINUTES);
        Cache redirectsToRelayStateTokensCache = cacheBuilder.build();
        Cache relayStateTokensToRedirectsCache = cacheBuilder.build();
        this._redirectsToRelayStateTokens = redirectsToRelayStateTokensCache.asMap();
        this._relayStateTokensToRedirects = relayStateTokensToRedirectsCache.asMap();
    }
}

