/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.saml.opensaml.integration.internal.credential.BaseKeyStoreManagerImpl;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlConfiguration"}, service={KeyStoreManager.class})
public class DLKeyStoreManagerImpl
extends BaseKeyStoreManagerImpl {
    private static final String _SAML_KEYSTORE_PATH = "/saml/keystore.jks";
    private static final Log _log = LogFactoryUtil.getLog(DLKeyStoreManagerImpl.class);
    @Reference(target="(default=true)")
    private Store _store;

    public KeyStore getKeyStore() throws KeyStoreException {
        KeyStore keyStore;
        block19: {
            keyStore = KeyStore.getInstance(this.getSamlKeyStoreType());
            try (InputStream inputStream = this._store.getFileAsStream(this.getCompanyId(), 0L, _SAML_KEYSTORE_PATH, "");){
                String samlKeyStorePassword = this.getSamlKeyStorePassword();
                keyStore.load(inputStream, samlKeyStorePassword.toCharArray());
            }
            catch (NoSuchFileException noSuchFileException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchFileException);
                }
                try {
                    keyStore.load(null, null);
                }
                catch (Exception exception) {
                    String message = "Unable to load blank keystore";
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)message, (Throwable)exception);
                        break block19;
                    }
                    _log.error((Object)message);
                }
            }
            catch (Exception exception) {
                throw new KeyStoreException(StringBundler.concat((Object[])new Object[]{"Unable to load keystore ", this.getCompanyId(), "/", _SAML_KEYSTORE_PATH, ": ", exception.getMessage()}), exception);
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKeyStore(KeyStore keyStore) throws Exception {
        File tempFile = FileUtil.createTempFile((String)"jks");
        try {
            String samlKeyStorePassword = this.getSamlKeyStorePassword();
            keyStore.store(new FileOutputStream(tempFile), samlKeyStorePassword.toCharArray());
            if (this._store.hasFile(this.getCompanyId(), 0L, _SAML_KEYSTORE_PATH, "1.0")) {
                this._store.deleteDirectory(this.getCompanyId(), 0L, _SAML_KEYSTORE_PATH);
            }
            this._store.addFile(this.getCompanyId(), 0L, _SAML_KEYSTORE_PATH, "1.0", (InputStream)new FileInputStream(tempFile));
        }
        finally {
            tempFile.delete();
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) throws Exception {
        this.updateConfigurations(properties);
    }
}

