/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.servlet.profile;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.SamlSloRequestInfo;
import com.liferay.saml.persistence.exception.NoSuchIdpSpConnectionException;
import com.liferay.saml.persistence.model.SamlIdpSpConnection;
import com.liferay.saml.persistence.model.SamlIdpSpSession;
import com.liferay.saml.persistence.model.SamlIdpSsoSession;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import com.liferay.saml.persistence.service.SamlIdpSpSessionLocalService;
import com.liferay.saml.persistence.service.SamlPeerBindingLocalService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;

public class SamlSloContext
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(SamlSloContext.class);
    private final MessageContext<?> _messageContext;
    private String _relayState;
    private final SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;
    private final SamlIdpSpSessionLocalService _samlIdpSpSessionLocalService;
    private final Map<String, SamlSloRequestInfo> _samlRequestInfos;
    private String _samlSsoSessionId;
    private long _userId;
    private final UserLocalService _userLocalService;

    public SamlSloContext(SamlIdpSsoSession samlIdpSsoSession, MessageContext<?> messageContext, SamlIdpSpConnectionLocalService samlIdpSpConnectionLocalService, SamlIdpSpSessionLocalService samlIdpSpSessionLocalService, SamlPeerBindingLocalService samlPeerBindingLocalService, UserLocalService userLocalService) {
        block7: {
            this._samlRequestInfos = new ConcurrentHashMap<String, SamlSloRequestInfo>();
            this._messageContext = messageContext;
            this._samlIdpSpConnectionLocalService = samlIdpSpConnectionLocalService;
            this._samlIdpSpSessionLocalService = samlIdpSpSessionLocalService;
            this._userLocalService = userLocalService;
            if (samlIdpSsoSession == null) {
                return;
            }
            try {
                List samlIdpSpSessions = samlIdpSpSessionLocalService.getSamlIdpSpSessions(samlIdpSsoSession.getSamlIdpSsoSessionId());
                for (SamlIdpSpSession samlIdpSpSession : samlIdpSpSessions) {
                    String name;
                    String samlSpEntityId;
                    SamlPeerBinding samlPeerBinding;
                    block6: {
                        SAMLPeerEntityContext samlPeerEntityContext;
                        this._samlIdpSpSessionLocalService.deleteSamlIdpSpSession(samlIdpSpSession);
                        samlPeerBinding = samlPeerBindingLocalService.getSamlPeerBinding(samlIdpSpSession.getSamlPeerBindingId());
                        samlSpEntityId = samlPeerBinding.getSamlPeerEntityId();
                        if (messageContext != null && samlSpEntityId.equals((samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class)).getEntityId())) continue;
                        name = samlSpEntityId;
                        try {
                            SamlIdpSpConnection samlIdpSpConnection = samlIdpSpConnectionLocalService.getSamlIdpSpConnection(samlIdpSpSession.getCompanyId(), samlSpEntityId);
                            name = samlIdpSpConnection.getName();
                        }
                        catch (NoSuchIdpSpConnectionException noSuchIdpSpConnectionException) {
                            if (!_log.isDebugEnabled()) break block6;
                            _log.debug((Throwable)noSuchIdpSpConnectionException);
                        }
                    }
                    SamlSloRequestInfo samlSloRequestInfo = new SamlSloRequestInfo();
                    samlSloRequestInfo.setName(name);
                    samlSloRequestInfo.setSamlIdpSpSession(samlIdpSpSession);
                    samlSloRequestInfo.setSamlPeerBinding(samlPeerBinding);
                    this._samlRequestInfos.put(samlSpEntityId, samlSloRequestInfo);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Throwable)exception);
            }
        }
    }

    public SamlSloContext(SamlIdpSsoSession samlIdpSsoSession, SamlIdpSpConnectionLocalService samlIdpSpConnectionLocalService, SamlIdpSpSessionLocalService samlIdpSpSessionLocalService, SamlPeerBindingLocalService samlPeerBindingLocalService, UserLocalService userLocalService) {
        this(samlIdpSsoSession, null, samlIdpSpConnectionLocalService, samlIdpSpSessionLocalService, samlPeerBindingLocalService, userLocalService);
    }

    public MessageContext<?> getMessageContext() {
        return this._messageContext;
    }

    public String getRelayState() {
        return this._relayState;
    }

    public SamlSloRequestInfo getSamlSloRequestInfo(String entityId) {
        return this._samlRequestInfos.get(entityId);
    }

    public Set<SamlSloRequestInfo> getSamlSloRequestInfos() {
        return new HashSet<SamlSloRequestInfo>(this._samlRequestInfos.values());
    }

    public Set<String> getSamlSpEntityIds() {
        return this._samlRequestInfos.keySet();
    }

    public String getSamlSsoSessionId() {
        return this._samlSsoSessionId;
    }

    public User getUser() {
        try {
            return this._userLocalService.fetchUserById(this._userId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    public long getUserId() {
        return this._userId;
    }

    public void setRelayState(String relayState) {
        this._relayState = relayState;
    }

    public void setSamlSsoSessionId(String samlSsoSessionId) {
        this._samlSsoSessionId = samlSsoSessionId;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public JSONObject toJSONObject() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (SamlSloRequestInfo samlSloRequestInfo : this._samlRequestInfos.values()) {
            jsonArray.put(samlSloRequestInfo.toJSONObject());
        }
        return JSONUtil.put((String)"samlSloRequestInfos", (Object)jsonArray).put("userId", this.getUserId());
    }
}

