/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.util;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;

public class SamlUtil {
    public static AssertionConsumerService getAssertionConsumerServiceForBinding(SPSSODescriptor spSSODescriptor, String binding) throws ResolverException {
        AssertionConsumerService assertionConsumerService = spSSODescriptor.getDefaultAssertionConsumerService();
        if (binding.equals(assertionConsumerService.getBinding())) {
            return assertionConsumerService;
        }
        List assertionConsumerServices = spSSODescriptor.getAssertionConsumerServices();
        for (AssertionConsumerService curAssertionConsumerService : assertionConsumerServices) {
            if (!binding.equals(curAssertionConsumerService.getBinding())) continue;
            return curAssertionConsumerService;
        }
        throw new ResolverException("Binding " + binding + " is not supported");
    }

    public static Attribute getAttribute(List<Attribute> attributes, String attributeName) {
        for (Attribute attribute : attributes) {
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public static Map<String, List<Serializable>> getAttributesMap(List<Attribute> attributes, Properties attributeMappingsProperties) {
        HashMap<String, List<Serializable>> attributesMap = new HashMap<String, List<Serializable>>();
        for (Attribute attribute : attributes) {
            boolean implicitMapping = false;
            String key = attributeMappingsProperties.getProperty(attribute.getName());
            if (Validator.isNull((String)key) && Validator.isNotNull((String)attribute.getFriendlyName())) {
                key = attributeMappingsProperties.getProperty(attribute.getFriendlyName());
            }
            if (Validator.isNull((String)key)) {
                if (attributeMappingsProperties.containsKey(attribute.getName())) continue;
                implicitMapping = true;
                key = attribute.getName();
            }
            List xmlValues = attribute.getAttributeValues();
            ArrayList<Serializable> values = (ArrayList<Serializable>)attributesMap.get(key);
            if (values == null) {
                values = new ArrayList<Serializable>(xmlValues.size());
            }
            for (XMLObject xmlObject : xmlValues) {
                Serializable value = SamlUtil.getXMLObjectValue(xmlObject);
                if (value == null) continue;
                if (implicitMapping) {
                    values.add(value);
                    continue;
                }
                values.add(0, value);
            }
            attributesMap.put(key, values);
        }
        return attributesMap;
    }

    public static AuthnRequest getAuthnRequest(MessageContext<?> messageContext) {
        InOutOperationContext inOutOperationContext = (InOutOperationContext)messageContext.getSubcontext(InOutOperationContext.class, false);
        if (inOutOperationContext == null) {
            return null;
        }
        MessageContext inboundMessageContext = inOutOperationContext.getInboundMessageContext();
        return (AuthnRequest)inboundMessageContext.getMessage();
    }

    public static EntityDescriptor getEntityDescriptorById(String entityId, EntitiesDescriptor descriptor) {
        List entityDescriptors = descriptor.getEntityDescriptors();
        if (entityDescriptors != null && !entityDescriptors.isEmpty()) {
            for (EntityDescriptor entityDescriptor : entityDescriptors) {
                if (!Objects.equals(entityDescriptor.getEntityID(), entityId)) continue;
                return entityDescriptor;
            }
        }
        return null;
    }

    public static EntityDescriptor getEntityDescriptorById(String entityId, XMLObject metadata) {
        if (metadata instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)metadata;
            if (Objects.equals(entityDescriptor.getEntityID(), entityId)) {
                return entityDescriptor;
            }
        } else if (metadata instanceof EntitiesDescriptor) {
            return SamlUtil.getEntityDescriptorById(entityId, (EntitiesDescriptor)metadata);
        }
        return null;
    }

    public static String getNameIdFormat(NameID nameID) {
        String format = nameID.getFormat();
        if (Validator.isNull((String)format)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        return format;
    }

    public static SingleLogoutService getSingleLogoutServiceForBinding(SSODescriptor ssoDescriptor, String binding) throws ResolverException {
        List singleLogoutServices = ssoDescriptor.getSingleLogoutServices();
        for (SingleLogoutService singleLogoutService : singleLogoutServices) {
            if (!binding.equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService;
        }
        throw new ResolverException("Binding " + binding + " is not supported");
    }

    public static SingleSignOnService getSingleSignOnServiceForBinding(IDPSSODescriptor idpSSODescriptor, String binding) throws ResolverException {
        List singleSignOnServices = idpSSODescriptor.getSingleSignOnServices();
        for (SingleSignOnService singleSignOnService : singleSignOnServices) {
            if (!binding.equals(singleSignOnService.getBinding())) continue;
            return singleSignOnService;
        }
        throw new ResolverException("Binding " + binding + " is not supported");
    }

    public static Date getValueAsDate(String key, Map<String, List<Serializable>> attributesMap) {
        List<Serializable> values = attributesMap.get(key);
        if (ListUtil.isEmpty(values)) {
            return null;
        }
        DateTime dateTime = new DateTime((Object)values.get(0));
        return dateTime.toDate();
    }

    public static DateTime getValueAsDateTime(String key, Map<String, List<Serializable>> attributesMap) {
        List<Serializable> values = attributesMap.get(key);
        if (ListUtil.isEmpty(values)) {
            return null;
        }
        return new DateTime((Object)values.get(0));
    }

    public static String getValueAsString(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        List values = attribute.getAttributeValues();
        if (values.isEmpty()) {
            return null;
        }
        return SamlUtil.getValueAsString((XMLObject)values.get(0));
    }

    public static String getValueAsString(String key, Map<String, List<Serializable>> attributesMap) {
        List<Serializable> values = attributesMap.get(key);
        if (ListUtil.isEmpty(values)) {
            return null;
        }
        return String.valueOf(values.get(0));
    }

    public static String getValueAsString(XMLObject xmlObject) {
        if (xmlObject instanceof XSAny) {
            XSAny xsAny = (XSAny)xmlObject;
            return xsAny.getTextContent();
        }
        if (xmlObject instanceof XSDateTime) {
            XSDateTime xsDateTime = (XSDateTime)xmlObject;
            return String.valueOf(xsDateTime.getValue());
        }
        if (xmlObject instanceof XSString) {
            XSString xsString = (XSString)xmlObject;
            return xsString.getValue();
        }
        return null;
    }

    public static Serializable getXMLObjectValue(XMLObject xmlObject) {
        if (xmlObject instanceof XSAny) {
            XSAny xsAny = (XSAny)xmlObject;
            return xsAny.getTextContent();
        }
        if (xmlObject instanceof XSBoolean) {
            XSBoolean xsBoolean = (XSBoolean)xmlObject;
            XSBooleanValue xsBooleanValue = xsBoolean.getValue();
            return xsBooleanValue.getValue();
        }
        if (xmlObject instanceof XSDateTime) {
            XSDateTime xsDateTime = (XSDateTime)xmlObject;
            return String.valueOf(xsDateTime.getValue());
        }
        if (xmlObject instanceof XSInteger) {
            XSInteger xsInteger = (XSInteger)xmlObject;
            return xsInteger.getValue();
        }
        if (xmlObject instanceof XSString) {
            XSString xsString = (XSString)xmlObject;
            return xsString.getValue();
        }
        return null;
    }

    public static AssertionConsumerService resolverAssertionConsumerService(MessageContext<?> messageContext, String binding) {
        AuthnRequest authnRequest = SamlUtil.getAuthnRequest(messageContext);
        Integer assertionConsumerServiceIndex = null;
        String assertionConsumerServiceURL = null;
        if (authnRequest != null) {
            assertionConsumerServiceIndex = authnRequest.getAssertionConsumerServiceIndex();
            assertionConsumerServiceURL = authnRequest.getAssertionConsumerServiceURL();
        }
        SAMLPeerEntityContext samlPeerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)samlPeerEntityContext.getSubcontext(SAMLMetadataContext.class);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)samlMetadataContext.getRoleDescriptor();
        for (AssertionConsumerService assertionConsumerService : spSSODescriptor.getAssertionConsumerServices()) {
            if (!binding.equals(assertionConsumerService.getBinding())) continue;
            Integer curAssertionConsumerServiceIndex = assertionConsumerService.getIndex();
            if (assertionConsumerServiceIndex != null && curAssertionConsumerServiceIndex.intValue() == assertionConsumerServiceIndex.intValue()) {
                return assertionConsumerService;
            }
            if (!Validator.isNotNull((String)assertionConsumerServiceURL) || !assertionConsumerServiceURL.equals(assertionConsumerService.getLocation())) continue;
            return assertionConsumerService;
        }
        for (AssertionConsumerService assertionConsumerService : spSSODescriptor.getAssertionConsumerServices()) {
            if (!binding.equals(assertionConsumerService.getBinding())) continue;
            return assertionConsumerService;
        }
        return null;
    }

    public static SingleLogoutService resolveSingleLogoutService(SSODescriptor ssoDescriptor, String preferredBinding) {
        List singleLogoutServices = ssoDescriptor.getSingleLogoutServices();
        for (SingleLogoutService singleLogoutService : singleLogoutServices) {
            if (!preferredBinding.equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService;
        }
        if (!singleLogoutServices.isEmpty()) {
            return (SingleLogoutService)singleLogoutServices.get(0);
        }
        return null;
    }

    public static SingleSignOnService resolveSingleSignOnService(IDPSSODescriptor idpSSODescriptor, String preferredBinding) {
        List singleSignOnServices = idpSSODescriptor.getSingleSignOnServices();
        for (SingleSignOnService singleSignOnService : singleSignOnServices) {
            if (!preferredBinding.equals(singleSignOnService.getBinding())) continue;
            return singleSignOnService;
        }
        if (!singleSignOnServices.isEmpty()) {
            return (SingleSignOnService)singleSignOnServices.get(0);
        }
        return null;
    }
}

