/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.processor;

import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.field.expression.handler.FieldExpressionHandler;
import com.liferay.saml.opensaml.integration.field.expression.handler.registry.FieldExpressionHandlerRegistry;
import com.liferay.saml.opensaml.integration.processor.Processor;
import com.liferay.saml.opensaml.integration.processor.context.ProcessorContext;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Function;

public abstract class BaseProcessorImpl<M extends BaseModel<M>, PC extends ProcessorContext<M>, FEH extends FieldExpressionHandler<M, PC>, FEHR extends FieldExpressionHandlerRegistry<M, PC, FEH>>
implements Processor<M> {
    private final FEHR _fieldExpressionHandlerRegistry;
    private final Map<Class<?>, Map<String, Object[]>> _maps = new HashMap();
    private M _model;
    private final Map<Map.Entry<Class<?>, Serializable>, Object> _objectCache = new HashMap();
    private final Queue<Map.Entry<Integer, UnsafeConsumer<ServiceContext, ?>>> _unsafeConsumers = new PriorityQueue<Map.Entry>(Comparator.comparingInt(Map.Entry::getKey));

    public BaseProcessorImpl(M model, FEHR fieldExpressionHandlerRegistry) {
        this._model = model;
        this._fieldExpressionHandlerRegistry = fieldExpressionHandlerRegistry;
    }

    @Override
    public M process(ServiceContext serviceContext) throws PortalException {
        this._preparePatches();
        this._consumePatches(serviceContext);
        return this._model;
    }

    @Override
    public <T, V extends T> void setValueArray(Class<T> clazz, String fieldExpression, V[] value) {
        Map<String, Object[]> map = this._maps.get(clazz);
        if (map == null) {
            map = new HashMap<String, Object[]>();
            this._maps.put(clazz, map);
        }
        map.put(fieldExpression, value);
    }

    @Override
    public void setValueArray(String fieldExpression, String[] value) {
        this.setValueArray(String.class, fieldExpression, value);
    }

    protected abstract PC getProcessorContext(String var1);

    private void _consumePatches(ServiceContext serviceContext) throws PortalException {
        try {
            Map.Entry<Integer, UnsafeConsumer<ServiceContext, ?>> entry;
            while ((entry = this._unsafeConsumers.poll()) != null) {
                UnsafeConsumer<ServiceContext, ?> unsafeConsumer = entry.getValue();
                unsafeConsumer.accept((Object)serviceContext);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof PortalException) {
                throw (PortalException)throwable;
            }
            throw new PortalException(throwable);
        }
    }

    private <T extends BaseModel<T>> T _patchModel(String publicIdentifier, Function<M, T> modelGetterFunction, Queue<UnsafeConsumer<T, ?>> unsafeConsumers, ProcessorContext.UpdateFunction<T> updateFunction, ServiceContext serviceContext) throws Throwable {
        UnsafeConsumer<T, ?> unsafeConsumer;
        BaseModel tNew;
        BaseModel model = (BaseModel)modelGetterFunction.apply(this._model);
        boolean mappedModel = false;
        if (model != this._model) {
            if (publicIdentifier == null) {
                throw new SystemException("Mapped models must have a public identifier");
            }
            mappedModel = true;
        } else if (publicIdentifier != null) {
            throw new SystemException("The processing model cannot have a public identifier");
        }
        AbstractMap.SimpleEntry objectKey = new AbstractMap.SimpleEntry(model.getClass(), publicIdentifier);
        BaseModel object = (BaseModel)this._objectCache.get(objectKey);
        if (object != null) {
            tNew = object;
            model = (BaseModel)object.clone();
        } else {
            tNew = model;
            model = null;
        }
        while ((unsafeConsumer = unsafeConsumers.poll()) != null) {
            unsafeConsumer.accept((Object)tNew);
        }
        tNew = updateFunction.update(model, tNew, serviceContext);
        this._objectCache.put(objectKey, tNew);
        if (!mappedModel) {
            this._model = tNew;
        }
        return (T)tNew;
    }

    private void _preparePatches() {
        for (String prefix : this._fieldExpressionHandlerRegistry.getFieldExpressionHandlerPrefixes()) {
            Object fieldExpressionHandler = this._fieldExpressionHandlerRegistry.getFieldExpressionHandler(prefix);
            fieldExpressionHandler.bindProcessorContext(this.getProcessorContext(prefix));
        }
    }

    public class ProcessorContextImpl
    implements ProcessorContext<M> {
        private final String _prefix;

        public ProcessorContextImpl(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public <T extends BaseModel<T>> ProcessorContext.Bind<T> bind(Function<M, T> modelGetterFunction, int processingIndex, String publicIdentifier, ProcessorContext.UpdateFunction<T> updateFunction) {
            return new BindImpl<T>(modelGetterFunction, processingIndex, this, publicIdentifier, updateFunction);
        }

        @Override
        public ProcessorContext.Bind<M> bind(int processingIndex, ProcessorContext.UpdateFunction<M> updateFunction) {
            return new BindImpl(Function.identity(), processingIndex, this, null, updateFunction);
        }

        @Override
        public <V> V getValue(Class<V> clazz, String fieldExpression) {
            V[] values = this.getValueArray(clazz, fieldExpression);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        @Override
        public <V> V[] getValueArray(Class<V> clazz, String fieldExpression) {
            Map map;
            if (!Validator.isBlank((String)this._prefix)) {
                fieldExpression = this._prefix + ':' + fieldExpression;
            }
            if ((map = (Map)BaseProcessorImpl.this._maps.get(clazz)) == null) {
                return null;
            }
            return (Object[])map.get(fieldExpression);
        }
    }

    public class BindImpl<T extends BaseModel<T>>
    implements ProcessorContext.Bind<T> {
        private final Queue<UnsafeConsumer<T, ?>> _patchingQueue = new LinkedList();
        private final ProcessorContext<M> _processorContext;

        public BindImpl(Function<M, T> modelGetterFunction, int processingIndex, ProcessorContext processorContext, String publicIdentifier, ProcessorContext.UpdateFunction<T> updateFunction) {
            this._processorContext = processorContext;
            BaseProcessorImpl.this._unsafeConsumers.add(new AbstractMap.SimpleEntry<Integer, UnsafeConsumer>(processingIndex, serviceContext -> BaseProcessorImpl.this._patchModel(publicIdentifier, modelGetterFunction, this._patchingQueue, updateFunction, serviceContext)));
        }

        public <V> void handleUnsafeObjectArray(String fieldExpression, Class<V> clazz, UnsafeBiConsumer<T, V[], ?> unsafeBiConsumer) {
            Object[] values = this._processorContext.getValueArray(clazz, fieldExpression);
            if (values == null || values.length == 0) {
                return;
            }
            this._patchingQueue.add(object -> unsafeBiConsumer.accept(object, (Object)values));
        }

        @Override
        public void handleUnsafeStringArray(String fieldExpression, UnsafeBiConsumer<T, String[], ?> unsafeBiConsumer) {
            this.handleUnsafeObjectArray(fieldExpression, String.class, unsafeBiConsumer);
        }

        @Override
        public void mapBoolean(String fieldExpression, BiConsumer<T, Boolean> biConsumer) {
            this.handleUnsafeStringArray(fieldExpression, (object, values) -> {
                for (String value : values) {
                    biConsumer.accept(object, GetterUtil.getBoolean((String)value));
                }
            });
        }

        @Override
        public void mapBooleanArray(String fieldExpression, BiConsumer<T, boolean[]> biConsumer) {
            this.handleUnsafeStringArray(fieldExpression, (object, value) -> {
                boolean[] booleanArray = new boolean[((String[])value).length];
                for (int i = 0; i < booleanArray.length; ++i) {
                    booleanArray[i] = GetterUtil.getBoolean((String)value[i]);
                }
                biConsumer.accept(object, booleanArray);
            });
        }

        @Override
        public void mapLong(String fieldExpression, BiConsumer<T, Long> biConsumer) {
            this.handleUnsafeStringArray(fieldExpression, (object, values) -> {
                for (String value : values) {
                    biConsumer.accept(object, Long.parseLong(value));
                }
            });
        }

        @Override
        public void mapLongArray(String fieldExpression, BiConsumer<T, long[]> biConsumer) {
            this.handleUnsafeStringArray(fieldExpression, (object, value) -> {
                long[] longArray = new long[((String[])value).length];
                for (int i = 0; i < longArray.length; ++i) {
                    longArray[i] = GetterUtil.getLong((String)value[i]);
                }
                biConsumer.accept(object, longArray);
            });
        }

        @Override
        public void mapString(String fieldExpression, BiConsumer<T, String> biConsumer) {
            this.handleUnsafeStringArray(fieldExpression, (object, values) -> biConsumer.accept(object, values[0]));
        }

        @Override
        public void mapStringArray(String fieldExpression, BiConsumer<T, String[]> biConsumer) {
            this.handleUnsafeStringArray(fieldExpression, (object, values) -> biConsumer.accept((Object)object, (String[])values));
        }

        @Override
        public void mapUnsafeString(String fieldExpression, UnsafeBiConsumer<T, String, ?> unsafeBiConsumer) {
            this.handleUnsafeStringArray(fieldExpression, (object, values) -> unsafeBiConsumer.accept(object, (Object)values[0]));
        }
    }
}

